







ExtraDOS Toolbox (tm)
_______________________________________

  Users Manual




















Copyright (c) 1985-95 HyperWare  All Rights Reserved


Introduction
_____________________________________________________________________


ExtraDOS Toolbox is a compilation of tools useful to Microsoft DOS
users.  I originally wrote the first version of ExtraDOS under MS-DOS
because I found a need for them and there were no commercially
available products that provided these functions.  Some ExtraDOS tools
were designed to enhance programs already found in MS-DOS.  Other
tools were familiar to the Unix world, but were not available in
MS-DOS.  Over the years this collection has grown into large group of
very useful tools.  Some of these utilities are duplicates of those
found elsewhere, but often provide much better features or reduced
memory overhead than similar utilities found elsewhere.  In addition,
ExtraDOS complements PC-Tools and Norton Utilities with added tools
these programs do not provide.

Over thirty of the ExtraDOS Toolbox utilities have been selected by
Paul Somerson, former Executive Editor of PC Magazine, for Bantam
Books', DOS Power Tools, 2nd Edition, Revised and Expanded for DOS
5.0.  Many of the ExtraDOS Toolbox utilities are now appearing in many
popular DOS books that feature shareware enhancements for DOS.

I hope you find these tools useful and convienent.  Any suggestions
for enhancements, improvements or additions are welcome.  Please
contact use with your comments.


David R. Foley


License Agreement
_____________________________________________________________________


  This software is protected by both United States' copyright law and
  international treaty provisions. Therefore, you must treat this
  software "just like a book," with the following single exception.
  HyperWare authorizes you to make archival copies of the software for
  the sole purpose of backing up our software and protecting your
  investment from loss. By saying, "just like a book," HyperWare means
  that this software may be used by any number of people and may be
  freely moved from one computer location to another, provided there
  is absolutely no possibility of it being used at one location while
  it is being used at another. Just as a book cannot be read by two
  different people in two different places simultaneously, the
  software may not be used by two different people in two different
  places simultaneously.

  You may not make copies of the software documentation or disk,
  except as described above. You may not distribute, rent, sublicense,
  or lease the software or the documentation. You may not alter,
  modify, or adapt the software or documentation, including but not
  limited to translating, decompiling, reverse assembling, or creating
  derivative works. You may not use the software in a network,
  timeshareing, multiple CPU, or multi- user environment unless each
  user is licensed by HyperWare.


EXTRADOS TOOLBOX
_____________________________________________________________________


LIMITED WARRANTY

  Upon notification of defects in material or workmanship, within the
  warranty period of 45 days from the date of purchase, HyperWare
  will, at its option, replace the defective diskette or refund the
  license fee. If you need to return a product, call the HyperWare
  Technical Support Service Department to obtain a return
  authorization number. The remedy for breach of this warranty shall
  be limited to replacement or refund and shall not encompass any
  other damages, including but not limited to loss of profit, and
  special, incidental, consequential, or other similar claims.

  HyperWare specifically disclaims all other warranties, expressed or
  implied, including but not limited to implied warranties of
  merchantability and fitness for a particular purpose with respect to
  defects in the diskette and documentation, and the program license
  granted herein in particular, and without limiting operation of the
  program license with respect to any particular application, use, or
  purpose. In no event shall HyperWare be liable for any loss of
  profit or any other commercial damage, including but not limited to
  special, incidental, consequential, or other damages. This statement
  shall be construed, interpreted, and governed by the laws of the
  State of California.


TRADEMARK INFORMATION

  ExtraDOS Toolbox, TurboBAT, SpeedRAM, Screen Manager, Profiler,
  WizLabel, CDBS, Press Gate Manager, ExtraWindows Toolbox and Safety
  Disk are trademarks of HyperWare.

  MS-DOS and Windows are trademarks of Microsoft Corporation.

  Norton Utilities are a trademark of Symantec.

  PC-Tools is a trademark of Central Point Software.


Table of Contents
_____________________________________________________________________


SUBJECT

  Introduction.............................................
  License Agreement........................................
  Limited Warranty.........................................
  Trademark Information....................................
  Table of Contents........................................

  ADDCOMM      Serial Port Management Program..............
  ALARMCLK     Alarm Clock Program.........................
               MAKETUNE....................................
  ALLSUB       Perform Task In All Subdirectories..........
  AREACODE     Telephone Area Code Search Utility..........
  BANNER       DOS Banner Display..........................
  BATPLUS      Batch File Enhancments......................
  BIGECHO      Big Text Display............................
  BOOT         PC Rebooting Utility........................
  BOOTCTL      Setup Boot Sector of a Floppy Diskette......
  BOOTLOCK     Lock Out Reboot Keys and Break Keys.........
  BRKBOX       COM Port Break Out Box Display..............
  CALENDAR     DOS Calendar Display........................
  CAT          DOS Cat Text File Utility...................
  CHANGE       Modify File.................................
  CHIMES       DOS Clock Chimes............................
  CLEANFL      Floppy Drive Cleaning Program...............
  CLEANUP      Cleanup Your Drives from Duplicate Files....
  COMMODE      Configure serial ports......................
  COUNT        Count Characters, Words and Lines...........
  CURLOCK      Lock Cursor Shape Permanently...............
  CURSOR       Change Cursor Shapes........................
  CUT          DOS Cut Text File Utility...................
  CUTPASTE     DOS Cut & Paste Text Utility................
  DELAY        Batch File Delay Utility....................
  DETAB        File Detabulation Utility...................
  DISKINFO     Disk Drive Information Reporter.............
  EDENV        Modify environtment variables...............
  EDIT         Full Screen Text File Editor................
  EVAL         DOS Command Line Calculator.................
  FILEATTR     Change File Attributes......................
  FILEINFO     File Information Program....................
  FILESIZE     File Size Listing Utility...................
  FILETREE     File Directory Tree Listing Utility.........
  FINDFILE     Find File on Disk...........................
  HEXDUMP      File Hex Display Utility....................
  HUSH         Speaker Silencing Utility...................
  KILLDIR      Remove Directory and All Contents...........


Table of Contents
_____________________________________________________________________


  LASER        Control HP Laser Jet from DOS...............
  LS           DOS Listing Utility.........................
  MONITOR      Monitor Convergence/Alignment/Focus Test....
  MOVE         MOVE Files Across Disks.....................
  NAMEDIR      Name Directory Utility......................
  NO           DOS File Exclusion Utility..................
  PATHFIND     Path Find File Utility......................
  PSPRINT      PostScript Text File Print Utility..........
  RAMDRIVE     High Speed Ram Drive........................
  SCRNATTR     Set Screen Attributes.......................
  SCROLLBK     Scroll Back pages of Video Display..........
  SPEEDRAM     Speed up CPU by Reducing Refresh............
  TEXTSRCH     Text Searching Utility......................
  TIDY         Tidy up Hard Drive by Removing Old Files....
  TIMBER       Cut the begginning of a file down...........
  TOUCH        Touch File Date Utility.....................
  TURBOBAT     Turbo Batch File Compiler...................
  TURBOTXT     Turbo Text File Compiler....................
  UNHANG       Break Out of Locked Programs................
  USEMEM       Programmers Memory Usage Utility............
  USEMOUSE     Use Mouse to Emulate Keystrokes.............
  VIDMODE      Setup Video Display Mode....................
  VIEW         View any MS-DOS File........................
  VOLLABEL     Disk Volume Label Update Utility............

  Technical Support........................................
  Credits..................................................
  HyperWare Products.......................................



ADDCOMM - Add Communications Port Information
_____________________________________________________________________


DESCRIPTION

  ADDCOMM is a utility that allows you to define the address of your
  COM ports in the DOS lower memory segment.  This is useful for
  machines whose BIOS doesn't support COM3 and COM4 ports by default.
  In many older machines including early 80386 based systems, the BIOS
  would only setup COM1 and COM2 for DOS.  Newer serial cards and
  modems allow you to define COM3 and COM4 on the cards but these
  machines won't allow DOS to see these additional ports unless you
  place the corresponding address in low DOS memory.  ADDCOMM will
  place this information in the correct location for you.

  ADDCOMM will display the current address values for any COM
  ports that are installed in your system.  By placing the ADDCOMM
  statements in your AUTOEXEC.BAT file you can have the machine load
  the correct values without having to intervene.  ADDCOMM is not a
  TSR and will not require any overhead memory to setup your ports
  from AUTOEXEC or the DOS prompt.


VERSION

  5.00  07/07/95


COMMAND FORMAT

  ADDCOMM [port] [address]


  [port]     is the COM port to add.

  [address]  is the address of the COM port being added.



EXAMPLE

  ADDCOMM COM3 3E8    will tell DOS to address COM3 at address 3E8.



ADDCOMM - Add Communications Port Information
_____________________________________________________________________


NOTES


  Certain makes of BIOS do not support beyond COM2. This means that at
  the power-up equipment check they do not add COM3 and COM4 to the
  low-memory equipment list and/or do not add the appropriate base
  addresses to the BIOS data area even if you may have a modem or
  I/O card configured as COM3 or COM4.

  This same problem seems to occur occasionally because of
  conflicts between various boards.

  The equipment list may be incorrect if an internal modem is
  installed as COM2 (or COM3 or COM4) with no COM1 serial port in the
  computer.

  The result of all these problems is that any serial I/O involving
  DOS redirection will not work properly. For instance, one may use
  COM3 successfully with a terminal program until "shelling out of
  Host Mode," which often involves DOS CTTY redirection. Another
  symptom would be a "WRITE FAULT ERROR WRITING DEVICE COMx" following
  simple redirection such as "DIR >COMx."

  ADDCOMM will write information about your serial ports into the
  appropriate low-memory areas. It may be used to make your system
  aware of your specific serial hardware.

  If the COM port is already listed in the low-memory equipment list,
  ADDCOMM will simply change the base address to what you specify in
  the second argument to the command. Typing ADDCOMM alone will show
  what ports are currently in the equipment list along with their base
  addresses.

  A typical use of ADDCOMM would be to put the line ADDCOMM COM3 3E8
  in the autoexec.bat file for BIOS versions that do not support COM3.



ADDCOMM - Add Communications Port Information
_____________________________________________________________________


COMMON SERIAL PORT BASE ADDRESSES

  COM1 - 3F8        the addresses for COM1 and COM2
  COM2 - 2F8        are pretty much a standard

  COM3 - 3E8        these addresses for COM3 and COM4 are
  COM4 - 2E8        are common, though it's sometimes reversed


PS/2 SERIAL PORT BASE ADDRESSES

  COM1 - 3F8
  COM2 - 2F8
  COM3 - 3220
  COM4 - 3228




ALARMCLK - DOS Alarm Clock
_____________________________________________________________________


DESCRIPTION

  ALARMCLK provides multiple alarm clocks and gong/chime function
  into a single program.

  Four alarms are available.  The music for each is fully
  configurable. The program MAKETUNE.EXE is provided to create
  new music files.


VERSION

  5.00  06/14/95


RESIDENT MEMORY USAGE

  4,000 Bytes


COMMAND FORMAT

  ALARMCLK [/S[r][s][n]=hh:mm] [/An] [/Dn] [/U] [/M] [/V] [/Cn] [/G] [/NOH]

  /S[r][s][n]=hh:mm

  Sets an alarm.

    r       time is relative to the current time, e.g.
            /Sr1=00:05 sets the alarm 5 minutes from now.



    n       Alarm number (1, 2, 3, or 4).  If omitted, the first unused alarm
            is set.

    hh:mm   Time of the alarm in 24 hour format.  If a 'r' was specified then
            the hours and minutes from now for the alarm.


  /A#    Enable or disable alarms, '#' is the alarm number or * to suspend
          all alarms.  + enables the alarm - disables the alarm.

  /D#     Delete an alarm, '#' is the alarm number or * to delete all alarms.

  /U      Unload AlarmClk from memory, if possible.

  /M      Use monochrome attributes.  Oddball systems (especially laptops may
          fool AlarmClk into using color on a monochrome system.  Use this
          switch to force black and white mode.

  /V     Enable or disable snow supression.  If you have an old style CGA
          monitor (are these still around?) you may need to use /V+ to supress
          video snow.

ALARMCLK - DOS Alarm Clock
_____________________________________________________________________


  /Cn     Freqency of chiming. Where n=
            1, hourly
            2, half hour
            4, quarter hour

  /G     Enable or disable hour gonging.  When enabled, the hour will be
          'gonged', e.g. 10 gongs at 10 o'clock.

  /NOH    Supress display of the header.  Registered version only.


To specify the music to play for each alarm modify the file ALARMCLK.CFG.
The file must contain four files, one to a line, with no blank lines. The
first filename is the music file for alarm 1, the second for alarm 2, and
so on. The extension .ACF is used if not specified. ALARMCLK.CFG and all
speficied music files must be in the current directory when ALARMCLK is
initially installed.

MAKETUNE Compiler
_____________________________________________________________________


DESCRIPTION

  MAKETUNE is a small utility that will allow you to make tunes that can be
  used in the ALARMCLK utility.


COMMAND FORMAT

  MAKETUNE [/P] filename[.ext]


  /P    indicates to play the tune after compiling it. You can press ESC to
        halt the playback. If the filename extension is omitted ".TUN" will
        be used. The output file will have the same name with the extension
        of ".ACF".



TUNE FORMAT

  frequency duration [intr]


  FREQUENCY is the self explanitory. It is the frequency of the note to
  play. If you wish to have a rest you can specify SILENCE as the
  frequency.

  DURATION is the length of the note in clock ticks (can be modified by the
  TEMPO command, see below).

  INTRA is the the amount of rest (in ticks) between notes. If omitted the
  default of 1 will be used or the value set by the INTRA command (see
  below).


SPECIAL COMMANDS

    REPEAT n

        Sets the number of times the tune is played by ALARMCLK.
        If not specified the default of 1 will be used.  You
        should only use this command once.

    TEMPO n

        Adjusts the tempo of the tune.  The "duration" will be
        multiplied by this integer.  For example, if the tempo is
        set to 4 then all durations from that point on will be
        multiplied by four.  The default tempo is 1.  You may use
        this command as often as you wish.

    INTRA n

        Sets the default intranote rest for notes that do not
        specify it.  The default, if this command is omitted, is
        1.  You may use this command as often as you wish.

MAKETUNE Compiler
_____________________________________________________________________


Example:

REPEAT  5
INTRA 0
600 1
700 1
800 1
900 1
800 1
700 1
SILENCE 4

ALLSUB - Perform a Task in All Subdirectories
_____________________________________________________________________


DESCRIPTION

  Allsub allows you to run any command or program in the current
  directory as well as in all subdirectories of the current directory.
  This is useful for deleting groups of files or performing tasks with
  programs that don't normally allow for subdirectories.  As the
  command is performed in each subdirectory ALLSUB will display the
  directory of execution.


VERSION

  5.00 06/18/95


COMMAND FORMAT

  ALLSUB [command]

  [command]   is any valid DOS command or program.


AREACODE - Area Code Search Program
_____________________________________________________________________


DESCRIPTION

  AREACODE is a utility that will help you locate a region to which an
  area code applies or to locate the area code for a specific region.


VERSION

  5.00  06/26/95


RESIDENT MEMORY USAGE

  Approximately 7000 bytes.


COMMAND FORMAT

  AREACODE [/C:code] [/C:string] [/L][/U][/?][/NOH][/K$nn][/E]

  code     is any 3 number area code.

  string   is any string that might match a state or region that you
           are searching for.


AREACODE - Area Code Search Program
_____________________________________________________________________


  /C:x   Immediately search for matching areacode, city, state, or
         region.

  /L     Load as a TSR.  This will make the AREACODE program a popup
         TSR that will allow you to call up an area code or location
         while running another application without exiting to DOS.
         [CTRL][LSHIFT]A is the default "HOT KEY" for activating as a
         TSR.  See the /K parameter for changing the "HOT KEY"
         definition.  If your machine has EMS available then AREACODE
         will swap it's main portion of code to EMS using as little
         Conventional memory as possible.  If you wish to force
         AREACODE to swap to disk use the /E parameter


  /U     Will uninstall the AREACODE program if it is installed as a
         TSR freeing up the overhead that it required.  Uninstall will
         only work if AREACODE was the last TSR loaded on the Heap.
         If the program is unable to uninstall it will inform you when
         running the /U parameter.

  /NOH   If running AREACODE from a batch file or from another shell
         program you might sometimes wish to have it not display the
         header information.  /NOH tells AREACODE to not display the
         header (Registered version only).

  /K:nnn  Define hotkey for TSR activation (see notes below)

  /E     Forces TSR to swap to Disk rather than using EMS.


AREACODE - Area Code Search Program
_____________________________________________________________________


USER DEFINED KEYS

  To specify a different key to activate the TSR use the /K:
  switch followed by the string representation of the keystroke.
  Shifting keys must be first, the actual scan code key, and only
  one is allowed, must be last.  Spaces are not allowed anywhere
  in the key string.  "Named" keys are enclosed in square
  brackets.  The following named strings are recognized:

        [Space]
        [Slash]  (/)
        [Esc]
        [Minus]  (-)
        [Bksp]
        [Tab]
        [Enter]
        [Grey*]
        [Caplock]
        [Numlock]
        [ScrollLock]
        [Home]
        [UpAr]
        [PgUp]
        [GreyMinus]
        [LftAr]
        [Pad5]
        [RgtAr]
        [GreyPlus]
        [End]
        [DnAr]
        [PgDn]
        [Ins]
        [Del]
        [Alt]
        [Ctrl]
        [Shift]         (either shift keys is recognized)
        [LeftShift]     (only the left shift key is recognized)
        [RightShift]    (only the right shift key is recognized)

AREACODE - Area Code Search Program
_____________________________________________________________________


Examples of valid hotkeys:

        [Ctrl][Alt]Q

        [Ctrl][Alt]                      note, [Alt] is the scan key

        [LeftShift][RightShift]X         both shifts required

        [Shift][Ins]                     Either or both shifts will
                                         work

Invalid hotkeys:

        [Ctrl] [Alt] Q                   has spaces

        [Ctrl]Alt                        no brackets on Alt

        [LShift][RShift]X                spelling errors

        [Ctrl]-                          should be [Minus]

When parsing the strings the input is converted to uppercase, the
following are all identical when parsed:

        [Ctrl][Alt]C

        [ctrl][alt]c

        [CTRL][ALT]C


BANNER - Generate a Large Type Banner on Printer
_____________________________________________________________________


DESCRIPTION

  BANNER allows you to create a large banner using a standard ASCII
  printer.  BANNER contains an internal representation of the alphabet
  that is made up of standard ASCII characters and will print any
  message on your printer in a sideways banner fashion.  Banner
  Displays an ASCII rendition of the letters you put in a message
  rotated at 90 degrees.  This is based on the BANNER that is
  available in many UNIX systems.


VERSION

  5.00  06/14/95


COMMAND FORMAT

  BANNER [/?][/Wnn][/PLPTn][/S][/Ofile][/NOH] [message]

  /?         Displays Help

  /Wnn       Set the Column width to nn characters.  If no number is
             specified then the width is set to 132.  (Default 80)

  /PLPTn     Specify Printer Port.  Default is to LPT1.

  /S         Send output to Screen rather than printer.

  /Ofile     Send output to a text file with name specified rather
             than printer.

  /NOH       Suppress the header information


BATPLUS - Batch file enhancement utility
_____________________________________________________________________


  BatPlus is a batch file enhancement utility.  It provides
  numerous commands to retrieve information at place it in the
  environment.


VERSION

  5.00 07/06/95


DESCRIPTION

  Normally, when data is returned to the environment it is placed
  in the BATPLUS= variable.  The default variable can be changed
  by preceding the BatPLus command with "VARNAME=", e.g.

     BATPLUS WHEN=TIME

   or

     BATPLUS WHEN= TIME

  In both these examples the environment variable WHEN is set to
  the current time.


BATPLUS COMMANDS

BOX left top right bottom frameattribute [headerattribute header]
  Draws a box.  FRAMEATTRIBUTE specifies the color of the frame,
  HEADERATTRIBUTE specifies the color of the header.  [HEADER] is
  a string to be placed on the top left frame.

    BATPLUS BOX 10 5 40 20 1 112 Special Information

  This example displays a box with a blue on black frame and a
  black on white header.  The header is always displayed centered
  on the top frame.

  The minimum row and column values are 1.  The maximum column is
  normally 80.  The maximum row is normally 25 or 50.

  See the appendix on color attributes near the end of this
  document for color code information.

CDD d:path
  Changes the drive AND path.  Same syntax as CD.  Note, CD does
  not change the drive.

    BATPLUS CDD D:\MYSTUFF

COLUMN
  Returns the current cursor column to the environment.

COLUMNS
  Returns the screen width to the environment.

CPU
  Returns the CPU type:  88, 86, 188, 186, 20 (V20), 30 (V30),
  286, 386, or 486.

BATPLUS - Batch file enhancement utility
_____________________________________________________________________


CURSOR [NORMAL|HIDDEN|FAT|BLOCK|TOP BOTTOM]
  Sets the cursor shape.  Four cursor shapes are predefined.
  Alternately, you can specify the pixel rows for the top and
  bottom of the cursor.  On a standard EGA/VGA monitor the legal
  range is 0-7.  On a standard monochrome the range is 0-12.
  Note, 4DOS normally resets the cursor shape just before the
  control is allowed at the prompt.

    NORMAL sets the cursor shape to what is normally considered
      standard for the monitor type.

    HIDDEN attemps to hide the cursor completely.

    FAT sets it to about half the character height.

    BLOCK attempts to to use the full character height.

  Some usuual video cards will fool BATPLUS into using incorrect
  values for the various cursor shapes.  Other than using "TOP
  BOTTOM" to force a specific cursor shape, there isn't much that
  can be done under those unusual situations.

CWD Returns the current drive and path,
  e.g. C:\UTIL

CWDS
  Same as CWD but appends a backslash if needed, e.g. "C:\UTIL\".

DATE [mask]
  Returns the current date.  If "mask" is omitted the date is
  formatted according to the country code.  See the appendix
  DATE/TIME MASK for additional information.

DAY
  Returns the day of the month.

DECR
  Decrements the environment default environment variable if it
  is a number, does nothing if the variable is not a number.

DISK
  Returns the current drive letter without a colon, e.g. "C".

DISKFREE [d]
  Returns the number of unused bytes on the specified drive or
  the current drive if none specified.  Returns -1 if the drive
  is invalid.

BATPLUS - Batch file enhancement utility
_____________________________________________________________________


DISKTYPE [d:]
  Returns the drive type as a number.

   Code     Drive Type
    1       360k floppy
    2       720k floppy
    3       1.2M floppy
    4       1.44M floppy
    5       Other floppy type
    6       Bernoulli
    7       Hard drive
    8       Ramdisk
    9       Substituted drive
    10      Unknown disk type
    11      Invalid drive
    12      Novell Netware network drive
    13      CD-ROM drive

DOSVER
  Returns the current DOS version to the environment.

DOW
  Returns the day of week string to the environment, e.g.
  "Thursday".

DOY
  Returns the current day of the year, 1-365 (a maximum of 366 is
  possible on the last day of a leap year).

ENVFREE
  Returns the number of free bytes in the environment.  Note,
  since this function modifies the environment the actual amount
  of unused environment space could be different by a few bytes.

EXT filename
  Returns the extension of the given filename.
    BATPLUS EXT THIS.EXE

  The returned extension is "EXE".

FILENAME filename
  Returns the name and extension of the filename, no path.

    BATPLUS FILENAME C:\DOS\COMMAND.COM

  The returned filename is "COMMAND.COM".

FULL filename
  Returns the fully qualified filename.  An incomplete path will
  be expanded to its full name, e.g. "..\THEFILE.EXT" might be
  expanded to "C:\SUBDIR\THEFILE.EXT".

HOUR
  Returns the current hour in a 24 hour day.  At 3:35pm this
  command would return '15' to the environment.

BATPLUS - Batch file enhancement utility
_____________________________________________________________________


INCR [variable]
  Increments the environment environment variable if it is a
  number, does nothing if the variable is not a number.

    BATPLUS INCR            ; increments variable BATPLUS=
    BATPLUS LOOP=INCR       ; increments variable LOOP=

INKEY [/Wnnn] [/U] [text]
  Displays TEXT and waits for a single keystroke.  You can
  specify a maximum wait period (in seconds) with the /W
  parameter. The /U parameter will force alpha characters to
  uppercase.  Specifing a wait of 0 causes the command to return
  immediately if no keystrokes are waiting.

    INKEY /U Do you wish to continue?
    IF "%BATPLUS" == "Y" GOTO continue

LOWER string
  Converts STRING to lowercase and returns it to the environment.

    BATPLUS LOWER %BATPLUS%

  Using the current value of BATPLUS=, replace it with the
  lowercase equivelent.

MATH expression
  Evaluates the mathmatical expression (algebraic notation).  The
  following operators are supported:

    + - * /     Basic math functions
    ()          Parenthesis, for forcing evaluation order
    ABS(x)      Absolute value
    ARCTAN(x)   Arctangent
    COS(x)      Cosine
    EXP(x)      Exponential
    LN(x)       Natural Log
    SIN(x)      Sine
    SQR(x)      Square, e.g. x*x
    SQRT(x)     Square root
    PI          Pi, 3.141592654

  The trigonomic functions expect and return the values in radians.
  Order of evaluation follow the standard rules of mathematics and are affected by parenthesis.

    BATPLUS MATH (1+2)*3
    BATPLUS MATH 1+2*3

  The result of the first example is 9, the second is 7.

MINUTE
  Returns the current minute, e.g. '35' if the time is 3:35pm.

MONTH
  Returns the current month, 1-12.

BATPLUS - Batch file enhancement utility
_____________________________________________________________________


NAME filename
  Returns the name (no path or extension) of the filename.  Given
  "C:\DOS\COMMAND.COM", returns "COMMAND".

NDP
  Returns the type of math co-processor:  0 (none), 87, 287, 387,
  487.

PATH filename
  Returns the path of the specified filename.  Given
  "C:\DOS\COMMAND.COM", returns "C:\DOS".

RANDOM [n]
  Returns a pseudo-random integer from 1 to N or a floating point
  number in the range 0 < N <1.  This function will uses the
  environment variable SEED as a seed for the random number
  generator.  If SEED does not exist it will be created using the
  TIME as the initial seed.

ROW
  Returns the row of the cursor to the environment.

ROWS
  Returns the height in lines of the screen.

SCREEN row col text
  Direct screen writes the text at the specified row and column
  without changing the attribute.  The top row and column is 1 in
  both cases.  After writing, the cursor is moved to the end of
  the text.

SEARCH filename
  Searches the PATH for the specified file and returns the fully
  qualified filename to the environment if found or clears the
  variable if not found.  This function does not support wild
  card characters in the filename.

    BATPLUS SEARCH XCOPY.EXE

SECOND
  Returns the current seconds.

SERIALNO [drive:]
  Returns the serial number of the drive (current drive if not
  specified) to the environment.  Serial numbers require the disk
  has been formatted under DOS 4.0 or later, otherwise zero (0)
  will be returned.

SUBSTR start length string
  Returns a substring of the specified string starting the START
  character and consisting of LENGTH characters.  If LENGTH is
  omitted the rest of the string is returned.  Enclose STRING in
  double quotes to avoid stripping leading and trailiing blanks
  or if LENGTH is omitted and STRING begins with a numeric
  character.  The double quotes will be removed.

BATPLUS - Batch file enhancement utility
_____________________________________________________________________


TIME [mask]
  Returns the current time.  If mask is omitted the time is
  formatted according to the country code.  See the appendix
  DATE/TIME MASK for additional information.  See also DATE.

UNSET [variable ...]
  Deletes the variable(s) from the environment.  If the variable
  name is ommited then the default variable is used.  If a
  variable is specified the default variable (BATPLUS=) is left
  untouched unless specified.  You may specify multiple
  variables, e.g.: BATPLUS UNSET TEST DUMMY WHEN

UPPER
  Converts STRING to uppercase and returns it to the environment.
  See also LOWER.

VOLUME [drive:]
  Returns the volume label of the specified drive (or default
  drive) to then environment.

WORD n text
  Returns the n'th word of the text string

    SET TEST=This is a test
    BATPLUS WORD 2 %TEST%

  The variable BATPLUS= is set to "is" (without the quotes).

YEAR
  Returns the current year, e.g. 1995.

_____________________________________________________________________

Date/Time Mask

  The two commands DATE and TIME allow an optional formatting
  mask.  With this mask you have complete control of how your
  date and time will look.

  Date Masks

    m, M            Month
    d, D            Day
    y               Year
    n, N            Month Name
    w, W            Day of week name

    Time Masks
    h, H            Hour
    m, M            Minutes
    s, S            Seconds
    t               AM/PM mode, replaced by 'p' or 'a'.
    e               Used with 't', replaced with 'm' (used to
                    avoid conflict with minutes mask)

BATPLUS - Batch file enhancement utility
_____________________________________________________________________


  Lowercase indicates to zero pad while uppercase indicates space
  pad.  For example, the mask MM/dd/yyyy returns ' 6/01/1995'.  'Y'
  is not allowed.  'n' and 'N' should not be mixed, e.g. Nnn is not
  supported.  The same is true of 'w' and 'W', Www is not
  supported.  In both of these cases, they must be all uppercase or
  all lowercase, although the first character will always be
  uppercase even if a lowercase mask is used.

  Examples, given the date January 1, 1995:

  Mask                  Result
  mm/dd/yy              01/02/95
  MM/dd/yyyy            01/02/1995
  dd/mm/yyyy            02/01/1995
  DD/mm/yyyy            2/01/1995
  dd-nnn-yyyy           02-Jan-1995
  dd-NNN-yyyy           02-JAN-1995
  www dd nnn yyyy       Tue 02 Jan 1995
  WWW NNN dd yyyy       TUE JAN 02 1995
  www                   Tue
  nnn                   Jan
  mm                    01
  dd                    02
  yyyy                  1995

  Given the time 1:02:00 P.M. (13:02:00):
  hh:mm:ss              13:02:00
  hh:mm                 13:02
  hh:mm te              01:02 pm
  HH:mmt                1:02p
  hh                    13
  mm                    02
  ss                    00

As you'll notice, you can use the DATE and TIME commands to
extract a portion of the date or time.  The use of the mask is
purely optional.  If omitted the date and time will be formated
using the country code specified by DOS.

_____________________________________________________________________

Color Attributes

  A number used to set the attribute is calculated by choosing
  the background color code, multiplying that by 16 then adding
  the foreground color code. The formula to use to get this
  number is:

       A  = BACKGROUND_COLOR x 16
       B  = FOREGROUND_COLOR

       Attribute = A + B;

  Adding 128 to the previous value will enable blinking.

BATPLUS - Batch file enhancement utility
_____________________________________________________________________


  BACKGROUND COLORS                   FOREGROUND COLORS

    BLACK      0                       BLACK          0
    BLUE       1                       BLUE           1
    GREEN      2                       GREEN          2
    CYAN       3                       CYAN           3
    RED        4                       RED            4
    MAGENTA    5                       MAGENTA        5
    BROWN      6                       BROWN          6
    LIGHTGRAY  7                       LIGHTGRAY      7
                                       DARKGRAY       8
                                       LIGHTBLUE      9
                                       LIGHTGREEN    10
    Blinking   +128                    LIGHTCYAN     11
                                       LIGHTRED      12
                                       LIGHTMAGENTA  13
                                       YELLOW        14
                                       WHITE         15



  Example color attributes:

    Back    fore
  (1 x 16) + 12       =  28    ; Light Red on Blue
  (4 x 16) + 15 + 128 =  207   ; blinking white on red

BIGECHO - Big Text Display
_____________________________________________________________________


DESCRIPTION

  BIGECHO displays large characters on screen.  This is useful
  for attention grabbing batch files.


VERSION

  5.00  07/10/95


COMMAND FORMAT

  BIGECHO message [/FB]


    message   A string of at most 10 characters.

    /FB       F is foreground character, B is background character.
              Defaults to solid and blank.


EXAMPLE

  BIGECHO testing /X.

  will display a message with X's in the forground and periods in
  the background, similar to:


  ...X.......................X......XX....................
  ..XX......................XX............................
  .XXXXX...XXXX....XXXXX...XXXXX...XXX....XXXXX....XXX.XX.
  ..XX....XX..XX..XX........XX......XX....XX..XX..XX..XX..
  ..XX....XXXXXX...XXXX.....XX......XX....XX..XX..XX..XX..
  ..XX.X..XX..........XX....XX.X....XX....XX..XX...XXXXX..
  ...XX....XXXX...XXXXX......XX....XXXX...XX..XX......XX..
  ................................................XXXXX...



BOOT - Reboot PC from within a batch file or DOS
_____________________________________________________________________


DESCRIPTION

  BOOT is a utility which can be called from the DOS command line or
  from a batch file.  This program will reboot your PC either
  emulating a soft boot [CTRL][ALT][DEL] or a hard boot such as
  pressing the reset key.


VERSION

  5.00  06/13/85


COMMAND FORMAT

  BOOT [WARM][SOFT][COLD][HARD][/T:nn]


  COLD   Perform a Cold Reboot of the System (same as Hard)

  HARD   Perform a Hard Reboot of the System (same as Cold)

  WARM   Perform a Warm Reboot of the System (same as Soft)

  SOFT   Perform a Soft Reboot of the System (same as Warm)

  T:nn   Where nn is the number of seconds to delay before rebooting.
         (Default 5)



BOOTCTL - Boot Sector Control Program
_____________________________________________________________________


DESCRIPTION

  BOOTCTL will modify a floppy disk's boot sector so that the systems
  bootup process will skip over the normally checked floppy boot
  sector and go to the hard disk boot sector.  Many times when you
  boot a PC if you have a diskette in the A: drive that is not a
  bootable floppy you will get the message, NON-SYSTEM DISK or DISK
  ERROR and have to reboot.  BOOTCTL eliminates this problem by
  skipping over the normally unbootable floppy boot sector.  Be
  careful not to run BOOTCTL on diskettes that are bootable or contain
  copy protection because BOOTCTL will write over the boot sector
  information.

  With BOOTCTL you can also put a customized NON-SYSTEM boot message
  on the diskette.


VERSION

  5.00  06/13/85


COMMAND FORMAT

  BOOTCTL [d:] [options]

  [d:]       is the floppy drive to modify.

  /?         Display Help Information

  /P or      Create a boot sector that will boot past the floppy to
  /PAST      the hard disk when this diskette is installed.

  /C:fname   This will place a customized NON-SYSTEM boot message on
             the floppy.  The file fname must be an ASCII file of no
             more than 436 bytes.  You may put any message in fname as
             long as it fits in the boot sector (under 436).  Included
             is a sample file SAMPLE.TXT which can be used with this
             parameter.


BOOTLOCK - Lockout various key functions from being used
_____________________________________________________________________


DESCRIPTION

  BOOTLOCK is a simple utility that will lock out the use of the
  [CTRL][ALT][DEL] soft boot sequence and the [CTRL]C or [CTRL][BREAK]
  break sequence.  The default is to disable both keys from having any
  effect, but you may wish to only disable one or some combination.
  See the usage flags below to disable specific keys.  Once installed
  you may also un-install and remove the program from memory by using
  the /U parameter.


VERSION

  5.00  6/1/95


RESIDENT MEMORY USAGE

  1100 Bytes


COMMAND FORMAT

  BOOTLOCK [/I][/U][/B][/C][/R][/K#:nnn][/K#][/XT][/NOH]
    or
  DEVICE=BOOTLOCK.EXE [/I][/U][/B][/C][/R][/K#:nnn][/K#][/XT][/NOH]

  /I      Install BootLock

  /U      UnInstall BootLock and remove from memory (if TSR)

  /B     Turn on/off locking of [CTRL][BREAK]

  /C     Turn on/off locking of [CTRL]C

  /R     Turn on/off locking of [CTRL][ALT][DEL]

  /K#:nnn Define a key combination to lock out, where # is the user
          key number (1, 2, or 3) and nnn is the string representing
          the key combination (see below)

  /K#    Turn on/off locking of user defined key, where # is 1, 2,
          or 3

  /XT     Trap keys on older systems

  /NOH    Don't display header (only works on registered version)


BOOTLOCK - Lockout various key functions from being used
_____________________________________________________________________


USER DEFINED KEYS

  To specify an arbitrary key to disable use the /K#: switch followed
  by the string representation of the keystroke.  Note you must
  specify which of the three user keys you are setting, e.g.

        /K1:[ALT]C
        /K2:[CTRL]Q
        /K3:[ALT]X

  Shifting keys must be first, the actual scan code key, and only
  one is allowed, must be last.  Spaces are not allowed anywhere
  in the key string.  "Named" keys are enclosed in square
  brackets.  The following named strings are recognized by
  BOOTLOCK:

        [Space]
        [Slash]  (/)
        [Esc]
        [Minus]  (-)
        [Bksp]   (backspace)
        [Tab]
        [Enter]
        [Grey*]
        [Caplock]
        [Numlock]
        [ScrollLock]
        [Home]
        [UpAr]
        [PgUp]
        [GreyMinus]
        [LftAr]
        [Pad5]
        [RgtAr]
        [GreyPlus]
        [End]
        [DnAr]
        [PgDn]
        [Ins]
        [Del]
        [Alt]
        [Ctrl]
        [LeftShift]     (only the left shift key is recognized)
        [RightShift]    (only the right shift key is recognized)


BOOTLOCK - Lockout various key functions from being used
_____________________________________________________________________


Examples of valid keys:

        [Ctrl][Alt]Q

        [Ctrl][Alt]                      note, [Alt] is the scan key

        [LeftShift][RightShift]X         both shifts required

Invalid keys:

        [Ctrl] [Alt] Q                   has spaces

        [Ctrl]Alt                        no brackets on Alt

        [LShift][RShift]X                spelling errors

        [Ctrl]-                          should be [Minus]

When parsing the strings the input is converted to uppercase, the
following are all identical when parsed:

        [Ctrl][Alt]C

        [ctrl][alt]c

        [CTRL][ALT]C

It is possible to indicate keys that might normally be considered
unwise, for example if you only specify:

        [Alt]

BOOTLOCK will completely disable the [ALT] key, not a good idea
(unless this is what is desired).

Once a key has been specified with /K#:nnn, you can re-enable the key
with /K#+, then disable it again by specifying "/K#".  BOOTLOCK
remembers the key so you don't have to type in a long string every
time unless, of course, you change the keystroke or unload BOOTLOCK
from memory.


BRKBOX - Software Breakout Box for I/O Port Debugging
_____________________________________________________________________


DESCRIPTION

  BRKBOX is a software version of a hardware breakout box.  It
  displays the status of a COM or LPT port inside your PC.  The status
  of the various port flags are displayed on the screen and are
  updated in real time as port activity happens.


VERSION

  5.00  06/13/95


RESIDENT MEMORY USAGE

  2,464 Bytes


COMMAND FORMAT

  BRKBOX [port] [+][-][/U][/Knnnn]


  port    Port to monitor.  You may specify either a serial or a
          parallel port to monitor.  COM1 through COM4 or LPT1 through
          LPT3 are supported.

  +       Enable BRKBOX display

  -       Disable BRKBOX display

  /U      uninstall and remove from memory

  /Knnnn  define a new hotkey for toggling display.  See the chapter
          at the end of the manual about calculating TSR "Hot Keys"

  /Lxx    display location.  nn is any combination of r for right
          side, l for the left side  and  t for the top of the screen
          or b for the Bottom of the screen.  EGA/VGA 43/50 line modes
          are supported by the bottom display.

  /NOH    Suppress header

  /Inn    Multiplexer I.D. number


BRKBOX - Software Breakout Box for I/O Port Debugging
_____________________________________________________________________


NOTES

  BRKBOX displays information about the port you are monitoring on
  your screen. Whenever registers that are being monitored are "high"
  or "on" then a reverse video string will be displayed for that
  register.  Below are tables describing the various registers
  monitored by BRKBOX.  This information is sometimes useful when
  trying to debug a port or some associated communications software.
  To toggle the display on and off use [ALT]C. The program will start
  with the display toggled on. BRKBOX can be uninstalled by entering
  it with the optional U parameter if it was the last TSR loaded.


SERIAL PORT MONITOR

  When monitoring a serial port using BRKBOX the following registers
  will be displayed:

  DTR - Data Terminal Ready
  RTS - Ready To Send
  CTS - Clear To Send
  DSR - Data Set Ready
  RI  - Ring Indicator
  DCD - Data Carrier Detect

  in additional to these registers you will also be given the current
  values for the Buad Rate (300-115200), Parity (None, Even, Odd),
  Data Bits (7 or 8), and Stop Bits (0, 1, 2).


PARALLEL PORT MONITOR

  When monitoring a Parallel Port using BRKBOX the following registers
  will be displayed:

  BY  - Printer Busy
  AK  - Acknowledge
  PO  - Paper Out
  OL  - Printer Online
  IO  - I/O Error
  TO  - Port Time Out


CALENDAR - Display monthly or yearly calendar
_____________________________________________________________________


DESCRIPTION

  CALENDAR displays a calendar from DOS in one of two formats, either
  one month or 12 months of one year.


VERSION

  5.00  07/08/95


COMMAND FORMAT

  CALENDAR [mm] yyyy [/C#] [/L##] [/T##]

    mm   month [1..12]

    yyyy year [0..9999]. If 2 digits are used, the year will be 19yy

    C#   display in # columns [2..3(default)]

    L##  shifts display left by ## chars [0(default)..80]

    T##  shifts display down by ## lines [0(default)..40]


EXAMPLE

  CALENDAR 66 /C2

  will display a calendar in 2 columns for the year 1966




NOTES

  If you want to pause the display of a full year press [CTRL]S to
  pause the screen and then any key to continue the display.


CAT - Unix like CAT utility for concatenation of files.
_____________________________________________________________________


DESCRIPTION

  CAT is a UNIX utility written for the MS-DOS world.  For people that
  are used to UNIX it is a handy familiar tool for displaying,
  printing, and concatenating files together.  CAT handles redirection
  of both input and output.  It can be used similar to copy con to
  create files as well.


VERSION

  5.00  06/14/95


COMMAND FORMAT

  CAT   [fname] - copy std input to file fname

  CAT   [file1] [file2] > [file3] - concatenate file1 and file2 to
        file3



CHANGE - File Changer
_____________________________________________________________________

DESCRIPTION

  CHANGE allows you to make minor modifications to a file.  It is
  currently limited to a file no more than 50k bytes in size.


VERSION

  5.00  07/10/95


COMMAND FORMAT

     CHANGE [file] "search string" "replace string"

  file              filename(s) to change
  "search string"   string to search for
  "replace string"  string to replace search string with


EXAMPLES

       CHANGE program.com "GREAT" "FEAST"
       CHANGE program.com 10,10 13,10

  The OLD and NEW text strings enclosed in quotes must be separated by
  a space.

  ASCII characters may be specified by their codes - separate them
  from the string in quotes with a comma.  For example, to change
  "<ascii 27> ABC" to "esc DEF" in a file called TEXT1:

       CHANGE TEXT1 27,"ABC" "esc DEF"

CHIMES - Quarterly hour clock chimes
_____________________________________________________________________


DESCRIPTION

  Chimes is a terminate-and-stay resident program that attaches itself
  to the BIOS timer tick interrupt.  The program counts the time
  internally, so that it does not bring any overhead into system
  throughput by using DOS functions.  When the program realizes that
  the time is nearing the hour, the program starts chiming.

  In its default mode, chimes produces "Time Tone" beeps.  These
  consist of three short beeps, starting at three seconds before the
  hour.  Then, at the hour, a longer and higher beep is given.  Many
  of the dial-up time services provide such a time tone.

  Chimes can be given the /M option on the command line to provide the
  different clock chimes.  Using  CHIMES /M1  would setup chimes to
  use the Westminster chimes.


  The Westminster chimes are the chimes that are played by Big Ben,
  the most famous of all clock towers.  From its home in London,
  England, the clock plays a melody based on a composition by Handel.

  The Saint Michael Chimes are also from England.  However, the Saint
  Michael Chimes were cast by an English craftsman for a church in
  Charleston, South Carolina during the Revolutionary war.  However,
  the British captured this city by battle, and took the bells back to
  England. Amazingly enough, the American rebels stole the molds for
  the bells, and a second set of bells was cast and installed in the
  Carolinian church.

  The Whittington chimes were named for Lord Mayor Richard
  Whittington. Whittington started life in poverty.  However, he made
  money in great volume by trading.  After his terms as Lord Mayor of
  London, he became a philanthropist.

  If you select the M0 option of the program, chimes will only become
  active  at the hour.  Otherwise, chimes will faithfully reproduce
  the chimes for each quarter hour of the clock.  The program will
  also strike the hour by chiming for each hour, or chiming just once
  for the half hour.

CHIMES - Quarterly hour clock chimes
_____________________________________________________________________



VERSION

  5.00  06/13/95


RESIDENT MEMORY USAGE

  1,552 Bytes


COMMAND FORMAT

  CHIMES [/Mx] [/U] [/NOH]

  /Mx    indicates which built in CHIME to use where x is:
         0 Time Tones
         1 Westminster Chimes
         2 Saint Michael Chimes
         3 Whittington Chimes

  /U     Uninstall program and remove from memory

  /NOH   Surpress the header display


AUTOLOAD BYPASS

  If you have added chimes to your machines AUTOEXEC.BAT and sometimes
  wish to skip the loading of the program then you may use the bypass
  keys.  Holding down the [CTRL][ALT][LSHIFT] will cause the program
  to ask you if you wish to abort the installation.  If you respond
  with a Y the program will not load into memory.

CLEANFL - Clean Floppy Drive Heads
_____________________________________________________________________


DESCRIPTION

  CLEANFL is a utility that makes the task of cleaning floppy drive
  heads much easier and more thorough.  By moving the head of the
  floppy drive back and forth traveling the entire span of the drive
  you get a much better cleaning action and the surface of your
  cleaning diskette will last much longer.  Most cleaning diskettes
  tell you to place them in the drive and type DIR A:.  In this
  scenario the head is always over the first track using a small
  percentage of the cleaning surface all the time.  By using CLEANFL
  the cleaning surface gets a much more even wear and will last longer
  and provide a better cleaning job for your diskette drives.


VERSION

  5.00  06/14/95


COMMAND FORMAT

  CLEANFL [d:] [/Tnn] [/Pnn] [/NOH]

  d:      refers to valid floppy drive (A:, B:, etc).

  /Tnn    specifies the number of tracks

  /Sn     specifies the number of sides

  /Pnn    specifies the number of passes

  /NOH    Supress the Header Display


NOTES

  Everything requested has been done.  The parameters can be in any
  order on the command line.  The drive specifier requires the colon
  (:) since that's how I verify that the parameter is, in fact, a
  drive letter.

  The autodetect of the number of tracks and the drive type (floppy,
  fixed, or RAM) needs to be tested on systems with very old BIOSes
  (pre 1984) and also on XT class computers.  On systems where the
  feature isn't supported you should get an error message stating that
  the /Tnn parameter is required (no default).  On not sure of the
  result if you drive to CLEAN a harddrive with a very old BIOS.  If
  it let's it slip by it shouldn't be a problem since it will only
  move the head a few times without changing the data.

CLEANUP - Disk Drive Cleanup & Space Recovery
_____________________________________________________________________


DESCRIPTION

 With the ever increasing size and lowering cost of disk
  space, it isn't uncommon to find PC's with an average of 80MB.
  Having larger disk drives has also made managing them becomes more
  complex.  It is no longer feasible to remember the name and location
  and purpose of every file on your system.  Often files and programs
  will be installed on a temporary basis only to be forgotten and
  either outdated or left behind.  You can quickly devote as much as
  25% of your hard disk to unused or duplicate files. Cleanup provides
  a comprehensive way of dealing with this  problem by quickly
  isolating unused and duplicate files and removing them, freeing up
  valuable hard disk space.  Cleanup displays the name of each file as
  it is deleted and a summary showing the total amount of disk space
  that has been recovered.


WARNING

  The main function of Cleanup is to recover lost disk space by
  removing duplicate and unused files.  You have total control over
  which files will and will not be deleted, but with large hard disks
  it is easy to overlook single file names and accidently delete a
  desired file.  It is suggested that you backup your disk before
  running Cleanup.  This will assure that you have a means of
  recovering files that you delete by accident.  The other alternative
  is to have a copy of Norton Utilities UnErase or a similar type
  product.


VERSION

  5.00  06/14/95




CLEANUP - Disk Drive Cleanup & Space Recovery
_____________________________________________________________________


COMMAND FORMAT

  CLEANUP [/L50]


  /L50  Force into 43/50 Line mode on EGA/VGA monitors


NOTES

  Cleanup is a menu driven program.  After initializing the program
  you are prompted with a list of disk drives in your system.  In this
  list you are allowed to toggle the search amongst any installed
  drives in your system. Drives that are allowed, but not attached are
  "grayed" out and you cannot select these drives.  When you select a
  drive a check mark  will note when a drive is selected.  You may
  select any combination of all available drives.  All of the drives
  selected will be treated as one large volume across which all
  duplicates and file marking will take place.  This is particularly
  handy if you have more than one hard drive on which you keep files,
  and you might end up with duplicate files across the drives. Once
  you have selected the drives to scan, press the [F10] key to start
  scanning.

  After all of the directories have been scanned you will be located
  at the main menu of Cleanup.  In the upper right hand corner of the
  screen is the Current Status window.  This window will always
  display information about the programs status.  The number of
  directories, files and duplicate files is calculated after selecting
  the drives and will not change until you exit the program and run
  again.  The number of tagged files and bytes will show you the
  current statistics for the files that have been tagged for deletion.

  These numbers will be updated as you tag or untag files for
  deletion.

  There are two methods for tagging files for deletion.  The first
  method is to use the Auto Tag and Auto Untag menus.  These menus are
  identical in options, and perform exactly the opposite tasks.  The
  Auto function allows you to tag groups of files all at one time.
  Once tagged, you may then go in and manually untag individual files
  using the manual tag option.  Below are the options available from
  the Auto Tag and Auto Untag menus.


CLEANUP - Disk Drive Cleanup & Space Recovery
_____________________________________________________________________


  ALL                  All allows you to tag/untag all of the files
                       scanned.  This is generally only useful for
                       untagging files.  Be careful as if you use this
                       to tag files, you will tag all of the files on
                       the selected drives for deletion.

  SMALLER DUPLICATES   This will look at the list of duplicate files
                       and whenever there is a difference in size, the
                       smaller file will be marked for duplication.

  OLDER DUPLICATES     This is quite handy and will compare all of the
                       duplicate files and mark the oldest files.
                       This is useful when you wish to only keep the
                       most recent version of a file on your system.

  BACKUP FILES         This option will mark all files ending in .BAK.
                       This was the original function of the TIDY
                       program from which Cleanup evolved.  Many
                       programs and editors create a backup of a file
                       when updating it.  After a while these backups
                       can clutter up your system.

  TEMP FILES           There are many programs that make use of
                       temporary files while processing work.
                       Sometimes, if these programs are interrupted or
                       crash, the temporary files will be left of your
                       drive.  Most software uses the convention of
                       naming temporary files with a .$$$ extension.
                       This option will mark all files ending in .$$$

  EXT xxx              This allows you to tag a group of files with a
                       particular extension that you know should be
                       removed.  With this option you can specify any
                       group of files by giving the extension name.
                       All files ending in the extension that you
                       provide will be tagged.  Be careful that you
                       wish to delete all files ending in the
                       extension before running the Erase option.


CLEANUP - Disk Drive Cleanup & Space Recovery
_____________________________________________________________________


  ZERO LENGTH          This was the other option available on the TIDY
                       program.  Another type of temporary file that
                       can often be created is one that was opened but
                       never properly closed.  This will often result
                       in a file entry in your directory with a file
                       size of 0 bytes.  The zero length is
                       misleading.  Every file entry requires at least
                       one cluster thus the minimum disk space used by
                       a 0 byte file is the cluster size (512 bytes or
                       more).  Having a lot of 0 byte files can
                       actually take away space from your drive.
                       Choosing this option will mark all files with a
                       size of 0 bytes for deletion.

  LENGTH n             Like the Zero length files above, there may be
                       instances where you create a lot of small files
                       that you wish to tag for deletion. This option
                       allows you to input a specific file size. All
                       files matching this file size will be tagged
                       for deletion.


CLEANUP - Disk Drive Cleanup & Space Recovery
_____________________________________________________________________


  The MANUAL TAG option from the Main Menu allows you to view the list
  of files and to manually tag or untag files.  When you first enter
  this screen you will be presented with the list of duplicate files.
  To view all of the files in the system press the [F6] key.  Then to
  switch back to the list of only duplicate files, again press the
  [F6] key.  Tagged files will be marked with a check mark  next to
  the name, and will appear in red on color monitors.  To view the
  list use the up and down arrow keys. To tag a particular file  press
  the [ENTER] key.  Pressing it a second time will untag the file.  To
  untag a tagged file, highlight the file and press the [ENTER] key.
  Once again, the [ENTER] key will continue to toggle the tag on and
  off.  When you are done viewing the manual tag list press the [F10]
  key.


  Once you are happy with the list of tagged files, choose the ERASE
  TAGGED option from the main menu.  This will erase all files that
  were previously tagged.  There is no UNDO feature on this program so
  once they are deleted you will have to use an unerase program such
  as Norton Utilities Quick Unerase to recover any erased files.  If
  you have accidentally deleted a file, do not use the disk drive
  until the file has been unerased.  Changing data anywhere on the
  disk could result in permanently loosing the information in the
  file.



NOTES

  There have been some reports of problems when using Cleanup in a
  machine that is   running both FASTOPEN and SMARTDRIVE.  The best
  solution is to remove the usage of FASTOPEN as it can cause sorting
  problems with the file list on large disk drives.


COMMODE - Configure Serial Port
_____________________________________________________________________

DESCRIPTION

  COMMODE allows you to configure your serial port.  It is a more
  versatile implementation of the MODE program.


VERSION

  5.00  06/14/95


COMMAND FORMAT


  COMMODE COMn, [baud], [parity], [databits], [stopbits], [enable]

  COMn can be: COM1, COM2, COM3, or COM4
  Baud rate can be: 110 to 115200
  Parity can be: No, Even, Odd, Mark, or Space
  Data bits can be: 5, 6, 7, or 8
  Stop bits can be: 1 or 2
  "ENABLE" turns on UART FIFO buffering
  "DISABLE turns off UART FIFO buffering

EXAMPLES

  Get the current settings for COM1:

     COMMODE COM1

  Set COM2 to 9600 baud, No parity, 8 data bits, 1 stop bits, and
  don't change FIFO buffing:

     COMMODE COM2,9600,No,8,1

  You can leave off portions you do not wish changed.  Here, only the
  baud rate is changed:

     COMMODE COM2,2400

  If to lave out a portion in the middle you must include the comma.
  Here we change only the parity:

     COMMODE COM2,,Even

  FIFO buffering is not supported by all serial ports.  That features
  requires a special UART, called the u16550a.  Most computers are
  supplied with the simplier 14550 chip which does not support FIFO
  buffering.  Very high speed communications (9600 baud and faster)
  usually require the FIFO buffering features for error free
  transmissions.

  If your modem communications software does not recognize the
  availability of the FIFO buffer you should try enabling it with
  COMMODE:

    COMMODE COM1,,,,,enable

COUNT - Count Characters, Words & Lines
_____________________________________________________________________


DESCRIPTION

  COUNT is a program that is useful for programmers or writers who are
  looking for some content statistics on files that they have created.
  COUNT will display the amount of characters, words and lines in a
  given file.


VERSION

  5.00  06/15/95


COMMAND FORMAT

  COUNT [file] [/A][/N]


  file  is the name of the input file.  Multiple file names may be
        specified but wild cards can not be used.

  /A    don't count non-alphanumeric characters

  /N    only count non-blank lines in line count



CURLOCK - Cursor Locking Program
_____________________________________________________________________


DESCRIPTION

  This program is especially useful for owners of laptop computers
  with LCD screen.  When using this type of computer is often
  difficult to see the DOS cursor shape.   Using CURSOR to set the
  cursor shape to a large block, you can then lock the cursor shape as
  a block so that all software packages will retain the large block
  cursor.  CURLOCK keeps applications from modifying the cursor and
  rendering unreadable in many situations.  CURLOCK intercepts all
  calls to BIOS interrupt 10h and bypasses any calls to change the
  cursor shape.


VERSION

  5.00  07/07/95


RESIDENT MEMORY USAGE

  864 bytes


COMMAND FORMAT

  CURLOCK [/U] [/NOH] [/ID:nnn]


  /U       Uninstall.  Will remove curlock from memory and once again
           allow the cursor shape to be changed.

  /NOH     Don't display the header information.

  /ID:nnn  TSR installation ID number.



CURLOCK - Cursor Locking Program
_____________________________________________________________________



NOTES

  This program was written because I got tired of various programs
  changing the shape of the cursor on my screen.  Particularly
  annoying is that giant block cursor flashing away at me.  If you
  feel the same way then CURLOCK will save you lots of grief.

  Once loaded on your screen to let you know that the program has been
  installed.  From now on (until you re-boot your computer) your
  cursor will stay the same size even if another program tries to
  change it.

  You may want to place the CURLOCK command in your AUTOEXEC.BAT file
  so it will be installed each time you turn your computer on (that's
  the way I have it set up).

  I have been using this program on my system without any problems or
  side- effects.  It has proven reliable and has not interfered with
  any of the other software I use.  The final few paragraphs of this
  document are included as 'standard prcatice' these days, not in
  anticipation of problems that this program may cause.

  CURLOCK is a terminate-and-stay-resident program (sometimes referred
  to as a TSR) which occupies less than 1K when loaded.  It intercepts
  all requests for BIOS Video functions via interrupt 10H.

  The size of the cursor is 'remembered' when the program is loaded.
  All future requests for change of cursor size are intercepted and
  the values for the cursor size (starting and ending scan lines) are
  forced to the original values.

  All requests other than the change cusor size request (AH = 1) are
  passed to the BIOS without alteration.



CURSOR - Cursor Setting Program
_____________________________________________________________________


DESCRIPTION

  CURSOR is a program that lets you control your cursor from the DOS
  prompt. You can set the cursor to various shapes as listed below.
  Some software uses the DOS cursor in which case the cursor will stay
  the same as when you set it using CURSOR.  If the software makes
  it's own cursor then the cursor you create with CURSOR will not
  function inside this software.  Some software resets the DOS cursor
  to it's own shape. Therefore you might want to put CURSOR in a batch
  file after this software to reset the cursor to what you want it to
  be at the DOS prompt.

  CURSOR can work in conjunction with CURLOCK, the cursor locking
  program.  If CURLOCK is installed, CURSOR can tell it to lock or
  unlock the cursor shape.


VERSION

  5.00  07/07/95


COMMAND FORMAT

  CURSOR [/D][/H][/B][/M][/?][/V][/I][/T:nn][/B:nn][ID:nn]

  /D      turns the cursor on to the bootup default underline

  /H      turns the cursor off (hide cursor)

  /B      makes the cursor a full block

  /M      displays the current cursor top and bottom values

  /?      displays the help screen

  /V      returns version information

  /I      Interactive Setup.  Full screen cursor setting mode.

  /T:nn   set the top scan line of your cursor

  /B:nn   set the bottom scan line of your cursor

  /LOCK   Locks the cursor, requires CURLOCK is already installed.

  /UNLOCK Unlocks the cursor, requires CURLOCK is already installed.

  /ID:nn  Curlock TSR ID code.

NOTES

  CURSOR is not completely compatible with 4DOS.  4DOS always sets the
  cursor shape at the command line depending upon whether you are in
  insert or overwrite mode.  This can result in a cursor in the middle
  of the character cell after running CURSOR without locking due to
  CURSOR using the entire cursor range instead of CGA cursor
  emulation, which 4DOS does not expect.  Proper use of the SETDOS
  /Sn:n command will normally fix this problem.


CUT - Unix like CUT text formatting utility.
_____________________________________________________________________


DESCRIPTION

  CUT is another UNIX utility written for the MS-DOS world.  For
  people that are used to UNIX it is a handy familiar tool for
  displaying and printing text files in different formats by
  eliminating columns and other formatting options.


VERSION

  5.00  07/08/95


COMMAND FORMAT

  CUT -clist [fname1] [fname2] ...


EXAMPLE


  CUT -c1-15 test.txt

  will display all characters in the file test.txt in columns 1
  through 15


CUTPASTE - DOS Text Cut & Paste Utility
_____________________________________________________________________


DESCRIPTION

  Provides an MS-DOS clipboard function similar to one found WINDOWS and
  MACINTOSH environments.  CUTPASTE allows you to pop up over any TEXT
  based screen and copy information into an internal buffer, to a file
  or to the printer.  You can use CUTPASTE to copy text from one screen
  and paste it into an editor, word processor on onto the DOS Command
  line.


VERSION

  5.00  06/15/95


RESIDENT MEMORY USAGE

  7,904 Bytes
  8,272 Bytes with Mouse Support Loaded


COMMAND FORMAT

  CUTPASTE [/?][/U][/Srr,cc][/NOH][/K:key]

  /?         Display help

  /U         Unload program

  /M         Enable mouse support

  /Srr,cc    Set screen buffer size (rows and columns)

  /NOH       don't display header information

  /K:[key]   Set hotkey


CUTPASTE - DOS Text Cut & Paste Utility
_____________________________________________________________________



NOTES

  The default key to pop up the program is [CTRL][ALT]C

  Older mouse drivers do not support the function calls necessary for
  a TSR to use the mouse without messing up the mouse for the
  interrupted program.  In this case the mouse will either stop
  working when control returns to the interrupted program or it will
  just disappear, but still work.

  When the /M switch is used the tsr takes up slightly more resident
  memory so that there is room for a "mouse save state buffer".

  CUTPASTE only supports standard text modes (0,1,2,3, or 7).  If any
  other mode is set it will beep with a notify error.  CUTPASTE will
  work with EGA video modes of 43 lines and VGA adapaters at 50 lines.

  When CUTPASTE is activated it displays a block cursor on the current
  screen. You then navigate the cursor using the arrow keys (or mouse
  if /M mode is on(.

  Move the cursor to the upper left hand corner of the text you wish
  to copy. Now press the [ENTER] key (right mouse button) and the
  upper left hand corner will be anchored at that spot.  Use the arrow
  keys to create a selection box around the text you wish to copy into
  the buffer.  Once selected press the [ENTER] key to display your
  options.

  When the desired area is shown, pressing O outputs the contents to
  your LPT1 printer.

  Pressing F allows you to save the information to a new ASCII text
  file or to append the information to an existing file.  If a file of
  the same name already exists then you will be prompted with a
  request to overwrite or append to the existing file.

  Pressing C will copy the text into the internal TSR buffer for later
  retrieval.

  If you wish to insert some text onto the screen or keyboard buffer
  from a previous copy then press [CTRL][ALT]C followed by a P (paste)
  and the text that was previously copied will be pasted on the screen
  that you are currently on.


DELAY - Delay during bootup or batch files
_____________________________________________________________________


DESCRIPTION

  Delay is a utility that can be used to replace the PAUSE command
  within a batch file.  Pause will never continue until a key is
  pressed, whereas with delay you can set the amount of seconds to
  pause, and then continue or continue immediately by pressing a key.
  DELAY can also be used in your CONFIG.SYS to delay or pause between
  the loading of device drivers which is extremely helpful when trying
  to solve a conflict in CONFIG.SYS.



VERSION

  5.00  06/15/95


COMMAND FORMAT

  DELAY [time]

    or

  DEVICE=DELAY.EXE [time]


  [time]  # of seconds to delay.


NOTES

  Pressing [CTRL]C will also cause a break in a batch file that can be
  monitored with the error level returned by DELAY.  This is useful if
  you are trying to break out of stream of commands from within a
  large batch file.  DELAY can be used in CONFIG.SYS as well as from
  within BATCH files, this is rather helpful when you are trying to
  delay the execution of device drivers in order to see what is going
  by on the screen.  Specifying no time on the delay batch line acts
  the same as PAUSE.

  This new version combines previous versions of DELAY.EXE and
  PAUSE.SYS into one program.


DETAB - Remove ASCII Tab characters from a text file
_____________________________________________________________________


DESCRIPTION

  DETAB is a utility that will strip any tab characters from an text
  file and convert them into spaces.  This is especially useful when
  working with old formatted .ASM files that you would like to work
  with in an editor which treats fixed tabs differently.


VERSION

  5.00  07/05/95


COMMAND FORMAT

  DETAB [input file] [output file] [/Tn][/NOH]

  /Tn    Set tab size to n.  (Default is 4)

  /NOH   Suppress display of header (registered version only)


ENVIRONMENT OPTIONS

  Set tab size using an environmental variable named TAB.  This
  environmental variable may be overruled by specifying a different
  one on the command line using the /T command.  Place SET TAB=n in
  your AUTOEXEC.BAT file.




DISKINFO - Disk Drive Information Display
_____________________________________________________________________


DESCRIPTION

  DISKINFO is a utility that will read the boot sector of a disk and
  then make a DOS call to find out the information that DOS has for
  that disk. It will then list out the information in a side by side
  format so that you may compare the reports from DOS and the boot
  record.  Most items reported are self explanatory.  Every disk is
  divided up into tracks, sectors and clusters.  A track is a single
  ring around a disk.  A sector is a pie shaped wedge of a track.  A
  cluster is the smallest unit to which DOS can interact with the disk
  drive and it is a group of Clusters.  The System ID is the 8 byte
  record that is put on the disk when it is formatted.  The Media
  Descriptor is a byte value that describes what type of media the
  disk is.


VERSION

  5.00  06/16/95


COMMAND FORMAT

  DISKINFO [d:][/?][/NOH]

  d:    is the drive to view, if no drive is specified information on
        the current drive will be displayed.

  /?    Displays help information.

  /NOH  Surpress Header Display


EDENV - Environment Variable Editing
_____________________________________________________________________

DESCRIPTION

  EDENV allows you to interactively edit environment variables.
  The process of making minor changes to an environment variable
  such as PATH= is simplified.


VERSION

  5.00  06/16/95


COMMAND FORMAT

  EDENV [/NOH] varname


     /NOH       suppress header (registered version only).

     varname    Environment variable name.

EXAMPLE

  EDENV PATH

  This loads the data for the variable PATH.  The cursor is
  placed at the end of the line to allow you to make additions.
  Type your changes and press [Enter] to save them.

NOTES

  The following keys are available for cursor movement and
  editing.

   [RtAr]       Right arrow, move cursor right.
   [LfAr]       Left arrow, move cursor left.
   [Ctrl][LfAr] Word left.
   [Ctrl][RtAr] Word right
   [Ctrl]Y      Delete entire line.
   [Home]       Move to beginning of line.
   [End]        Move to end of line.
   [Backspace]  Delete character to left of cursor
   [Delete]     Delete character under cursor
   [Ctrl]T      Delete word under and to right of cursor.
   [Alt]U       Undo, restore original value, continue editing.
   [Esc]        Cancel changes and exit.
   [Enter]      Accept changes and exit.

EDIT - SuperEdit DOS Text File Editor
_____________________________________________________________________


DESCRIPTION

  SuperEdit is an MS-DOS based full screen editor with many features
  including text formatting options, multiple windows and pull down
  menus. You may press F1 and any time during the program to get
  online help about various features. F10 will display the menu bar.
  When using a menu choice the equivalent keystrokes of the menu
  choice will be displayed in the upper left part of the screen.

  CONFIG.EXE, a keystroke configuration program that allows you to
  completely customize the editors  functions to your own keystrokes,
  EDIT.HDX, the online help file that is  used by CONFIG to create
  updated help information on customized function key values, and some
  additional printer drivers.

  To change these keystrokes to match any editor that you are used to
  run the CONFIG.EXE program to install the editors keystrokes. Do not
  modify EDIT.HLP or EDIT.HDX. These are the files used for the online
  help system and configuration program. These files must appear in
  the same directory as CONFIG and EDIT in order to be loaded
  properly.


VERSION

  5.00  06/16/95


COMMAND FORMAT

  EDIT [f1] [f2] [f3] [f4] [f5] [f6]


  f1-f6    file names to load into editor.



  CONFIG


EVAL - DOS Command Line Calculator
_____________________________________________________________________


DESCRIPTION

  EVAL is a program designed to evaluate mathematical expressions
  input on the command line.


VERSION

  5.00  05/023/95


COMMAND FORMAT

  EVAL [expression][function][expression]...


NOTES

  EVAL supports the four basic functions; addition, multiplication,
  subtraction, and division.  The syntax used is very similar to that
  of the mathematic expressions used by most modern computer languages
  and by most spreadsheet programs.  For example, to add two to eight
  and multiply that result by thirteen, one would use:

  EVAL (2+8)*13


EVAL - DOS Command Line Calculator
_____________________________________________________________________


EXPONENTS

  The operator precedence used is similar to most high level
  languages, as well.  Multiplication and division are "higher" than
  addition and subtraction. Exponents, represented by the carat (^)
  are lower than all four operators. You will find that you can
  exponentiate values by using ** in place of the carat.  Thus, you
  can use:  EVAL 2**1/2 to find 2^0.5.

  It should be noted, by the way, that this is a good way to find
  roots.  The program has no sqrt() or curt() functions.  You may
  recall from your math courses that, to find the y-th root of x, you
  can do:  x^(1/y)

  Of course, EVAL will complain if this results in a complex number.
  For example, the result of the above is complex if x == -4 and
  y == 4.


RANGE

  EVAL uses the full "double" precision of the C language.  Thus,
  answers will be represented to a maximum of 16 digits to the right
  of the decimal point. EVAL allows all numbers between 1.7E-308 and
  1.7E+308 to exist. Of course, the negatives of these numbers are
  also available.  It should be noted that EVAL doesn't check for
  overflows or underflows.  EVAL will, however, flag "digital math"
  nono's, such as division by zero and exponentiations resulting in
  complex numbers.  To use these numbers, just write them as you would
  specify them in a program like 1-2-3 or in a program: 3.1415 0.1 -34
  18.01 35e-2 6.2e+23


EVAL - DOS Command Line Calculator
_____________________________________________________________________


MODULO DIVISION

  EVAL, as well as complementing the four functions with
  exponentiation, allows the use of the modulo operator.  This
  operator provides the integral "remainder" of division.  Since 5
  divided by two is two remainder one, the command:  EVAL 5%2  will
  result in the answer 1.0.


FUNCTIONS

  EVAL supports an extensive list of functions, as well.  Functions
  may be specified in either upper or lower case, and may be
  abbreviated to as little as three characters.  (Of course, if the
  function's name is one or two characters long, all characters must
  be specified.)


  These functions are supported by EVAL:

  abs(x)         absolute value of x
  acos(x)        arc cos of the angle x radians
  acot(x)        arc cotangent of the angle x radians
  acsc(x)        arc cosecant of the angle x radians
  asec(x)        arc secant of the angle x radians
  asin(x)        arc sine of the angle x radians
  atan(x)        arc tangent of the angle x radians
  cos(x)         cosine of the angle x radians
  cot(x)         cotangent of the angle x radians
  csc(x)         cosecant of the angle x radians
  deg(x)         convert x radians to degrees
  exp(x)         e to the power of x
  fact(x)        factorial of x
  random(x)      random number (see below)


EVAL - DOS Command Line Calculator
_____________________________________________________________________


  ln(x)          natural (base e) logarithm of x
  log(x)         base 10 logarithm of x
  pi(x)          pi times x
  rad(x)         converts x degrees to radians
  sec(x)         secant of the angle x radians
  sin(x)         sine of the angle x radians
  tan(x)         tangent of the angle x radians
  sinh(x)        hyperbolic sine of x
  cosh(x)        hyperbolic cosine of x
  tanh(x)        hyperbolic tangent of x
  sech(x)        hyperbolic secant of x
  csch(x)        hyperbolic cosecant of x
  Random(x)      random number (see below)

  If any of these functions are passed invalid values, EVAL will abort
  with an error.  The arc-trig functions, for example, cannot accept
  values outside of the closed interval [0,1].

  Using these functions is similar to any other high level language.
  The function name and its ending left parenthesis function as an
  opening parenthesis in the precedence of the evaluation.  Thus,
  sin(.7)^2+cos(.7)^2 would evaluate to 1.0.  You may find that
  certain identities don't evaluate to what you would expect them to.

  This is because of the limits of precision in computer math when
  dealing with irrational numbers.  While the sin^2+cos^2 identity
  almost always works, the sec^2-tan^2 identity usually doesn't work,
  for example.

  Along with this problem, another comes.  For example, mathematically
  sec(0.5*pi) is undefined.  However, EVAL will evaluate sec(pi(0.5))
  to be a very (very) large number.  This is again because of the
  rounding errors in binary math. It is a good approximation,
  considering lim(sec(x)) == +infinity   x -> 0.5+


EVAL - DOS Command Line Calculator
_____________________________________________________________________


RANDOM(X)

  If X is specified, returns a random integer in the range 0..X-1.
  If X is not specifed, returns a random floating point number in
  the range 0 < N < 1.0.

  This function uses the environment variable SEED= as the pseudo-
  random number seed (this number is in the range 0 < SEED < 1.0).
  If this variable is not defined or is not a proper number it will
  be initialized using the computer's current time.


MEMORY

  By popular demand, a "memory" feature has been added to EVAL.  If
  you make a computation using EVAL, the result is remembered and may
  be used as needed in any further invocation of EVAL.

  For example, using the command: EVAL SIN(1)  would display the sine
  of one radian.  If you executed the command:  EVAL ASIN(@)  next,
  you'd get, effectively, ASIN(SIN(1))... the result would be one.
  Similarly, if you used EVAL  35+15  EVAL would print 50.  If you did
  EVAL @+100  a result of 150 would be displayed.

  EVAL stores the results in your machine's environment.  You may see
  the previous result by typing the SET command; DOS will list the
  environment variables it has stored.  EVAL's environment variable is
  listed on the line "EVAL".

PARSING PROBLEM

  Currently, there is a problem when parsing functions with
  parenthesis.  When parsing a function, such as SIN(x), with an
  additional computation that follows, e.g. SIN(1)+1, it evaluates
  the expression as SIN(1+1).  To correct this, place extra
  parenthesis around the function, e.g. (SIN(1))+1.

  This problem should be corrected in the next release.


FILEATTR - Set DOS File Attributes
_____________________________________________________________________


DESCRIPTION

  FILEATTR allows you to change the attributes of a group of files. If
  told to, FILEATTR also will search through subdirectories.

  There are four attributes: Archive, Read-Only, System and Hidden. If
  a file has the Archive bit set, this means the file has been changed
  since the last time it was backed up. If a file has the Read-Only
  bit set, this means the file can be read, but not written to,
  meaning it CANNOT be changed. If a file has the System bit set, it
  means this file is a DOS System file and should be left alone. If a
  file has the Hidden bit set, then you cannot see the file or
  directory by using the DIR command. You can still run the file,
  assuming it is executable, or go into the directory, it is just
  hidden.


VERSION

  5.00  06/22/95


COMMAND FORMAT

  FILEATTR [file] [attr] [/C][/D][/F][/V][/P][/Y][/S][/T][/U][/K][/?]

  [file]     is any valid DOS file specification including wildcards.
             (Default is *.*)

FILEATTR - Set DOS File Attributes
_____________________________________________________________________


OPTIONS

  /A  Files with at least the Archive bit set.  Search for files with
      at least the Archive bit set, although there may be other bits
      set as well.

  /C  Clear all bits.  Clears all the bits from a file. You can use the
      parameter of /ARSH to accomplish this, I just added this to make
      it easier.

  /D  Change bits on sub-directories.  Allows the changing of bits on
      a sub directory. The only bit that will affect it is the Hidden
      bit. You can hide or unhide a sub-directory.

  FILEATTR will allow you to change the other three bits as well if
  you want.

  /F  Files only - Size, Date and Time are not displayed.  Will stop
      the Size, Date and Time of the file(s) from being displayed.

  /H  Files with at least the Hidden bit set.  Will search for files
      with at least the Hidden bit set, although there may be other
      bits set as well.

  /K  Kill (Delete) found files.  Will kill (delete) all files that
      are found. Use this command with or without the /V command. If a
      sub-directory is found, it will be skipped, not deleted.

  /P  Pause every page.  Will pause the output every page, which is
      set for 24 lines. After 24 lines have gone by, a "pause prompt"
      will appear on line 25. The prompt allows you to hit N for non
      stop listing, Q or ESC to quit and return to DOS and the
      subdirectory in which you started from, C to return to DOS but
      in the current directory or hitting any other key


FILEATTR - Set DOS File Attributes
_____________________________________________________________________


  /R  Files with at least the Read-Only bit set.  Will search for
      files with at least the Read-Only bit set, although there may be
      other bits set as well.

  /S  Process files in sub-directories.  Allows searching from the
      CURRENT sub-directory and all sub-directories below it for files.

  /T  Display totals of files found and changed.  Will display totals
      after all files have been found. It will display the total
      number of files found and files changed.

  /U  Unusual files - those with any bit set.  Will find any unusual
      files. These are files with any bit set. This is similar to the
      /A command.

  /V  Verify the Deletion of files.  Will verify that you want to
      delete each file. This is used with /K only and has no other
      meaning if /K is not used. The  file will be shown as normal and
      you will be shown a prompt "Delete? (Y/N/C/Q)" minus the quotes.
      Hit 'Y' to delete the file and FILEATTR will show you that it
      has been deleted. Hit 'N' and the file is not deleted. Hit 'C'
      for continuous deleting from this point on without verification.
      Hit 'Q' or ESC and the file will not be deleted and you will
      immediately be returned to DOS and the sub-directory in which
      you started from.

  /Y  Files with at least the System bit set.  Will search for files
      with at least the System bit set, although there may be other
      bits set as well.


FILEATTR - Set DOS File Attributes
_____________________________________________________________________


NOTES

  At anytime while FILEATTR is running, you can hit ESC or Q and you
  will be immediately returned to DOS and the sub-directory at which
  you started from. Another key you can hit while FILEATTR is running
  is P, which instantly puts FILEATTR into Pause mode, the same as if
  you used /P option. You may also hit C at anytime.  FILEATTR will
  return to DOS and the current sub-directory. This is useful when
  using the /S option, and you see something that makes you want to go
  to that directory.

  FILEATTR can search through your directories for files as well. It
  has a limit of 450 directories it can handle.


EXAMPLES

  FILEATTR

  Will display the help information screen.


  FILEATTR /cspt a*.zi?

  Will search for files in the current sub-directory and  all
  subdirectories below that start with A and have ZI in the extension.
  It will clear all bits on those files and display a total of files
  found and files changed.  FILEATTR will also pause every 24 lines.


  FILEATTR d: /us

  Will search for files in the current sub-directory of D: and all
  sub-directories below it for files with the any bit set.


FILEINFO - DOS File Information
_____________________________________________________________________


DESCRIPTION

  FILEINFO is a utility that helps alleviate the problem that DOS has
  created by only allowing 8 characters to describe a file.  Many
  times you have files that aren't accessed very often and it becomes
  hard to remember what they are used for.  FILEINFO provides a way of
  adding notes about files in any directory.


VERSION

  5.00  07/06/96


COMMAND FORMAT

  FILEINFO [d:\path]


NOTES

  Run FILEINFO from the directory that you wish to describe or enter
  the name of the directory you wish to edit on the command line.
  FILEINFO creates a file called FILEINFO. in each directory that you
  run in.  This file is just a standard text file that can be printed
  out if you wish to have a hard copy of the file descriptions.

  Once loaded you will be presented with a list of files and any
  previous descriptions that were left.  Files that are new or haven't
  yet been described will contain a * after the file name and before
  the description area. FILEINFO creates a file in each

  FILEINFO also supports the optional EGA 43 line mode and VGA 50 line
  mode.  If your system is in one of these modes when you run
  FILEINFO, the extra lines will be used.


FILESIZE - Display File Size Information
_____________________________________________________________________


DESCRIPTION

  FILESIZE is a utility that will list each individual file and their
  respective sizes.  A summary at the end of the list gives total
  size, number of files, total space and drive and space available
  with a actual and percentage values.  You may pass FILESIZE a
  specific file to list, or group of files. If no parameters are
  passed FILESIZE will list all files in the current directory.


VERSION

  5.00  06/16/95


COMMAND FORMAT

  FILESIZE [filespec] [/?][/T][/S][/P][/NOH]

  /?    Display help

  /E    Put total in environment, FILESIZE=nnnn

  /T    Display totals only

  /S    Search subdirectories

  /P    Pause on screenfulls

  /NOH  Suppress Header


FILETREE - Display DOS File Structure
_____________________________________________________________________


DESCRIPTION

  FILETREE is a utility which will scan the directory structure of a
  disk and give a top down tree listing of the entire disks directory
  structure.  It groups the listing in a left to right fashion with
  each subdirectory moving further right across the screen.


VERSION

  5.00  06/30/95


COMMAND FORMAT

  FILETREE [d:] [/NOH]

  d:     is the drive to scan
  /NOH   Suppress header (registered version only)

NOTES

  Pressing [CTRL]Break during the scan will halt the program.


FINDFILE - Find File on your Disk Drive
_____________________________________________________________________


DESCRIPTION

  Locates files by searching the entire disk for a specified file.
  You may use DOS wildcards to find a group of files as well.  The new
  version of FINDFILE will also search within compressed files to
  search for filenames as well.  FINDFILE searches across your disk
  looking for any files that you specify.  When it finds a matching
  file it will display the directory the file was found in, the
  complete file name, the file size, creation date and time, and any
  attributes associated with the file.


VERSION

  5.00  07/05/95


COMMAND FORMAT

  FINDFILE [filespec] [options]




NOTES

  FINDFILE works with standard DOS file names.  The program will also
  "open" several types of archive files.  These include the popular
  ZIP, PAK and ARC formats, as well as the public domain ZOO and LZH
  formats.

  FINDFILE supports any DOS based networks including Novell and
  Lantastic.



EXAMPLES

  To search the current drive for the file GOOFY.TXT enter

    FINDFILE GOOFY.TXT


  Should you wish, you can have FINDFILE run a drive other than the
  default drive.  To do this, simply include a drive specification.
  To look for GOOFY.TXT on drive H, one would use the command

    FINDFILE H:GOOFY.TXT


  If you are looking for a file with a name you can't specifically
  remember, you may use wildcards in the filename given to FINDFILE to
  search the drives and files on your system.  If you knew that your
  text file began with a G, for example, you might use

    FINDFILE H:G*.TXT


FINDFILE - Find File on your Disk Drive
_____________________________________________________________________



  If you knew that you had called the file MODEL but couldn't remember
  the extension it had,

    FINDFILE MODEL.*



  Note that FINDFILE searches *all* archive files it notices, even if
  they don't match the wildcard specification that you supply.

  If you have many of the supported archive files on your diskette,
  you may be noticing that FINDFILE runs a little slower.  If you are
  looking only for "normal" DOS files, you can use the /N option to
  cause FINDFILE to search only DOS directories.  That would make the
  above command look like this:

    FINDFILE /N MODEL.*


  Since you might know that the file is not stored in an archive, you
  can expidite the search by using /N.  Normally, FINDFILE searches
  ZIP, ARC, ZOO, PAK, and LZH files when it finds them.  You can
  switch off these file choices individually, as well.  For example,
  to search for FINDFILE.C without looking in LZH or ZOO files, you
  may use

    FINDFILE /O /L FINDFILE.C


FINDFILE - Find File on your Disk Drive
_____________________________________________________________________



  If you'd like, you can have FINDFILE print out messages as it
  traverses your hard drive and checks files.  To do this, use the /D
  option to display the filenames FINDFILE searches through, as well
  as the ones it finds.

  FINDFILE is capable of displaying file directory information, as
  well. If you would like to see the last modification date and time
  as well as the attributes and size of found files, use the /V
  option.  /V stands for "verbose mode".

  It is often handy to have just a total of file information.  For
  example, you might want to see how many .GIF files are on your hard
  disk, and how much room they're taking up.  You can use the /T
  option to have FINDFILE print out only the totals information,
  instead of also displaying the name and location of all the found
  files.

  Our example with .GIF files might look like this:

    FINDFILE /T *.GIF


  When FINDFILE prints out the number of files found, the number
  indicates the number of files that were not in archives.  If any
  files were "inside" of archives, FINDFILE will note that number of
  files with "archived files".

  If you ran FINDFILE and it printed, for example,

     6 files found.
    18 archive files found.

  it would mean that FINDFILE came across 24 files that matched your
  specification.  Six of these files were regular DOS files, but
  eighteen of the files were actually inside archive files.



FINDFILE - Find File on your Disk Drive
_____________________________________________________________________

  FINDFILE will search through archive files if it finds them and
  recognizes them by their extension.  Notice that, if you have an
  archive file and it doesn't have the normal file extension, the file
  won't be checked by FINDFILE.

  If you find yourself confused about FINDFILE's options, you can run
  FINDFILE without any options and it will show you a display of the
  usage information.  FINDFILE will also do this if you try to use an
  option it doesn't recognize.

  If you're running FINDFILE and realize something's wrong (or you
  have a huge disk and ge tired of waiting), you can use [CTRL]C or
  [CTRL][BREAK] to stop the program.  FINDFILE will tell you what it's
  found so far, and then leave you at the DOS prompt.

  If you use the /R option, FINDFILE will go through all of the drives
  looking for your file.  If the filespec you provide contains a drive
  specification, it will be ignored.  FINDFILE searches your drives in
  alphabetical order, starting with your first hard disk drive or RAM
  disk.  FINDFILE does not search floppy drives in this mode.


HEXDUMP - Hexadecimal Display of File Contents
_____________________________________________________________________


DESCRIPTION

  HEXDUMP is a utility that will give you a quick dump of the contents
  of any file.  The dump is very similar in format to what you get
  with the Norton Utilities file viewer.  An advantage of HEXDUMP is
  that you can quickly dump the contents of any file to the screen
  without having to load the overhead of a shell program.  You can
  display any type of file ASCII or Binary.  The default display is to
  list the HEX values on the left and the ASCII equivalents on the
  right hand column.


VERSION

  5.00  06/19/95


COMMAND FORMAT

  HEXDUMP [file] [/B][/O][/H][/P]

  file  can be any valid DOS file including binary files.

  /B    will dump the file in binary groups rather than hex.

  /O    will dump the file in octal groups rather than hex.

  /H    will display the file in raw hexadecimal format rather than
        showing the hex and ASCII values side by side.

  /P    Pause mode, will pause each screen full

  /NOH  Suppress header.  Registered version only.

HUSH - Speaker Control Utility
_____________________________________________________________________


DESCRIPTION

  HUSH is a utility that can eliminate a majority of the sounds
  generated by the PC's internal speaker.  HUSH can not eliminate all
  beeps.  Tones that it can not completely silence, it can reduce to a
  small click.  HUSH is a small TSR which when loaded watches for
  output to the speaker. When activated, HUSH will try and suppress
  the speaker 18.2 times a second.


VERSION

  5.00  06/30/95


RESIDENT MEMORY USAGE

  544 Bytes


COMMAND FORMAT

  HUSH [ON] [OFF] [NOH] [U]


  ON   Enable HUSH functions
  OFF  Disable HUSH functions
  NOH  Supress header, Registered version only
  U    Unload from memory


KILLDIR - Remove Directory and it's contents
_____________________________________________________________________


DESCRIPTION

  KILLDIR is a utility that will make eliminating a directory and all
  of it's contents a lot easier.  When you run KILLDIR it will display
  the information about the directory that you wish to remove
  including the number of files and sizes as well as any subdirectory
  information. KILLDIR will remove all files and file types including
  hidden or system files.


VERSION

  5.00  06/30/95


COMMAND FORMAT

  KILLDIR [dir] [/SN] [/NOH] [/NOP]

  /SN     Display the names of all subdirectories when listing the
          subdirectory info.

  /NOH    No Header Display

  /NOP    No Prompt for deletion   DANGER !!  will erase without a pause

LASER - Laser Printer Control
_____________________________________________________________________


DESCRIPTION

  LASER helps you set your laser printer's mode and also makes it easy
  for you to send some control codes to it.  It is specifically
  designed to work with HP LaserJet Compatible Printers but some of
  the generic functions such as Form Feed, Line Feed and Carriage
  Return will work with any printer.


VERSION

  5.00  06/30/95


COMMAND FORMAT

  LASER [mode] [mode] ...


  BOLDON   Turns on Bolding of all characters

  BOLDOFF  Turns off Bolding Off

  ITALON   Sets the PCL Font to Italics

  ITALOFF  Turns of the PCL Italics

  LF       Send a Line Feed to the printer

  FF       Send Form Feed.  This will eject the page that is in the
           printer.


LASER - Laser Printer Control
_____________________________________________________________________


  CR       Send a Carriage Return to the printer.

  ESC      Sends the ESCAPE code to the printer.  ASCII 027.

  6LPI     Sets the PCL Font to 6 Lines Per Inch

  8LPI     Sets the PCL Font to 8 Lines Per Inch

  16CPI    Sets the PCL Font to 16 Chars Per Inch

  10CPI    Sets the PCL Font to 10 Chars per Inch

  PORT     Sets the mode to Portrait Orientation for vertical output.

  LAND     Sets the mode to Landscape Orientation for horizontal
           output.

  AUTO     Tells the printer to use the internal paper tray to feed
           from.

  MAN      Tells the printer to wait for manually fed pages during
           print.

  LEG      Set up the printer to use 8 1/2 x 14 Legal sized paper.

  LET      Set up the printer to use 8 1/2 x 11 Letter sized paper.

  TEST     Prints a Test page to the printer.

  RESET    Send the RESET code to the HP Laserjet.


  PAGEON   This parameter is for use with HP Laserjet users that have
           a Pacific Page Postscript Cartridge installed. This
           cartridge allows you to emulate an Apple LaserWriter
           Postscript printer on your HP LaserJet. Some software does
           not support the Postscript mode, and rather than having to
           power on and off and insert and remove the cartridge each
           time you wish to switch modes, you can use laser to set the
           proper mode of the cartridge.  PAGEON tells the Printer to
           use the PostScript emulation mode.

  PAGEOFF  This tells the Pacific Page cartridge functions to disable
           and the printer will now except standard PCL commands.


  STRING=[text]  This parameter allows you to send whatever strings
                 you wish to the printer.  It can be used in
                 conjunction with the ESC parameter to select soft
                 fonts and send setup commands.

  PORT=[port] This parameter lets you set which printer port the laser
              utility should send data to.  The default is PRN.  By specifying
              LPT1, LPT2, or LPT3, you can reroute lasers output to the
              different ports.



LS - Unix like LS Directory Listing
_____________________________________________________________________


DESCRIPTION

  LS is a file listing utility that is found in the Unix operating
  system.  It has many advanced features beyond that of the DIR
  command found in DOS.  This implementation has most of the Unix
  features built in.


VERSION

  5.00  07/08/95


COMMAND FORMAT

  LS [-1CFPRSdflrst] [filespec]


  -1  list in single column

  -C  list in multiple columns

  -F  directories are marked with a trailing '\', system files are
      marked with a trailing '@' and executable files are marked with
      a trailing '*'

  -P  print the directory name before listing

  -R  recursively list subdirectories

  -S  sort by file size in bytes (cluster size if option 's' is
      selected)

  -d  list directories as if they were a normal file

  -f  do not sort (list in the order files appear in the directory)

  -l  list in long format ([size in clusters,] mode, size, date, name)

  -r  reverse the order of the selected sort

  -s  list the file size in clusters

  -t  sort by time


NOTES

  This version will also search the environment string for LS=
  [defaults].  Any options that you set LS= with the SET command will
  be loaded automatically when you run the program from the DOS
  prompt.  Set your most used parameters in your AUTOEXEC.BAT file and
  then a plain LS will run those parameters for you.  Options as in
  the Unix LS the switches are case sensitive.


MONITOR - Monitor Convergence/Alignment/Focus Test
_____________________________________________________________________


DESCRIPTION

  MONITOR allows you to test out your video monitor.  It displays a
  series of patterns that help you make sure that the monitor is setup
  correctly. A grid of cross hatching is displayed to show the maximum
  display area of the monitor.  If the lines are crooked or distorted
  around the edges you may need to adjust the alignment.  In the four
  corners of the screen are colored circles.  These can be used to
  adjust the focus.  Across the top is a pattern of the base 16 colors
  for adjusting the RGB values.


VERSION

  5.00  06/21/95


COMMAND FORMAT

  MONITOR [/NOH]

  /NOH  Supress header.  Registered version only.


NOTES

  MONITOR supports the following video adapters:  HERCULES, CGA,
  EGA, VGA, and 8514A.

  If you set the environment variable HEADER=OFF the trailing
  copyright message will not be displayed.  This feature only
  works with the registered version.



MOVE - Move Files Across Directories or Drives
_____________________________________________________________________


DESCRIPTION

  Moves any file from one place to another.  If moving the file from
  one drive to a different drive, MOVE will first check to make sure
  that there is enough space on the destination drive.  If you don't
  specify a destination MOVE will assume the current directory and the
  same file name.


VERSION

  5.00  07/07/95


COMMAND FORMAT

  MOVE source [destination] [options]

  /?     Displays Help

  /C     confirm each file before moving

  /O     overwrite all colliding files

  /X     never overwrite colliding files

  /N     overwrite only newer files

  /A     ask before overwriting files (DEFAULT)

  /H     Move Hidden files

  /R     Automatically renames files if possible without prompting

  /F     Follow.  Switches to destination directory after move.

  /RA    Ask you for a new filename for each filespec found

  /S     search subdirectories copying tree structure

  /SX    search subdirectories using destination directory

  /NOH   Suppress Header


MOVE - Move Files Across Directories or Drives
_____________________________________________________________________


EXAMPLES

  MOVE ABC.TXT \DOS

  This will move the file ABC.TXT to the directory \DOS keeping the
  same name


  MOVE \DOS\ABC.TXT

  This will move the file \DOS\ABC.TXT to the current directory
  keeping the same name.



NOTES

  When using the renaming feature, hitting the escape key at the input
  prompt, will ABORT the program.  If you do not desire to rename the
  file, leave the input area blank.

  If a file of the same name already exists where you are trying to
  move a file to, you will be prompted whether or not you wish to
  overwrite that file.

  If a destination is unclear as to whether it is a file name or a
  directory name MOVE will prompt you to decide for it.

  If a destination directory does not exist, MOVE will ask you whether
  or not you would like it to create a new destination directory for
  you.


NAMEDIR - Rename a Directory
_____________________________________________________________________


DESCRIPTION

  NAMEDIR is a utility that is used to rename directories.  This
  program will rename a directory without having to empty or modify
  it's contents.


VERSION

  5.00  06/21/95


COMMAND FORMAT

  NAMEDIR [olddir] [newdir]

NO - DOS File Exclusion Utility
_____________________________________________________________________


DESCRIPTION

  NO is a utility that gives many DOS commands and external utilities
  the ability to exclude certain groups of files from the effects of
  the program called.


VERSION

  5.00  06/23/95


COMMAND FORMAT

  NO [filespec] [command parameters]

  filespec    is any valid DOS file specification including wildcards

  command     is any DOS command, or external program

  parameters  normal parameters passed to the command or program


NOTES

  NO hides files in the current directory from most programs and
  utilities by putting the HIDDEN file attribute on.  It then calls
  the command or program with the specified parameters.  Once the
  command is complete, NO will remove the HIDDEN file attribute from
  the specified files.

  NO is very useful when using commands such as DEL *.* when you want
  the action to take effect on all but a certain group of files.

  NO is recursive which means you can stack groups of excluded files
  together by stacking NO commands.


EXAMPLES

  NO *.EXE DIR

  will display all files in the current directory with the exception
  of files ending in .EXE


  NO FILE.* DEL *.*

  will delete all files in the current directory except those
  beginning named FILE with any extension


  NO *.EXE NO *.COM DEL *.*

  will delete all files in the current directory except .EXE and .COM
  files

PATHFIND - Find File in the Current Path
_____________________________________________________________________


DESCRIPTION

  PATHFIND is a utility that allows you to search the file path for
  any files. This is handy when you are trying to locate a similar
  program of file that could exist in multiple places in your path
  statement.  It will display the files that it finds in order of
  appearance within the path.


VERSION

  5.00  06/21/95


COMMAND FORMAT

  PATHFIND [/NOH ] [filespec]

  /NOH     suppress header (registered version only).
  filespec is any valid DOS filename including wildcards.


NOTES

  If you dont specify an extension PATHFIND will automatically append
  *.* to the end of the file requested.

PSPRINT - Print ASCII files to a Postscript Printer
_____________________________________________________________________


DESCRIPTION

  PSPRINT is a utility that allows you to print DOS ASCII Text
  files on a PostScript device without any conversion.  PSPRINT
  is based on a unix filter taking STDIN input and sending the
  converted text to STDOUT output.  By rerouting the output to
  the printer and specifying an input filename, PSPRINT will
  print the file to the printer specified.



VERSION

  5.00  06/21/95


COMMAND FORMAT

  PSPRINT [/Mx][/Tx][/Lx][/Px][/Fname][/Nx][/I][/Cnn][/NOH] [file]

  file    File to print.  Wildcards are allowed.

  /Mx     left margin in points (Default 24)

  /Tx     top margin in points (Default 24)

  /Lx     leading points between lines (Default 11.5)

  /Px     pointsize of font (Default 10)

  /Fname  font name (Default Courier)

  /Nx     number of lines per page (Default 66)

  /I      ignore form feed characters in file (ASCII 12)

  /Cx     number of copies to print.  (Default 1)

  /NOH    suppress the header information



NOTES

  The default settings may be modified at a run time basis by using
  the optional parameters on the command line.  To set a default
  output mode you can specify the environment variable
  PSPOUT=[destination] in your AUTOEXEC.BAT file.  By using
  PSPOUT=LPT1 the output will be redirected to the LPT1 printer port
  rather than STDOUT.


RAMDRIVE.SYS - High Speed RAM Drive for MS-DOS
_____________________________________________________________________


DESCRIPTION

  RAMDRIVE is a device driver that allows you to partition a part of
  your Extended Memory (XMS) as "RAM disk drive."  Having a part of
  your memory configured as a RAM disk will allow you to access
  temporary files, intermediate files, and other information at a much
  faster rate than a standard hard disk.


VERSION

  5.00  06/22/95


RESIDENT MEMORY USAGE

  700 Bytes


USAGE

  DEVICE=[d:][path]RAMDRIVE.SYS [nnnn] [/C] [/A]

    PC, PC-XT and other 8088 users

  DEVICE=[d:][path]RAMDXT.SYS [nnnn] [/C] [/A]



  nnnn       Specifies the amount of memory in kilobytes to allocate
             for the RAM disk.  Default 512.

  /A         Tells RAMDRIVE to use all available XMS memory.  Use this
             option instead of specifying the exact size.

  /C         Turns on speaker clicking.  With this option each time
             the RAM drive is accessed the speaker will produce a
             short click. This is useful when trying to measure how
             much disk activity is occuring on the RAM drive.


RAMDRIVE.SYS - High Speed RAM Drive for MS-DOS
_____________________________________________________________________


NOTES

  RAMDRIVE requires under 1K of DOS memory for its installation.

  RAMDRIVE is installed as a DOS device driver and must be placed
  after your XMS device driver for it to work.  For example:

    device=HIMEM.SYS
    device=RAMDRIVE.SYS

  RAMDRIVE has been optimized for 16 bit computers.  Your computer
  must have a 286 or better processor for it to work.


BYPASSING STARTUP

  There are times when you may wish to not load RAMDRIVE to gain back
  it's memory usage or to test some software with RAMDRIVE loaded.  In
  this case as you machine boots if you simultaneously hold down the
  [CTRL][ALT][LSHIFT] keys RAMDRIVE will ask you if you wish to bypass
  the installation.  At this point you can answer Y or N as to whether
  or not you wish RAMDRIVE to load.



RAMDRIVE.SYS - High Speed RAM Drive for MS-DOS
_____________________________________________________________________

ERROR MESSAGES


  Device not installed.

  There was a general installation error with RAMDRIVE and the program
  could not install. Verify that you requested an amount of memory
  that is available and the the XMS driver has been installed before
  the RAMDRIVE driver in your CONFIG.SYS.


  The XMS driver is not installed.

  RAMDRIVE could not find or recognize your XMS driver.  Verify that
  it is installed.


  XMS failure during installation.

  RAMDRIVE had a problem with the XMS driver while trying to allocate
  memory.  Try lowering the amount of memory requested for RAMDRIVE.


  No free XMS Memory.

  There is no extended memory available for RAMDRIVE.  Try reducing
  other programs usage.

  Requested size too big to fit.

  You have requested more Expanded memory than is available.  Try
  lowering the amount of memory in the /Mnnnn option.


  Can't have zero disk size.

  You can not allocate a RAM drive of 0k size.  You must specify at
  least 16k of RAM drive space.


  Unrecognized option encountered.

  A command was placed on the DEVICE= line that was unrecognized by
  RAMDRIVE.



SCRNATTR - SET DOS Screen Attributes
_____________________________________________________________________


DESCRIPTION

  SCNATTR allows you to set the foreground, background and border
  colors of your monitor.  To use it, just type SCRNATTR followed by
  three of the allowed parameters.


VERSION

  5.00  06/21/95


COMMAND FORMAT

  SCRNATTR [bright] [blink] [underline] [fg] [ON bg] [/n]



EXAMPLE

  A:>scrnattr red on green

  would set the screen colors to a green background with red text.



NOTES


  The following are valid colors:

  Black, Red, Green, Yellow, Blue, Magenta, Cyan, White


  If /N is included the border color is not set.  Most VGA systems
  do not have a noticable border.


SCROLLBK - DOS Screen Scroll Back Utility
_____________________________________________________________________


DESCRIPTION

  SCROLLBK allows you to capture screen information that has rolled
  off the top of your screen and buffers it into a conventional or
  expanded memory buffer.  At any time you can then press the SCROLL
  LOCK key on your keyboard and scroll back through the previous
  screens.  SCROLLBK supports MDA, HERCULES, CGA, EGA and VGA video
  cards.  It supports all text modes that use 80 columns.


VERSION

  5.00  06/21/95


RESIDENT MEMORY REQUIREMENT

  2,688 bytes


COMMAND FORMAT

  SCROLLBK /Mnnnn [/EMS][/D][/C][/?][+][-][/U][/Ffname][/A][/O]

  /Mnnnn   This tells SCROLLBK how much memory to use in nnnn k bytes
           for the scroll back buffer.  Conventional memory will be
           used unless you specify the /EMS parameter described below.
           The resident memory usage will be the 2k for overhead + the
           buffer size unless EMS is used.


SCROLLBK - DOS Screen Scroll Back Utility
_____________________________________________________________________


  /EMS     Use Expanded Memory for Buffer Space.  The amount of memory
           buffer specified by the /Mnnnn parameter will be used out
           of EMS rather than conventional memory.  EMS 3.2 or 4.0 is
           supported.  The amount of memory in K bytes specified in
           the /M parameter will be rounded up to the nearest EMS page
           (16k).

  /NOH     Suppresses the Header display.

  /D       Some video BIOSes have a built in scroll back buffer and
           will cause the SCROLLBK buffer to have a duplicate of every
           line that has been displayed.  Using this parameter should
           compensate for the built in buffer and eliminate the double
           lines.  Compaq EGA and Orchid VGA cards are known to have
           this problem.

  /C       This option will clean out the buffer so that it starts
           recording with a clean memory from this point on.

  +        Enable SCROLLBK.  This turns on the SCROLLBK functions if
           previously disabled.

  -        Disable SCROLLBK.  This leaves the program in memory but
           turns off the capture and display features.

  /U       Uninstall SCROLLBK.  Removes the program from memory if
           possible.

  /Ffname  Will save the current contents of the scroll back buffer to
           a file named fname.


SCROLLBK - DOS Screen Scroll Back Utility
_____________________________________________________________________


  /A       If the /F parameter is used and a file already exists with
           the same name, this parameter tells SCROLLBK to append the
           current buffer onto the existing file.

  /O       If the /F parameter is used and a file already exists with
           the same name, this parameter tells SCROLLBK to overwrite
           the existing file with the current buffer information.



VIEWING BUFFER

  [SCROLL LOCK]  Activates the SCROLLBK viewing feature.  Disables the
                 cursor and allows the keystrokes listed below to take
                 effect. Will stay in the viewing mode until [SCROLL
                 LOCK] is pressed again, which will deactivate the
                 viewing mode.  Pressing [ESC] will also exit the
                 buffer viewing mode.

  [UP ARROW]     Move up the viewing one line

  [DOWN ARROW]   Move down the viewing one line.

  [PGUP]         Move up in the buffer viewing one Screen

  [PGDN]         Move down the buffer on screen.

  [HOME]         Go to the top of the buffer

  [END]          Go to the bottom of the buffer


SPEEDRAM - System Performance Enhancer
_____________________________________________________________________


DESCRIPTION

  SpeedRAM increases the speed of your system CPU by changing the
  refresh rate of your systems 8253 timer chip. All Personal
  Computers, including the original IBM PC were designed with a very
  high refresh rate. The rate used by all personal computers is far
  beyond the rate required by the RAM chips used in these machines.
  SpeedRAM sets the refresh rate to match closer with RAM
  manufacturers specifications and in turn frees up CPU cycles. These
  free cycles can be used by your software rather than going to waste
  by refreshing the RAM too often. The change in refresh rate matches
  within specifications of most DRAM manufacturers. Depending on your
  system SpeedRAM should increase your CPU's performance from 2% to
  10%. You can measure this in many ways such as LANDMARK's CPU SPEED
  Test or Norton Utilities SI program.


VERSION

  5.00  06/22/95


COMMAND FORMAT

  SPEEDRAM [+][-][/R:nn]

  +       Enable SpeedRAM.  Entering a + will enable SpeedRAM and set
          the optimum refresh rate.

  -       Disable SpeedRAM.  Entering a - will disable SpeedRAM and set
          the refresh rate to stock values.

  r:nn    Set refresh rate to nn Us.  Entering r:nn will set the
          refresh rate to nn micro seconds.  Only use this if you have
          a good understanding of the refresh rates.  Setting too high
          a refresh rate will cause memory  Parity errors or hang your
          system. If you find that SPEEDRAM + causes parity errors or
          hangs your system than you will want to try this option.


SPEEDRAM - System Performance Enhancer
_____________________________________________________________________


WHAT IS A REFRESH RATE AND WHAT DOES IT DO?

  The memory in your Personal Computer is called DRAM, or Dynamic
  Random Access Memory. This memory is made of banks of 9 chips each
  holding up to as much as 4MB of 1 bit data. Each chip in a bank
  represents one of 9 bits. In Personal Computers, 8 of the bits store
  data and the 9th bit is called a parity bit, used to determine if
  the data bits are holding the proper information. DRAM chips can not
  hold a charge of electricity for a very long time. In fact, a new
  charge of 5 volts must be supplied about every 65 micro seconds or
  it will loose its data. To supply this charge, that is refresh, the
  memory, the CPU must stop processing data and direct the 8253 chip
  to send the refresh charge to the bank of memory. Once the refresh
  is done the CPU can continue processing. By reducing the number of
  times the CPU has to stop to refresh the DRAM is how SpeedRAM speeds
  up your system.


NOTES


  SpeedRAM is not a TSR. It does not require any RAM or take any away
  from your system. SpeedRAM only needs to be loaded once and will
  perform until the machine is rebooted.

  SpeedRAM has now loaded and changed your systems speed. Now try
  loading some software to insure that the system is working properly.
  Run all the programs that you normally run on your system. Do not
  load any data that isn't already saved in case SpeedRAM causes a
  problem. If SpeedRAM causes any problem, it will cause memory
  problems, your system will either hang or you will get a Parity
  Error type message, if have any problems refer to the Trouble
  Shooting section that follows for further instructions. If
  everything works fine then you might want to install SpeedRAM so it
  loads every time you boot your machine.

  If you have any time of Memory or RAM test you can further insure
  that everything is working properly by running that test. If it
  reports no problems than it is safe to assume that SpeedRAM has no
  conflicts with your machine.




SPEEDRAM - System Performance Enhancer
_____________________________________________________________________


TROUBLE SHOOTING

  SpeedRAM has been thoroughly tested on many systems before being
  released but due to the complexity and variety of equipment
  available we can not guarantee that it will work on every Personal
  Computer.

  If you notice memory errors, parity errors, or that your machine is
  hanging after running SpeedRAM + then the rate that SpeedRAM has
  chosen for your system is causing the DRAM chips to fail. This is in
  no way a permanent failure, you will just have to pick a lower rate
  at which to run SpeedRAM. To use a manual refresh rate with SpeedRAM
  enter the following:

    SPEEDRAM r:nn [ENTER]

  where nn is the refresh rate you wish to use. Start with 60 and
  retest your system. If you continue to have problems keep decrements
  the amount by 5 until you reach a value that your system works with.
  If the value is less than 18 then you will most likely not benefit
  from SpeedRAM. If this is the case contact technical support for
  further help.

  If you have to use a manual refresh rate then install with the rate
  override option, and give it the value that worked with your system
  when the installation program prompts you.

  Some problems in benchmarking are caused by TSR or Memory Resident
  software such as screen blankers or print spoolers.


SPEEDRAM - System Performance Enhancer
_____________________________________________________________________


  The benchmark ATPERF.EXE from PC Tech Journal which measures
  overhead is usually not affected by these programs. It is a very
  good sign of the change SpeedRAM has with your program.

  Norton Utilities SI and Landmarks CPUSPEED can be affected by TSR's
  and may not show the increase in performance. If notice no
  improvement in performance try running the benchmarks without any
  TSR's loaded. If you still see no increase, call technical support.

  There are some utilities available as Shareware or Public Domain
  software that perform a similar task to SpeedRAM. If you have any of
  the following you might not see an increase with SpeedRAM:

  NREFRESH.COM           1987
  SPEEDER.COM            1987
  FASTRAM.COM            1988
  FASTV20.COM            1988
  ZIP.EXE                1988

TEXTSRCH - Search Files for Text
_____________________________________________________________________


DESCRIPTION

  TEXTSRCH is a utility that will search for all occurrences of a
  given string inside of a specified text file.  It will stop at each
  occurrence and display the found string, and prompt the user to
  continue or to exit.


VERSION

  5.00  07/08/95


COMMAND FORMAT

  TEXTSRCH [filespec] [text]


TIDY - Disk Cleanup Utility
_____________________________________________________________________


DESCRIPTION

  Finds and deletes all .BAK and ZERO length files.  Optionally
  search child subdirectories.


VERSION

  5.00  05/23/95


COMMAND FORMAT

  TIDY  [drive] [/P] [/W] [/R] [/Z] [/A] [/L] [/S] [/H] [extension ... ]


  /A  Search all drives.  This mode will search all hard drives in the
      system, including network drives.

  /C  Confirmation mode.  This mode will not delete any files until the
      user has confirmed the deletion.

  /H  Include hidden files in search.  Also searches hidden directories
      if /S is specified.

  /L  List mode.  Lists the files that would be deleted but doesn't
      actually delete them.

  /P  Search all physical drives, excludes network drives.

  /R  Delete read only files.  Normally tidy will not delete files that
      have the read-only attribute set.  This parameter will override that
      function.

  /S  Recurse into subdirectories.  Normally, only the current
      directory is processed.  This switch causes all child
      directories to be processed as well.

  /T  Terse operation.  Directory and filenames are suppressed.  Only
      the summary information is displayed.

  /X  Execute.  Since TIDY displays help if no command line options are
      issued, this switch is required to execute with the defaults.

  /Z  Ignore zero length files.  Some programs require that zero length
      files be kept.  With /Z set no zero length files will be deleted.


TIDY - Disk Cleanup Utility
_____________________________________________________________________

NOTES

  TIDY displays the name of each file and its size as it is deleted.
  Also displays a summary of files that it has erased, as well as a
  total showing how much disk space was freed. Enter any words on the
  command line after TIDY, and the program will search for files with
  those extensions and delete them.

  You can specify default command line options in the environment
  using the TIDY= variable.  For example, to default to "Ignore Zero
  Length Files" and search for the extension "TMP" (in addition to the
  default "BAK" extension" type at the command line:

                             SET TIDY=/Z TMP

  You can override the /Z by including /Z- at the command line,
  although you can not suppress the TMP extension search without
  clearing the environment variable.

EXAMPLES

  TIDY MAP

  tells TIDY to delete all .BAK fiels, as well as all .MAP files.

  You cannot specify global wildcards ("*" or "???" in the file
  extension, but you can list up to 62 extensions to search for.

  Additionally, you can give TIDY a disk drive specifier to have the
  program tidy that drive.  For example, to tidy up on the A: drive,
  use TIDY A:.

  You can use the extensions and disk drive specifier in any order,
  but the only restriction is that the specifier must contain the
  colon and there must only be one specifier on a line.  So,

  TIDY A: MAP TMP  will perform identically to  TIDY MAP TMP A:

  The /C option will cause the program to prompt the user if the file
  should really be deleted or not.  If the user enters Q, for quit,
  the program exits and displays a status report.


TIMBER - File Chopping Utility
_____________________________________________________________________


DESCRIPTION

  TIMBER is a utility that allows you to chop off the front end of any
  file leaving a specified amount of the end of the file in tact.


VERSION

  5.00  07/05/95


COMMAND FORMAT

  TIMBER source [/b:nnnn] [/lt:nn]

  source      is the source file name

  /b:nnnn     resulting file will be the bottom nnnn bytes of source

  /lt:nn      chop nn lines from the top of a source text file

  /noh        Supress header (registered version only)


EXAMPLE

  TIMBER pcbtext.txt /b:40000

  would chop off the front of the file pcbtext.txt leaving the last
  40,000 bytes


  TIMBER pcbtext.txt /lt:10

  would chop off the first 10 lines of text from the file pcbtext.txt



TOUCH - File date and stamp stamping
_____________________________________________________________________


DESCRIPTION

  TOUCH is a unix utility that is used to stamp a file's attributes
  with the current (or specified) system date and time.  This is
  useful if you want to have a group of files with identical date
  and time stamps.  Wildcards are acceptable in the filespec.


VERSION

  5.00  07/07/95


COMMAND FORMAT

  TOUCH [hh:mm[:ss]] [mm/dd/yy] filespec ...

  Note that the seconds portion of the time is optional.  If
  neither the date or time is specified the computer's current
  date and time will be used.  If only one of the two, date or
  time, is specified, only that portion will be modified in the
  files, e.g. specifying the time only will result in the time
  being modified but the date of the file will remain unchanged.


EXAMPLES

  This sets the file to the current time and date,

        TOUCH source.asm


  This sets the file time to 1:23, the file date is unchanged,

        TOUCH 1:23 source.asm


  This sets the file date to 1/1/95, the file time is unchanged,

        TOUCH 1/1/95 source.asm


  This sets the file time to 1:23 and the file date to 1/1/95,

        TOUCH 1/1/95 1:23 source.asm


  The order of the parameters is unimportant.  Using the DOS
  country code information, TOUCH decides what portion of the
  command line is a date or time and what represents a filename.

  Date and time formatting varies from country to country.  For
  example, some countries uses a period '.' as time separator
  character, e.g. 2.30.12.  If both the date and time use the
  same separator character you should use ':' for the time and
  '/' for the date, which are always recognized by TOUCH.

  TOUCH supports wildcards and multiple file specifications, all
  these examples touch the files to the current time and date:

        TOUCH source.asm
        TOUCH source.*
        TOUCH source.* make.fil

TURBOBAT - Turbo Batch File Compiler
_____________________________________________________________________


DESCRIPTION

  TurboBAT allows you to compile standard DOS batch files into .COM
  binary programs.  This will greatly enhance the speed of large batch
  files by allowing them to run in native code rather than interpreted
  DOS commands. The resulting .COM files may call nested batch files
  without loosing the parent since the parent calling program is now
  no longer a batch file.


COMMAND FORMAT

  TURBOBAT [/1][/4][/A][/Dname][/I][/L][/T][/X] file[.ext]

  /1      Insert single stepping code.  The creates a version of the
          output that is useful when debugging a batch file.  When the
          output .COM program is run, it will single step through each
          line of the original program.

  /4      Supress 4DOS warning messages.  Don't report any warning
          messages generated by the use of 4DOS specific commands.

  /A      Supress all warning messges (same as /4/I/L/X).  Don't
          display any warning messages, only error messages.

  /Dname  Include full symbolic tracing information.  If NAME is
          specified the information will be sent to the named file,
          otherwise is is displayed via the standard error device.
          There must not be any spaces between /D and NAME.

  /I      Ignore nonstandard labels.  DOS supports labels up to 8
          characters long for use with the goto statement.  Many
          people use the label as a comment field rather than a label
          and this can cause problems when a label that is used in a
          non standard fashion shows up during the compile stage of
          the batch file. DOS will noramally just ignore this error.

  /L      Relaxed label length checking.  The normal label size
          recognized by DOS is 8 characters.  In many cases people use
          the : as a place holder for the program without ever
          referencing the label. The problem is that if you have more
          than one long label name where the first 8 digits match
          another label, the file won't compile because it will look
          as though you have duplicate labels.  This switch relaxes
          that limit.

  /T      Compile with line number TRACE information.  The line number
          information is displayed via the standard error device.
          When running the output program compiled with this option on
          you will get a display of each line number as the program is
          running. This is useful when trying to determine where a
          program is failing.


TURBOBAT - Turbo Batch File Compiler
_____________________________________________________________________


  /X      Supress extension warning messages.  Normally during
          compilation, TurboBAT will warn you about any lines that
          make use of commands that are supported by the compiler but
          are not supported by DOS. Using the /X will tell TurobBAT
          not to warn you about any BATCH files that will not function
          under normal DOS conditions.

  /B-     Use ANSI escape sequences instead of the BIOS.  The default
          screen I/O is now handled by making calls to the video BIOS.
          This insures that the compiled batch file will work on any
          machine with or without ANSI.SYS installed.  The drawback
          to this is that BIOS calls are much slower than ANSI calls.
          If you know that the machine that will be running the
          compiled program then using the /B- command will speed up
          the video calls.


NOTES

  TurboBAT is a multipass batch file compiler.  It takes interpreted
  DOS batch files and turns them into binary programs that can execute
  up to as much as 4 times faster than normal batch files.  While
  supporting most of the normal DOS functions that can be called from
  within a batch file, TurboBAT also provides many additional features
  including support for many 4DOS/NDOS commands.


WARNING !!!!

  From a compiled batch file, do not execute any programs that will
  remain resident in memory when it terminates.  Doing so can result
  in an unstable system, requiring you to reboot your computer.


EXTENDED BATCH COMMANDS

  TurboBAT support many commands beyond those supported in normal
  batch files. Some of these commands are in support of J.P. Softwares
  4DOS Batch Enhancements and others are to replace small external DOS
  utilities.


THE ENVIRONMENT

  Initially, a compiled batch file will retrieve information from its
  local environment.  However, when a command such as SET is used
  which modifies the environment the compiled batch file will
  use the system's master environment.  If a compiled batch file
  that does not modify the environment executes another compiled
  batch file or program that does modify the environment, it will
  return incorrect results.  The fix is very simple, simply add a
  line near the start of the main batch file that modifies the
  environment, e.g.:

                 UNSET DUMMY


TURBOBAT - Turbo Batch File Compiler
_____________________________________________________________________


INTERNALLY SUPPORTED COMMANDS


  DOS Commands and batch file commands that are directly supported by
  TurboBAT and require no external programs are:


  %?     "Internal" evironment variable.  Expands to the error level
         of the last executed program as a string.

         Example:  SET LASTERROR=%?


  BEEP   BEEP [frequency duration ...]

         Sounds a tone of the specified frequency for the duration in
         clock ticks.  The defaults are 440Hz (A below middle C) for 2
         clock ticks (about 1/4 second).

         The list of tones and durations can be repeated on a single
         line. This table is identical to the 4DOS tone table:

          ͻ
           C        131    262    523    1040    2093 
           C#/Db    139    277    554    1103    2217 
           D        147    294    587    1176    2349 
           D#/Eb    156    311    622    1241    2489 
           E        165    330    659    1311    2637 
           F        175    349    698    1391    2794 
           F#/Gb    185    370    740    1488    2960 
           G        196    392    784    1568    3136 
           G#/Ab    208    415    831    1662    3322 
           A        220    440    880    1760    3520 
           A#/Bb    233    466    932    1866    3729 
           B        248    494    988    1973    3951 
          ͼ


  BOOT   BOOT [WARM | COLD]

         Boots the computer.  If no options are specified or if WARM
         is specified a WARM boot will occur.  If COLD is specified
         the computer will go through the entire cold boot process.
         Under Desqview, a warm boot will only close the window.

  CDD    CDD drive:path

         Changes subdirectories and drives.  This command will change
         the current directory and drive to the one specified in
         [drive:path] and make the current DOS drive equal to the
         value in [drive]. Normally within dos the CD command will
         change directories on any drive that you specify but will
         keep the current drive the same. CDD allows you to switch to
         that drive rather than stay on the current drive.

TURBOBAT - Turbo Batch File Compiler
_____________________________________________________________________


  CHDIR/CD  CD path
            CD drive:path

            Change the current directory as specified in path.  If a
            drive is specified than change the current directory of
            that drive to the directory specified in path.

  CLS       CLS [[bright] [blink] fg on bg]

            Clears the screen and optionally sets the screen color.
            When setting the colors the syntax is identical to the
            COLOR command.

  COLOR     COLOR [bright] [blink] fg ON bg

            Uses ANSI escape squences to set the screen color. Only
            the first three letters of each command word are actually
            significant.  The following colors are allowed:

              BLAck     BLUe      GREen     RED
              MAGenta   CYAn      YELlow    WHIte

            Example:  COLOR BRIGHT WHITE ON BLUE

  DELAY     DELAY [seconds][/T]

            Pauses for the specified interval in seconds.  If no
            duration is given it will pause for 1 second.  If /T is
            specified then the value is in system ticks (1/18th sec)
            rather than in seconds.

  ECHO      ECHO [message]

            If the /D switch was used at compile time you can enable
            or disable command echoing with ECHO OFF and ECHO ON.
            ECHO without any text will indicate if the /D switch was
            used when the file was compiled, not the current status of
            command echoing. To display a blank line use "ECHO:" or
            "ECHO.".


TURBOBAT - Turbo Batch File Compiler
_____________________________________________________________________


  ECHOS     ECHOS [message]

            Displays the message without appending a cr/lf to the end
            of the message like ECHO does.  (used to be ECHONLN but was
            updated to match the 4DOS command.

  ELSE      If the IFF condition was false the lines from ELSE to
            ENDIFF will be executed.

            See Also IFF.

  ELSEIFF   ELSEIFF condition [THEN]

            Similar structure to the IFF command. If the previous IFF
            was false and the current condition is true the code
            following will be executed to the next ELSE, ELSEIFF, or
            ENDIFF statement.  Each use of ELSEIFF counts as a nesting
            level.  The compiler actually converts this command into
            logical ELSE^IFF^ENDIFF statements.

            See Also IFF.

  ENDIFF    Terminates an IFF statement.

            See Also IFF.

  EXIT      EXIT is used when at the DOS level if you are running
            within a shelled version of the command interpretor and
            you wish to exit the shelled session.  The EXIT command is
            ignored by TurboBAT. See also QUIT.


  FOR       FOR %%var IN (file list) [DO] command

            Allows more than a single letter as the loop variable. Can
            be nested.  The loop variable can be tested from other
            lines by treating it as a normal environment variable.
            The word "DO" is required by DOS but is optional under
            4DOS and Turbobat.


TURBOBAT - Turbo Batch File Compiler
_____________________________________________________________________


  GOTO   GOTO label

         Will jump control to the label.  Labels are marked as a line
         begining with a :.

  GOSUB  GOSUB label

         Calls a label in the current batch file as a subroutine. Must
         have a matching RETURN statement. The end of the batch file
         does NOT act as a RETURN.

  IF     IF [NOT] first (== | EQ | NE | LT | LE | GT | GE) second command
         IF [NOT] ERRORLEVEL [== | EQ | NE | LT |LE | GT | GE] value command
         IF [NOT] ENVFREE [== | EQ | NE | LT |LE | GT | GE] value command
         IF [NOT] EXIST filename command.
         IF [NOT] ISDIR path command

         EQ (equal), also '==' and '='
         NE (not equal),
         LT (less than),
         LE (less or equal),
         GT (greater than),
         GE (greater or equal).

         If no compare command is used for ERRORLEVEL or ENVFREE the
         default of GE will be used.

         EXIST tests for the existence of a file.

            IF EXIST my.cfg GOTO continue
            ECHO Configuration file is missing
            QUIT 99
            :continue

         ISDIR tests if the given path specification is an existing
         subdirectory.

            IF NOT ISDIR \work MD \work

         ENVFREE tests the available environment space.

            IF ENVFREE LT 123 ECHO Insufficient environment space



TURBOBAT - Turbo Batch File Compiler
_____________________________________________________________________


  IFF    IFF condition [THEN]

         If the condition is true the lines up to ELSE, ELSEIFF or
         ENDIFF (whichever appears first) will be executed. IFF
         statements may be nested up to 15 levels deep.  See also IF.

                IFF %? EQ 0 THEN
                  GOTO CONTINE
                ELSEIFF %? EQ 99
                  THEN GOTO CRITICAL
                ELSE
                  GOTO ERROR
                ENDIFF

         See also:  ELSE, ELSEIFF, ENDIFF

  INKEY  INKEY [/Wn] [message] %%var

         Gets a single keystroke and places it in the environment.
         %%var is the environment variable that will be assigned the
         keystroke. If /W is specified the command will wait up to
         that many seconds, e.g. /W10. It will also optionally display
         a message.  If a wait of zero is used (/W0) the command will
         return immediately if no keystrokes are pending.  The wait
         period can be specified in the environment, but the /W must be
         present on the line at compile time, e.g.:

             inkey /w%delay Press any key: %%key

         Displayable keystrokes (characters above the space) are
         stored as their corresponding character.  Keystrokes that do
         not have a corresponding character are displayed as a number,
         e,g. the carriage return as "13".  Extended keystrokes such
         as F1 are stored with a preceding '@', (@59 for F1).

  INPUT  INPUT [/Wn] [message] %%var

         Gets a string and places it in the environment.  %%var is the
         environment variable that will be assigned the string.  The
         string is terminated by a carriage return or end of file mark
         (^Z).  Extended keystrokes are ignored.  /Wn is the optional
         maximum time in seconds to wait for the first keystroke.
         Once a keystroke is entered this command will not time out.

  LOWER  Converts the environment variable to lowercase.

                set test=ABCDEFG
                lower test

          The environment variable TEST is converted to "abcdefg".
          Note a leading "%" is NOT included.

          See also UPPER.

  MKDIR  MKDIR [pathname]
  MD     MD [pathname]

         Will create a new directory of PATHNAME.


TURBOBAT - Turbo Batch File Compiler
_____________________________________________________________________


  PATH   Displays or Sets the Path.

  PAUSE   PAUSE [message]

          Displays an optional message.  If no message is specified the
          default of "Press a key when ready..." is used.  In addition,
          a CR/LF is not output until after the key is pressed.


  PROMPT  Displays or Sets the DOS Prompt

  QUIT    QUIT [exitcode]

          Unconditionally halts the compiled batch file.  If no
          exitcode is specified, zero will be used.  The exit code can
          refer to an environment variable.  If the variable is not a
          number or does not exist zero will be used.  Examples:

                SET var=1
                QUIT %var

          Exits with 1.

                SET var=test
                QUIT %var

          Exits with 0 because %var is not a number.

  REM     REM is the standard DOS Remark field.  REM lines are ignored
          by the TurboBAT Compiler.

  REPEAT/
  UNTIL   Similar to the Pascal structure.  May be nested up to 15
          deep. Redirection is not allowed on a line containing REPEAT
          or UNTIL.

                REPEAT
                  ECHO %1
                  SHIFT
                UNTIL "%1" EQ ""

  RETURN  Return from a subroutine call.  If no subroutines are
          pending it will terminate the batch file with an exit code of 255.

  RD
  RMDIR   Remove Directory.  This will remove the directory specified
          as long as there are no files in it.


TURBOBAT - Turbo Batch File Compiler
_____________________________________________________________________


  SCREEN  SCREEN row column [message]

          Positions the cursor using ANSI sequences and displays an
          (optional) message.  The cursor coordinates are 0 based, the
          normal range being 0-24 rows and 0-79 columns.


  SCRPUT  SCRPUT row col [bright][blink] fg ON bg message

          Writes the message at the specified screen coordinates using
          the specified colors.  The cursor position is restored to
          the position before the command.  ANSI escape sequences are
          used throughout.

  SET     Alone, Set will display the current environment variables,
          or followed by an environment variable, set will set the
          environment variable to the given value.

  SHIFT   Same as standard DOS.  I will be expanding this command for
          4DOS compatibility to accept a shift factor, with support
          for a negative number which will get back previously shifted
          parameters.

  SINGLESTEP    SINGLESTEP ON | OFF

          Enables or disables single stepping.  The /1 compiler switch
          must be used for this command to have any effect.  The
          options are resolved at compile time so you can not use an
          environment variable or command line parameter to set the
          status.

  TEXT/
  ENDTEXT The text that follows, up to ENDIFF will be displayed as if
          each line was preceded by an ECHO. Output redirection is
          more efficient using this command instead of individually
          redirected ECHO commands since the file will only be opened
          and closed once, while the file will be opened and closed
          for each ECHO command.

                TEXT
                This could be a menu
                or it could be help information
                ENDTEXT

                TEXT >dummy
                This text will be sent to the redirection file.
                Up to, but not including the ENDTEXT command.
                ENDTEXT



TURBOBAT - Turbo Batch File Compiler
_____________________________________________________________________


  UNSET   Deletes the environment variable from the master environment.

                UNSET RESULT

  UPPER   Converts the environment variable to uppercase.

                set test=abcdefg
                upper test

          The environment variable TEST is converted to "ABCDEFG".
          Note a leading "%" is NOT included.

          See also LOWER.

  WHILE/
  WEND    Similar to the Pascal structure. May be nested up to 15
          deep. Redirection is not allowed on a line containing WHILE
          or WEND.

                WHILE "%1" NE ""
                  ECHO %1
                  SHIFT
                WEND





COMMANDS HANDLED BY CALLING THE COMSPEC


  These commands are supported by calling COMMAND.COM:

  CALL, DIR, DEL, REN, VER, VOL, CTTY, CHCP, TYPE, COPY, DATE, TIME,
  ERASE, BREAK, RENAME, DELETE, VERIFY, COMMAND


  These commands will only work if 4DOS is the active COMSPEC:

  FREE, DRAWBOX, DRAWHLINE, DRAWVLINE, MEMORY



TURBOBAT - Turbo Batch File Compiler
_____________________________________________________________________


COMPILER ERROR MESSAGES

  TurboBat contains a library of internal error messages and will
  display the error number and message when an error or warning is
  found.  Files with just warnings will compile, files with errors
  will not compile.

  Warning Messages / Error Messages

   1  Duplicate label

      Each label must be unique for a file to compile correctly.  Use
      the /I to relax label checking when using the : for marking
      comments.


   2  Duplicate label (check size)

      Sometimes labels are used as comments in batch files.  If a
      label is unique, but after the 8th character the compiler won't
      pick it up as unique since DOS only supports the first 8
      characters of a label.  You can use the /L option to relax label
      length checking.


   3  Redirection not allowed here

      TurboBAT does not support the redirection of output or input at
      the location specified.


   4  Invalid IF statement

      The IF statement is using invalid syntax, check the manual for
      usage of IF and IFF commands.


   6  Invalid FOR statement

      The FOR statement is using invalid syntax, check the manual for
      the usage of the FOR command.


   7  EXIT can not be used in a compiled batch file

      EXIT is normally used to abort a batch file at any location.
      You can not do this with a compiled batch file.  Replace usage
      of EXIT with a GOTO command that jumps to a label at the end of
      the batch file.

   8  Label not Found.

      A reference was made to a label that does not exist.


TURBOBAT - Turbo Batch File Compiler
_____________________________________________________________________

   9  Program is too large

      The output of the compiled batch file is exceeding 64k bytes.
      TurboBAT currently only supports the .COM format of programs
      under 64k bytes large.  Reduce the commands in your batch file
      if possible.


  10  REPEAT nested too deeply

      You have too many levels of nesting with a REPEAT Loop.  Try
      breaking the repeat loop out of a nested piece of code.


  11  Unmatched UNTIL

      The UNTIL statement found has no opening REPEAT command.


  12  WHILE nested too deeply

      You have too many levels of nesting with a WHILE Loop.  Try
      breaking the while loop out of a nested piece of code.


  13  Unmatched WEND

      The WEND statement found has no opening WHILE command.


  14  Label longer than nn characters, truncated

      Labels that are longer than supported by TurboBAT will be
      truncated to the maximum characters allowed.


  15  IFF nested too deeply

      You have too many levels of nesting with an IFF Loop.  Try
      breaking the iff loop out of a nested piece of code.


  16  Unmatched ELSE statement

      The ELSE statement found has no opening IF or IFF command.


  17  Unmatched ENDIFF statement

      The ENDIFF statement found has no opening IFF command.

  18  Unexpected end of file, no matching ENDTEXT

      A TEXT command was used without an ENDTEXT command and TurboBAT
      read to the end of the input file before finding an ENDTEXT and
      could not finish the compile.

TURBOBAT - Turbo Batch File Compiler
_____________________________________________________________________


  19  Unmatched ENDTEXT

      The ENDTEXT statement found has no opening TEXT command.


  20  Syntax error

      Invalid command syntax was used.  Consult the TurboBAT manual
      for command usage.


  21  4DOS Specific command used

      A command was used that is normally only supported by the use of
      4DOS.  If the 4DOS extension is supported internally by Turbobat
      then there is no problem.  However, if any commands are used that
      are not supported internally the resulting .COM file will only work
      on a system running 4DOS.


  22  TurboBAT extension used

      This is notifying you that a non standard command was used
      inside the batch file.  There is no problem with this usage,
      except that the .BAT file might not work unless compiled with
      TurboBAT.


  23  Open REPEAT statement

      A REPEAT command was used with no UNTIL command to close it.


  24  Open WHILE statement

      A WHILE command was used with no WEND command to close it.


  25  Open IFF/ELSEIFF statement

      An IFF or ELSEIFF statement was used with no ENDIFF to close it.


  26  Command not supported in this version of Turbobat

      A command was used that is not supported by TurboBAT.


  99  Internal error - please contact HyperWare

      An internal processing error has occured with TurboBAT.  Contact
      HyperWare technical support.



TurboTXT - Text File Compiler
_____________________________________________________________________


DESCRIPTION

  TurboTXT will convert a standard text file into a self displaying
  EXE program, containing both text and the necessary code to display
  the text.  The compiled file will have built in search and printing
  capabilities.


COMMAND FORMAT

  TURBOTXT [/Axx] [/Fxx] source [destination]


  /Axx          Sets the video attributes for the text being displayed.
                xx is the attribute value. Use the chart below to
                calculate the attribute value you wish to use.

  /Fxx          Sets the video attributes for the help line at the
                bottom of the screen being displayed. xx is the
                attribute value. Use the chart below to calculate the
                attribute value you wish to use.

  source        the source text file to be compiled.  Can be any
                standard DOS text file.

  destination   can be any valid dos filename.  If no destination is
                entered the file created will be called README.EXE.



TurboTXT - Text file Compiler
_____________________________________________________________________


COLORS

  TurboTXT allows you to choose the video attributes that will be used
  to display the text in the compiled README.EXE program. The number
  used to set the attribute is calculated by choosing the background
  color and then the near ground color. The formula to use to get this
  number is:

  A  = BACKGROUND COLOR x 16
  B  = NEARGROUND COLOR

  xx = A + B;


  BACKGROUND COLORS                   NEARGROUND COLORS

    BLACK      0                       BLACK          0
    BLUE       1                       BLUE           1
    GREEN      2                       GREEN          2
    CYAN       3                       CYAN           3
    RED        4                       RED            4
    MAGENTA    5                       MAGENTA        5
    BROWN      6                       BROWN          6
    LIGHTGRAY  7                       LIGHTGRAY      7
                                       DARKGRAY       8
                                       LIGHTBLUE      9
                                       LIGHTGREEN    10
                                       LIGHTCYAN     11
                                       LIGHTRED      12
                                       LIGHTMAGENTA  13
                                       YELLOW        14
                                       WHITE         15


  so to display LIGHTRED text on a BLUE background you would use
  the following calclation:

  A  = 1 x 16  = 16

  B  = 12

  xx = 16 + 12 = 28

  TurboTXT /A28 README.TXT


TurboTXT - Text file Compiler
_____________________________________________________________________


NOTES

  When this program is executed, the displayed text can be
  scrolled with the cursor keys. Direct screen writing is used so
  the display is extremely fast. Snow supression will occur if a
  CGA monitor is detected.

  If the output file is not specified README.EXE will be used. If
  the extension is omitted from the output filename, EXE will be
  used.

  The following keys are available when the created program is
  executed:

        Up Arrow        Scroll up one line
        Down Arrow      Scroll down one line
        Page Up         Scroll up one page
        Page Down       Scroll down one page
        Left Arrow      Scroll Left one character
        Right Arrow     Scroll Right one character
        Home            Go to start of text
        End             Go to end of text
        F               Find a string in the text file
        A               Search for the next occurance of find string
        P               Print the text file
        ESC             Exit program
        Alt-X           Exit program


  The .EXE program produced automatically supports screen sizes other
  than 80x25. As long as the proper screen values are in the BIOS data
  area and the screen width is at least 80 columns and no greater than
  255 columns it will work with the detected mode automatically.


EXAMPLES

  TURBOTXT help.txt help

  The text in HELP.TXT is used to create HELP.EXE.


UNHANG - Break Out of Locked Programs
_____________________________________________________________________


DESCRIPTION

  UNHANG is a TSR that helps to break out of locked programs.


VERSION

  5.00  07/10/95


RESIDENT MEMORY USAGE

  1824 Bytes


COMMAND FORMAT

  UNHANG [/U]


    /U     Remove UNHANG from memory.


  Press [Ctrl][SysRq] to break out of locked program.


NOTES

  Some programs will leave the system in an unstable state
  which could result in a system lockup after using unhang,
  therefore use unhang only as a last resort.  Do not use
  unhang to break out of programs such as disk diagnostic
  programs.


USEMEM - Programmers Memory Usage Utility
_____________________________________________________________________


DESCRIPTION

  USEMEM is a utility that allows you to tailor you useable memory to
  very exact sizes.  This is very useful when testing programs or
  systems and verifying minimum amounts of memory required.


VERSION

  5.00  07/05/95


USAGE

  USEMEM [nnnn] [/Tnnnn] [/Ennnn] [/TEnnnn] [/U]

  nnnn         amount of conventional memory to use

  /Tnnnn       amount of conventional memory to leave

  /Ennnn       amount of expanded memory to use

  /TEnnnn      amount of expanded memory to leave

  /U           Unload last copy of USEMEM

  /NOH         Supress header (registered version only)

USEMOUSE - Use mouse for Keyboard Emulation
_____________________________________________________________________


DESCRIPTION

  USEMOUSE is a utility designed to any DOS application the ability to
  use the mouse.  USEMOUSE makes mouse movement emulate the four
  directional arrow keys.  You can also specify the emulation values
  for each of the button events of the mouse.  USEMOUSE supports most
  2 and 3 button mice.


VERSION

  5.00  07/05/95


RESIDENT MEMORY USAGE

  928 bytes


COMMAND FORMAT

  USEMOUSE [/?][/Hn][/Vn][Lxxx][/Cxxx][/Rxxx][/Bxxx][/U]


  /?     display information about program

  /Hn    Horizontal acceleration.  Default is 5.  1 is the slowest, 9
         is the fastest.

  /Vn    Vertical acceleration.  Default is 5.  1 is the slowest, 9 is
         the fastest.

  /Lxxx  Left Button key value.  Default is [ENTER]


  /Cxxx  Center Button key value.  Default is

  /Rxxx  Right Button key value.  Default is [ESC]

  /Bxxx  Both Button key value.  Default is [CTRL]C.

         see key chart below

  /U     Uninstall.  Will remove USEMOUSE from memory.

  /D     Disable the functions but remain in memory

  /I     set the TSR ID number where nn is a hex value from 81-FF


USEMOUSE - Use mouse for Keyboard Emulation
_____________________________________________________________________


NOTES

  USEMOUSE's features can be disabled when running an application that
  has built in mouse support.  In this case you will need to run
  USEMOUSE to reset the internal tables for USEMOUSE to continue
  running from non-mouse supported applications.

  Once you have loaded USEMOUSE you can use the mouse in conjunction
  with the normal cursor keys.  USEMOUSE does not disable these keys
  but allows the use of either the cursor keys or the mouse for input.

  Many programs do support mice and when you load some of these
  applications they will disable the USEMOUSE functions upon exiting.
  In thsese situations you will need to reenable the USEMOUSE program
  by running it.  When your run USEMOUSE a second time it will notice
  that a resident copy is already loaded and will reenable the
  USEMOUSE parameters.  If this happens with a program that you use
  often you may wish to add the USEMOUSE command in a batch file to be
  called after exiting the application that causes this.



KEY VALUES

  If you wish to set the USEMOUSE key options to something other than
  the defaults you must use the chart below to determine the code for
  that keystroke.  Codes above 31 must be preceded with an @ symbol as
  these are extended key codes.


        Key            Code
        ---            ----
        [F1]-[F10]     59-68
        [F11]-[F12]    133-134

        [ESC]          01
        [BKSP]         14
        [ENTER]        1C
        [HOME]         71
        [UPARR]        72
        [PGUP]         73
        [LARR]         75
        [RARR]         77
        [END]          79
        [DNARR]        80
        [PGDN]         81
        [INS]          82
        [DEL]          83


VIDMODE - Set DOS Video Mode
_____________________________________________________________________


DESCRIPTION

  VIDMODE allows you to set or reset your video adapters current text
  mode from the DOS prompt.  It supports all video text modes
  including EGA 43 line and VGA 50 line modes.


VERSION

  5.00  07/03/95


COMMAND FORMAT

  VIDMODE [mode] [8x8]

  MODE      SIZE        COLORS/Adapter

   0       40 x 25     Black & White CGA

   1       40 x 25     16 Color CGA

   2       80 x 25     Black & White CGA

   3       80 x 25     16 Color CGA

   7       80 x 25     Monochrome / Hercules

   8x8     Switch to 43/50 line mode (8x8 pixel character font).


NOTES

  If you run VIDMODE with no options you will get a display showing
  the supported modes as well as a notice of the current mode.


VIEW - File Viewing Utility
_____________________________________________________________________


DESCRIPTION

  View allows you to view any file in the MS-DOS environment.  You
  can view text, binary and the list of files in archives (arc, lzh,
  zip, and zoo).  View will automatically choose which viewing mode is
  the best to fit the file type.  You can navigate around your disk
  drive with view and view any file that is listed in the view
  directory listing by pressing the [ENTER] key after highlighting the
  file name.


VERSION

  5.00  06/22/95


COMMAND FORMAT

  VIEW [filename]


  [filename]  is the name of the file to view.  If none is entered View
              will display a directory listing


NOTES

  As of version 5.00, VIEW supports a configuration file called
  VIEW.INI.  VIEW looks for this file in current directory or in the
  directory that VIEW.EXE is located in.

  Currently only the following options are supported:

     HEX=
       Followed by a list of file extensions that should be displayed
       in hex mode, by default.
     ZOOM=
       Followed by YES or NO.  Indicates to use as much of the screen
       as possible.  Zooming the screen reduces the usefullness of the
       mouse since there will not be a frame with a scroll bar.
     MODE50=
       Followed by YES, NO, or DEFAULT.  Controls 50 line mode on VGA
       screens (43 lines on EGA).  YES forces 50 line mode on, NO
       forces it off (uses 25 line mode), and DEFAULT uses the screen
       mode currently active.


EXAMPLE INI SETTINGS

  These correspond to the program defaults, that is, the settings used
  if VIEW.INI is not found.

  HEX=EXE COM OVL
  ZOOM=NO
  MODE50=DEFAULT


VOLLABEL - Set Disk Volume Label
_____________________________________________________________________


DESCRIPTION

  VOLLABEL is a utility that allows you to view and modify the volume
  label on any disk.  The volume label is a 12 digit string that can
  be placed on any disk to help you recognize what the disk is used
  for. VOLLABEL also allows you to erase an existing label.


VERSION

  5.00  07/05/95


COMMAND FORMAT

  VOLLABEL [d:] [label]

  d:         is the drive that the label is to be found on.

  [label]    is any string up to 12 characters to be placed on the
             disk as the volume label.


NOTES

  This is a replacement for the DOS file LABEL, which is available in
  DOS 3.0 and greater.  Unlike DOS's LABEL, VOLLABEL allows
  embedded spaces and will prompt you for the information
  required.


TECHNICAL SUPPORT
_____________________________________________________________________


  Often we get calls from people asking questions that can be
  solved easily by checking through the manual before calling tech
  support. We ask that you browse the manual and look for information
  pertaining to your particular problem before calling. This can often
  save you time, as we take a collection of our most common questions
  and try to address them in this manual.

  We offer alternative methods besides the conventional phone
  support, such as a multi-line 24-hour BBS system. We also monitor
  most technical conferences in the BBS Interlink and RelayNet
  networks as well as many conferences on the CompuServe
  Information System. You may send messages and questions via any of
  these services.

  Currently our Tech Support office is staffed Monday through Friday
  from 9:00 a.m. to 5:00 p.m. Pacific Time. There is a chance,
  however, that someone is in the office outside this time frame.
  If so, we will gladly answer your questions outside the normal
  business hours.  Registered users are given unlimited technical
  support.

  HyperWare
  Technical Support Department
  185 Berry Street
  San Francisco, CA  94107
  (415) 882-1740
  (415) 882-1733 FAX
  (415) 882-1735 BBS
  PCVENB CONF. 13 CompuServe


CREDITS
_____________________________________________________________________


  This collection of utilities started out as a small set of home
  grown tools that I just could not stand to live without.  Many times
  someone would see me using them and ask for a copy.  This was a big
  mistake.  All of the sudden I had to debug my code.  Someone would
  call me up and remind me of some problem with a utility that I had
  written or asked me to just add this one little feature.  Six years
  later the package has evolved to its current state.  Along the way I
  have had the help of many people in testing and ideas for products.
  I would like to thank all of those people who have of course
  registered these utilities as this is now a new incentive for
  continuing to expand them.  More specifically I'd like to thank the
  following:

  Kathy Smith
  Jay Wessel
  Roger Cross
  Brian & Tess for Channel 1
  Paul Somerson & Bantam Books
  PC Tech Journal (A Great Loss)
  PC Magazine
  Byte Magazine
  Jerry Pournelle
  PC Techniques
  Mons. Bruno Pratts of Ch. Cos d'Estournel

PROGRAMMING

  The ExtraDOS Toolbox utilties use a wide variety of programming
  tools including:

  Borland Pascal 7.0
  Borland Assembler 3.0
  Borland C++ 3.1
  Borland Turbo Debugger 2.0
  Turbo Power Software Object Professional 1.21
  Phil Katz' PKLite Professional 1.13
  Unity Programmers Editor 3.36
  Ralph Browns' Interrupt List


  Programming by:

  Mike Blaszczak
  Stella Chin
  David Foley
  Joe Halpin
  Bill McKee
  Mike Molloy
  Mike Viens
  Ross Neilson Wentworth
  Randall Woodman


CREDITS
_____________________________________________________________________


ART

  Artwork for the ExtraDOS Toolbox was created using:

  Ian Davis' TheDraw 4.01
  Aldus Freehand 2.0
  Electronic Arts Studio/8 2.0


  Art by:

  David Foley
  Noel Gamboa
  Moses Gates
  Shahasp Herardian
  Pat McSween
  Ross Neilson Wentworth


DOCUMENTATION

  Documentation for the ExtraDOS Toolbox was written using:

  HyperWare SuperEdit 5.00
  Word Perfect 5.1
  MS Word for Windows 6.0
  Grammatik for Windows 1.0
  Aldus Pagemaker 4.0
  Unity Programmers Editor 3.33


  Documentation by:

  Mike Blaszczak
  Stella Chin
  David Foley
  Mike Viens
  Ross Neilson Wentworth



LICENSE INFORMATION

  CHIMES, EVAL and RAMDRIVE are derivatives of the Nifty James
  utilties by Mike Blaszczak.

  FILEATTR and  NAMEDIR are derivatives of the Fantastic
  Utilities by Mike Viens.

HyperWare Products
_____________________________________________________________________


Safety Disk (tm)

  Safety Disk saves all of your systems vital information and will
  solve most problems due to:  Loss of battery power, Loss of CMOS
  information, accidental deletion of boot files, virus damage to boot
  disk.


  "Use Safety Disk and your PC is Safe.", Computer Shopper, March 1992

  "Used in Conjuntion with a conventional backup utility, Safety Disk,
   for $59.95 will provide as bulletproof a backup as you're likely to
   find in the PC marketplace.", InfoWorld, February 10, 1992

  "Safety Disk is so deceptively easy to use that it makes hard-drive
   and computer maintenance seem impossibly easy.", PCM Magazine, May
   1992

  "I have discovered the most unique and useful system maintenance
   utility since Spinrite came along.", MBUG PC Newsletter, December,
   1991


ExtraDOS Toolbox (tm)

  A large collection of over 50 utilities that DOS forgot. Includes
  many helpful utilities that enhance MS-DOS machines. Featured in the
  DOS Power Tools, 2nd Edition, Revised for DOS 5.0 book by Bantam
  Books.


WizLabel (tm)

  Print Sharp Wizard phone listings directly to your SLP Printer
  without having to convert your data.


Coach Database System.

  CDBS provides a method for tracking and evaluating NBA teams, NBA
  players, and college players. It supplies a comprehensive report
  generator for building decision support reports on scouted players.


HyperWare Products
_____________________________________________________________________


Press Gate Manager.

  Software for event organizers. Creates and maintains a database of
  events and guests with the ability to track seating by type,
  location, and person. Produces seating charts and labels for press
  passes.


FINDB.

  Financial Database System for tracking shareholders in a company.
  Allows the instant retrieval of information based on any part of a
  persons account id, ss#, zip code etc.  Has support for completely
  customized HP Laserjet tax forms.  Ideal for generating K1 tax
  reports for limited partnerships.


