/*
SYSTEM SNIFFER -VIDEO.CPP
Copyright (C) Tero Ripattila 1996-1998
*/

typedef struct {
 byte VESASign[4];                            // VESA -merkint
 word Version;                                // VESA -versio
 byte *OEMString;                             // OEM -merkint
 byte Functions[4];                           // Mahdolliset toiminnot
 } VESAINFO;

SnifferVideo::SnifferVideo(void)
{
}

SnifferVideo::~SnifferVideo(void)
{
}

void SnifferVideo::GetVideoInfo(void)
{
	byte cvmode = 0,rownum = 0;
	word colnum = 0;
	row = 3;

	colnum  = peek(0x0040,0x004A);
	rownum  = peekb(0x0040,0x0084);
	cvmode  = peekb(0x0040,0x0049);

	SGui->PutCaptionAndMsg(VIDEO);

	textbackground(BG_BG);

	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),    cprintf(" Current videomode.....: ");
	 textcolor(ANSWER_TXT),cprintf("%02Xh [%ux%u] \n",cvmode,colnum,rownum + 1);
/*
	byte cheight = 0,vpages = 0;
	cheight = peek(0x0040,0x0085);
	vpages  = peek(0x0040,0x004C);

	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),    cprintf(" Character height......: ");
	 textcolor(ANSWER_TXT),cprintf("%u scanlines \n",cheight);
	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),    cprintf(" Size of one videopage.: ");
	 textcolor(ANSWER_TXT),cprintf("%uB \n",vpages);
*/
	SVideo->GetAdapInfo();
	if( !DFlags->DisableVESA )
	 SVideo->GetVESAInfo();
	SVideo->GetVESAPMInfo();
}

void SnifferVideo::GetAdapInfo(void)
{
	byte AheadStr[5] = "",ParadiseStr[4] = "",OAKStr[7] = "";
	byte ATIStr[9] = "",ATIAdap[2] = "",GenoaStr[11] = "",ATIMdl = 0;
	word AheadOff = 0x0025,ParadiseOff = 0x007D,OAKOff = 0x0008;
	word ATIOff = 0x0031,ATIAdO = 0x0040, GenoaOff = 0,i = 0;

	GenoaOff = peek(0xC000,0x0037);
	for(i = 0; i < 5; i++)
	 AheadStr[i] = peekb(0xC000,AheadOff++);
	for(i = 0; i < 4; i++)
	 ParadiseStr[i] = peekb(0xC000,ParadiseOff++);
	for(i = 0; i < 7; i++)
	 OAKStr[i] = peekb(0xC000,OAKOff++);
	for(i = 0; i < 9; i++)
	 ATIStr[i] = peekb(0xC000,ATIOff++);
	for(i = 0; i < 2; i++)
	 ATIAdap[i] = peekb(0xC000,ATIAdO++);
	for(i = 0; i < 11; i++)
	 GenoaStr[i] = peekb(0xC000,GenoaOff++);

	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),cprintf(" Video adapter.........: ");
	 textcolor(ANSWER_TXT);

	if(!memcmp(AheadStr,"AHEAD",5))
	 cprintf("AHEAD \n");
	else if(!memcmp(ParadiseStr,"VGA=",4))
	 cprintf("Paradise \n");
	else if(!memcmp(OAKStr,"OAK VGA",7))
	 cprintf("OAK Tech OTI-037/057/067/077 chipsets \n");
	else if(!memcmp(ATIStr,"761295520",9)) {
	 ATIMdl = peekb(0xC000,0x0043);
	 textcolor(BG_TXT),cprintf("Adapter: ");
	 textcolor(ANSWER_TXT);
	  if(!memcmp(ATIAdap,"22",2))
	   cprintf("EGA Wonder");
	  else if(!memcmp(ATIAdap,"31",2))
	   cprintf("VGA Wonder");
	  else if(!memcmp(ATIAdap,"32",2))
	   cprintf("EGA Wonder800+");
	  else
	   cprintf("Unknown");
	 textcolor(BG_TXT),cprintf(", Model: ");
	 textcolor(ANSWER_TXT);
	  switch(ATIMdl) {
	   case 0x31: cprintf("18800");   break;
	   case 0x32: cprintf("18800-1"); break;
	   case 0x33: cprintf("18800-2"); break;
	   case 0x34: cprintf("18800-4"); break;
	   case 0x35: cprintf("18800-5"); break;
	   case 0x62: cprintf("68800AX"); break;
	   default:   cprintf("Unknown"); break;
	   }
/*
	if(peekb(0xC000,0x0042)&0x02==0x02) cprintf(", Mouseport present");
	if(peekb(0xC000,0x0042)&0x10==0x10) cprintf(", Programmable video clk");
	if(ATIMdl>0x30) {
	 if(peekb(0xC000,0x0044)&0x80==0x80) cprintf("HiColor DAC");
	 if(peekb(0xC000,0x0044)&0x40==0x40) cprintf("No 8514/A monitor support");
	 if(peekb(0xC000,0x0044)&0x10==0x10) cprintf("Paged ROMs");
	 if(peekb(0xC000,0x0044)&0x08==0x08) cprintf("Zero wait states");
	 if(peekb(0xC000,0x0044)&0x04==0x04) cprintf("45 MHz memory clock rather than 40 MHz");
	 if(peekb(0xC000,0x0044)&0x02==0x02) cprintf("Korean characters");
	 if(peekb(0xC000,0x0044)&0x01==0x01) cprintf("70 Hz non-interlaced display");
	 }
*/
	 }
	 else if(!memcmp(GenoaStr,"77 00 99 66",11))
	  cprintf("Genoa 6200/6300 \n");
	 else if(!memcmp(GenoaStr,"77 11 99 66",11))
	  cprintf("Genoa 6400/6600 \n");
	 else if(!memcmp(GenoaStr,"77 22 99 66",11))
	  cprintf("Genoa 6100 \n");
	 else if(!memcmp(GenoaStr,"77 33 99 66",11))
	  cprintf("Genoa 5100/5200 \n");
	 else if(!memcmp(GenoaStr,"77 55 99 66",11))
	  cprintf("Genoa 5300/5400 \n");
	 else cprintf("Unknown \n");
}

void SnifferVideo::GetVESAInfo(void)
{
	VESAINFO *VESAInfo;

	inregs.x.ax = 0x4F00;
	segregs.es  = FP_SEG( VESAInfo );
	inregs.x.di = FP_OFF( VESAInfo );
	int86x(0x10,&inregs,&outregs,&segregs);

	gotoxy(SCR_BEG,row++);
	textcolor(BG_TXT),cprintf(" VESA-compatible video.: ");
	if( !memcmp( VESAInfo->VESASign,"VESA",4 ) /*&& _AX == 0x004F*/ ) {
	 textcolor(ANSWER_TXT),cprintf( "V" );
	 ShowBCD( VESAInfo->Version );
	 }
	else
	 textcolor(ANSWER_TXT),cprintf("Not present \n");
}

void SnifferVideo::GetVESAPMInfo(void)
{
	byte VESAPMState = 0,VESAPMVersion = 0,VESAPMSupSt = 0,DispStSup = 0;
	byte DispStStatus = 0,DispStPSt = 0;

	asm	mov ax,0x4F10
	asm	mov bl,0x00
	asm	int 0x10
	asm	mov VESAPMState,ah            // Otetaan selville onko VESA VB/PM asennettu
	asm	mov VESAPMVersion,bl          // Otetaan VESA VB/PM versionumero talteen
	asm	mov VESAPMSupSt,bh            // Otetaan tuetut tilat talteen
	asm	mov ax,0x4F10
	asm	mov bl,0x02
	asm	int 0x10
	asm	mov DispStSup,al              // Otetaan selville onko funktiota tuettu
	asm	mov DispStStatus,ah           // Otetaan kutsun tulos selville
	asm	mov DispStPSt,bh              // Otetaan nytn virran tila selville

	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),cprintf(" VESA Power Managment..: ");
	 textcolor(ANSWER_TXT);
	 if( !VESAPMState ) {
	  cprintf("Version: %u.%02u", HiByte( VESAPMVersion ),
		  LoByte( VESAPMVersion ) );
	  gotoxy(SCR_BEG + 24,row++);
	   textcolor(BG_TXT),cprintf(" Display power state: ");
	   textcolor(ANSWER_TXT);
	   if(DispStSup == 0x4F && !DispStStatus) {
	    switch(DispStPSt) {
	     case 0x08: cprintf("Reduced on"); break;
	     case 0x04: cprintf("Off");        break;
	     case 0x02: cprintf("Suspend");    break;
	     case 0x01: cprintf("Standby");    break;
	     case 0x00: cprintf("On");         break;
	     default:   cprintf("Unknown");    break;
	     }
	   } else cprintf("Not present \n");
	  }
	 else cprintf("Not present \n");
}

void SnifferVideo::GetCirrusLogicInfo(void)
{
/*
	!!! TYN ALLA !!!

	Katso tiedostoa _CLOGIC.CPP

	!!! TYN ALLA !!!
*/
}