/*
SYSTEM SNIFFER - DISK.CPP
Copyright (C) Tero Ripattila 1996-1998
*/

struct DISK_INFO {
 dword	AvailDskSpc;                  	      // Vapaan levytilan mr
 dword	TotalDskSpc;                 	      // Koko levytilan mr
 dword	UsedDskSpc;                   	      // Kytetyn levytilan mr
 word	SPerClus;                     	      // Sektoria per klusteri
 word	BPerSec;                      	      // Tavua per sektori
 word	NofTotalClus;                 	      // Kaikkien klustereiden lkm
 word   NofFreeClus;                  	      // Vapaiden klustereiden lkm
 };

typedef struct {
 word	InfoLev;                      	      // Info-taso
 dword	SerialNo;                    	      // Levyn sarjanumero binrimuodossa
 byte	VolLabel[11];                 	      // Levyn nimi
 byte	FileSystem[8];                        // Tiedostojrjestelm
 } DISKINFO;

SnifferDisk::SnifferDisk(void)
{
}

SnifferDisk::~SnifferDisk(void)
{
}

void SnifferDisk::GetDiskInfo(void)
{
	byte CurDrive = 0, ValDrive = 0,SelDrive = 0;

	row = 3;

	SGui->PutCaptionAndMsg(DISK);

	textbackground(BG_BG);

	CurDrive = SDisk->GetDefDrive();
	ValDrive = SDisk->SetDefDrive( CurDrive );

	if( ( DFlags->UDefinedDrive - 'A' + 1 ) <= ValDrive )
	 SelDrive = DFlags->UDefinedDrive - 'A' + 1;
	else
	 SelDrive = CurDrive + 1;

	SDisk->GetDiskSpace( SelDrive );
	SDisk->GetCurDir( SelDrive );
}

void SnifferDisk::GetDiskSpace(byte drive)
{
	DISK_INFO Disk;
	DISKINFO DiskInfo;

	word ErrCode = 0,letter = 0,CorelCDXState = 0;
	byte MSCDEXState = 0,bootdrive = 0;
	version = 0;

// ***************************************** // Boottiasema
	asm	mov  ax,0x3305
	asm	int  0x21
	asm	mov  bootdrive,dl             // Otetaan bootdrive talteen
// ****************************************** // CD-ROM asemat (MSCDEX)
	asm	mov  ax,0x1100
	asm	int  0x2f
	asm	mov  MSCDEXState,al           // Tutkitaan onko MSCDEX kytss
	asm	mov  ax,0x150c
	asm	int  0x2f
	asm	mov  version,bx               // Otetaan MSCDEX:n versionnumero talteen
// ****************************************** // CD-ROM asemat (CORELCDX)
	asm	mov  ax,0x15ff
	asm	mov  bx,0x0000
	asm	int  0x2f
	asm	mov  CorelCDXState,bx         // Otetaan selville onko CORELCDX asennettu
// ****************************************** // CD-ROM asemat (asemakirjain)
	asm	mov  ax,0x1500
	asm	mov  bx,0x0000
	asm	int  0x2f
	asm	mov  letter,ax                // Otetaan CD-aseman asemakirjain talteen

	regs.h.ah = 0x36;
	regs.h.dl = drive;
	int86(0x21,&regs,&regs);
	Disk.SPerClus = _AX;
	Disk.BPerSec = _CX;
	Disk.NofTotalClus = _DX;
	Disk.NofFreeClus = _BX;
	Disk.AvailDskSpc = (dword)Disk.NofFreeClus * Disk.BPerSec * Disk.SPerClus;
	Disk.TotalDskSpc = (dword)Disk.NofTotalClus * Disk.BPerSec * Disk.SPerClus;
	Disk.UsedDskSpc = (dword)(Disk.NofTotalClus - Disk.NofFreeClus) * Disk.BPerSec * Disk.SPerClus;

	inregs.h.ah = 0x69;
	inregs.h.al = 0x00;
	inregs.h.bl = drive;
	inregs.h.bh = 0x00;
	segregs.ds = FP_SEG( &DiskInfo );
	inregs.x.dx = FP_OFF( &DiskInfo );
	int86x(0x21,&inregs,&outregs,&segregs);
	ErrCode = _AX;

	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),    cprintf( " Number of fixed disk drives.: " );
	 textcolor(ANSWER_TXT),cprintf( "%u \n",peekb(0x0040,0x0075) );
	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),    cprintf( " Bootdrive...................: " );
	 textcolor(ANSWER_TXT),cprintf( "%c \n",bootdrive + 'A' - 1 );
	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),    cprintf( " Current drive...............: " );
	 textcolor(ANSWER_TXT),cprintf( "%c \n",drive + 'A' - 1 );
	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),    cprintf( " Serial number...............: " );
	 textcolor(ANSWER_TXT),cprintf( "%04Xh:%04Xh \n",
					HiDword( DiskInfo.SerialNo ),
					LoDword( DiskInfo.SerialNo ) );
	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),    cprintf( " Bytes per sectors...........: " );
	 textcolor(ANSWER_TXT),cprintf( "%u \n",(word)Disk.BPerSec );
	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),    cprintf( " Sectors per clusters........: " );
	 textcolor(ANSWER_TXT),cprintf( "%u \n",Disk.SPerClus );
	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),    cprintf( " Total number of clusters....: " );
	 textcolor(ANSWER_TXT),cprintf( "%u \n",Disk.NofTotalClus );
	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),    cprintf( " Number of free clusters.....: " );
	 textcolor(ANSWER_TXT),cprintf( "%u \n",Disk.NofFreeClus );
	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),    cprintf( " Total disk space............: " );
	 textcolor(ANSWER_TXT),cprintf( "%10ld B \n",Disk.TotalDskSpc );
	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),    cprintf( " Used disk space.............: " );
	 textcolor(ANSWER_TXT),cprintf( "%10ld B \n",Disk.UsedDskSpc );
	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),    cprintf( " Free disk space.............: " );
	 textcolor(ANSWER_TXT),cprintf( "%10ld B \n",Disk.AvailDskSpc );

	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),cprintf( " CD-ROM extension............: " );
	 textcolor(ANSWER_TXT);
	  if( CorelCDXState == 0xABCD )
	   cprintf( "CORELCDX installed \n" );
	  else {
	   switch(MSCDEXState) {
	    case 0x00: cprintf( "Not installed [OK to install] \n");	 break;
	    case 0x01: cprintf( "Not installed [Not OK to install] \n"); break;
	    case 0xff: cprintf( "MSCDEX V%u.%02u (%c)",HiWord( version ),
				LoWord( version),letter + 'A' );         break;
	   default:    cprintf( "Unknown \n" );                          break;
	   }
	  }

	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),cprintf( " Disk label..................: " );
	 textcolor(ANSWER_TXT);
	  if( !outregs.x.cflag ) {
	   if( !memcmp(DiskInfo.VolLabel,"NO NAME    ",11) )
	    cprintf("Volume has no label \n");
	   else if( !memcmp(DiskInfo.VolLabel,"           ",11) )
	    cprintf("Label not available \n");
	   else {
	    for( TempB = 0; TempB < 11; TempB++ )
	     cprintf( "%c",DiskInfo.VolLabel[TempB] );
	    }
	   } else textcolor(ERROR_TXT),cprintf("Error [%04Xh]",ErrCode);

	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),cprintf( " File system.................: " );
	 textcolor(ANSWER_TXT);
	  if( !outregs.x.cflag ) {
	   if( !memcmp(DiskInfo.FileSystem,"FAT12   ",8) )
	    cprintf( "12-bit FAT \n" );
	   else if( !memcmp(DiskInfo.FileSystem,"FAT16   ",8) )
	    cprintf( "16-bit FAT \n" );
	   else if( !memcmp(DiskInfo.FileSystem,"CDROM   ",8) )
	    cprintf( "High Sierra CD-ROM filesystem \n" );
	   else if( !memcmp(DiskInfo.FileSystem,"CD001   ",8) )
	    cprintf( "ISO 9660 CD-ROM filesystem \n" );
	   else if( !memcmp(DiskInfo.FileSystem,"CDAUDIO ",8) )
	    cprintf( "Audio CD \n" );
	   else
	    cprintf( "Unknown \n" );
	   } else textcolor(ERROR_TXT),cprintf("Error [%04Xh]",ErrCode);
}

byte SnifferDisk::GetDefDrive( void )
{
	asm	mov	ah,0x19
	asm	int	0x21

	return( _AL );
}

byte SnifferDisk::SetDefDrive( byte Drive )
{
	asm	mov	ah,0x0E
	asm	mov	dl,Drive
	asm	int	0x21

	return( _AL );
}

void SnifferDisk::GetCurDir(byte drive)
{
	byte CurrentDir[64] = "";

	inregs.h.ah = 0x47;
	inregs.h.dl = drive;
	segregs.ds  = FP_SEG( CurrentDir );
	inregs.x.si = FP_OFF( CurrentDir );
	int86x(0x21,&inregs,&outregs,&segregs);

	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),    cprintf( " Current directory...........: " );
	 textcolor(ANSWER_TXT),cprintf( "%c:\\%s \n",drive + 'A' - 1,CurrentDir );
}
