/*
SYSTEM SNIFFER - DOSEXT.CPP
Copyright (C) Tero Ripattila 1996-1998

Tunnistettavat DOS:in laajentimet
 - DOS/4GW
 - DOS/16M
 - DOS/4G
 - Phar Lap DOS Extender
 - DOS Extender
*/

enum _PLDE_COMPONENTS {
	_PLDE_286DOSX_SDK = 0x01,
	_PLDE_286DOSX_RTK = 0x02,
	_PLDE_386DOSX_SDK = 0x03,
	_PLDE_386DOSX_RTK = 0x04 };

bool SnifferSWare::ChkDOS4GW(void)
{
	asm	mov ax,0xBFDC
	asm	mov dx,0x0000
	asm	mov si,0x0000
	asm	int 0x15

	return( _DX ? TRUE : FALSE );
}

bool SnifferSWare::ChkDOS16M(void)
{
	asm	mov ax,0xBF02
	asm	mov dx,0x0000
	asm	int 0x15

	return( _DX ? TRUE : FALSE );
}

bool SnifferSWare::ChkDOS4G(void)
{
	asm	mov ax,0xFF00
	asm	mov dx,0x0078
	asm     int 0x21

	return( _AL ? TRUE : FALSE );
}

word* SnifferSWare::ChkPLDOSE(void)
{
	byte TempB = 0;
	word InstCompo[4] = { 0,0,0,0 };

	for(TempB = _PLDE_286DOSX_SDK; TempB <= _PLDE_386DOSX_RTK; TempB++) {
		asm	mov ax,0xED00
		asm	mov bl,TempB
		asm	int 0x2F
		asm	cmp al,0xFF
		asm	jne NotFound
		InstCompo[TempB] = _CX;       // Otetaan versionumero talteen
	      NotFound:
	 }

	return( InstCompo );
}

bool SnifferSWare::ChkDOSE(void)
{
	asm	mov ax,0xF100
	asm	int 0x2F

	if( _AL == 0xFF )
	 return(TRUE);
	else
	 return(FALSE);
}