
/*
    Xunzip for Linux, handles gzip and zip files via zlib.
    Copyright (C) 1998 Tero Koskinen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
*/

/* xunzip.qt.cpp */

#ifndef USE_GTK

#include <string.h>
#include <stdio.h>
#include <fstream.h>

#include <qapp.h>
#include <qpushbt.h>
#include <qfont.h>
#include <qlistbox.h>
#include <qlabel.h>
#include <qfiledlg.h>
#include <qframe.h>
#include <qlabel.h>
#include <qstrlist.h>
// #include <qslider.h>
#include <qmsgbox.h>
#include <qpopmenu.h>
#include <qmenubar.h>
#include <qdialog.h>
#include <qlined.h>
#include <qpixmap.h>
#include <qgrpbox.h>
#include <qchkbox.h>
#include <qbttngrp.h>
#include <qradiobt.h>

#include <kstatusbar.h>
#include <ktoolbar.h>

#include <kapp.h>
#include <kkeydata.h>
#include <ktopwidget.h>
#include <klocale.h>
#include <kiconloader.h>

#include <drag.h>

#include "zipHeader.h"
#include "utils.h"
#include "config.h"
#include "mjono.h"
#include "itoa.h"

#include "xunzip.qt.h"
#include "xunzip.moc"
#include "xunzip.tw.moc"

extern ZipPacket zip;

MyWidget::MyWidget(QWidget *,const char *name) // ( QWidget *parent, const char *name )
//        : QWidget( parent, name )
    :KTopLevelWidget(name)
{
    KConfig *config;
    char eMessage[100];
    tyhjennaTaulukko(eMessage,100);
    strcpy(eMessage,"Xunzip ");
    strcat(eMessage,VERSION);
    
    selected_file=-1;
    
    config=kapp->getConfig();

    setCaption(eMessage);

    setMinimumSize( 250, 200 );
    setMaximumSize( 370, 350 );
    resize(270,250);
/*
    quit = new QPushButton( "Quit", this, "quit" );
    quit->setGeometry( 190, 10, 55, 25 );
    quit->setFont( QFont( "Charter", 14, QFont::Bold ) );

    connect( quit, SIGNAL(clicked()), qApp, SLOT(quit()) );
    
    open=new QPushButton("Open",this,"open");
    open->setGeometry(5,10,55,25);
    open->setFont(QFont("Charter",14,QFont::Bold));
    connect(open,SIGNAL(clicked()),SLOT(openfile()));
    
    unzip=new QPushButton("Extract",this,"extract");
    unzip->setGeometry(65,10,55,25);
    unzip->setFont(QFont("Charter",14,QFont::Bold));
    connect(unzip,SIGNAL(clicked()),SLOT(unzipfile()));
    
    test=new QPushButton("Test",this,"test");
    test->setGeometry(125,10,60,25);
    test->setFont(QFont("Charter",14,QFont::Bold));
    connect(test,SIGNAL(clicked()),SLOT(testfile()));
*/
    createMenu();
    createToolbar();
    
	msg=new KStatusBar(this);
	msg->insertItem((char*)klocale->translate("Xunzip"),0);
	setStatusBar(msg);

    // fmain=new QFrame(this,"frame_0");
    
    lista=new KTabListBox( this );
    lista->setSeparator('\t');
    lista->setNumCols(2);
    lista->setColumn(0,"File info",130);
    lista->setColumn(1,"Compress");

    // lista->setGeometry(5,45,240,150);
    connect(lista,SIGNAL(selected(int,int)),SLOT(listItemSelected(int,int)));
    
    KDNDDropZone *dz = new KDNDDropZone( lista, DndURL );
    connect( dz, SIGNAL(dropAction(KDNDDropZone *)),SLOT( fileDrop(KDNDDropZone *)) ); 
/*    
    msg=new QLabel(this,"message");
    msg->setFrameStyle(QFrame::Panel|QFrame::Sunken);
    msg->setFont( QFont("times",12,QFont::Bold) );
    msg->setAlignment( AlignLeft );
    msg->setGeometry(5,200,240,20);
*/
	
    setView(lista);

    tb->show();
    // fmain->show();
    lista->show();
    msg->show();
    mainmenu->show();
    
    
    updateRects();
}

MyWidget::~MyWidget()
{
    if (mainmenu) delete mainmenu;
    if (msg) delete msg;
    if (tb) delete tb;
    if (lista) delete lista;
}

void MyWidget::resizeEvent( QResizeEvent *re )
{
    int col = lista->numCols()-1;
    int colpos=0;
    KTopLevelWidget::resizeEvent( re );
    
    lista->resize( lista->width(), lista->height() );
    if( lista->colXPos( col, &colpos ) )
	    lista->setColumnWidth( col, ((this->width())-colpos) );
}

void MyWidget::createMenu(void)
{
    QPopupMenu *mfile,*mactions;

    mfile=new QPopupMenu;
    CHECK_PTR(mfile);
    mfile->insertItem(klocale->translate("&Open"),this,SLOT(openfile()));
    mfile->insertSeparator();
    mfile->insertItem(klocale->translate("&Quit"),qApp,SLOT(quit()),CTRL+Key_Q);
    
    mactions=new QPopupMenu;
    CHECK_PTR(mactions);
    mactions->insertItem(klocale->translate("&Extract"),this,SLOT(unzipfile()),CTRL+Key_E);
    mactions->insertItem(klocale->translate("&Test"),this,SLOT(testfile()),CTRL+Key_T);
	    
    mainmenu=new KMenuBar(this,"main menu");
    CHECK_PTR(mainmenu);
    if (mainmenu)
    {
	    mainmenu->insertItem(klocale->translate("&File"),mfile);
	    mainmenu->insertItem(klocale->translate("&Actions"),mactions);
	    // mainmenu->show();
	    setMenu(mainmenu);
	}
}

void MyWidget::createToolbar(void)
{
    KIconLoader *loader=kapp->getIconLoader();

    QPixmap pix;
    // QString ppath;
        
    // ppath=kapp->kdedir()+QString("/share/toolbar/");
    tb=new KToolBar(this,"toolbar");
    
    // pix.load(ppath+"fileopen.xpm");
    pix=loader->loadIcon("fileopen.xpm");
    tb->insertButton(pix,0,SIGNAL(clicked()),this,SLOT(openfile()),TRUE,klocale->translate("Open"));

    //pix.load(ppath+"viewzoom.xpm");
    pix=loader->loadIcon("viewzoom.xpm");
    tb->insertButton(pix,1,SIGNAL(clicked()),this,SLOT(unzipfile()),TRUE,klocale->translate("Extract..."));

    tb->insertSeparator();
    // pix.load(ppath+"exit.xpm");
    pix=loader->loadIcon("exit.xpm");
    tb->insertButton(pix,2,SIGNAL(clicked()),qApp,SLOT(quit()),TRUE,klocale->translate("Quit"));

    addToolBar(tb);
    tb->setBarPos(KToolBar::Top);
    enableToolBar(KToolBar::Show);
}


// open archive
void MyWidget::openfile()
{
    QString fileName=QFileDialog::getOpenFileName();
    if (!fileName.isNull())
    {
	    // cout << fileName << endl;
	    if (zip.open(fileName,lista)==-1)
		    showMessage(klocale->translate("Cannot open the file"));
    }
}


// unzip file(s) from packet
void MyWidget::unzipfile()
{
    QString d;
    DirDialog *dir;
    dir=new DirDialog();
    int opts;
    if (dir->exec())
    {
	    d=dir->getPath();
	    opts=dir->getOptions();
	    if (opts)
		    opts=selected_file;
		else
		    opts=-1;
	    if (d.isNull())
			return;
		if (zip.unZip(d,opts)==-1)
		{
		    showMessage(klocale->translate("Cannot extract to the selected directory"));
		}
	}
}


// test files in packet
void MyWidget::testfile()
{
    TestWindow *tw;
    tw=new TestWindow();
}

void MyWidget::listItemSelected(int i,int col=0)
{
    // char eMessage[FNAME_MAX+100];
    unsigned long a=0,b=col;
    Mjono apu;
    CDRNode *p;
    p=zip.getNode(i);
    if (p)
    {
	    a=p->h.getUnCSize();
	    b=p->h.getCSize();
	    
	    apu=Mjono(p->h.getFilename())+Mjono(" ")+itoa(b)+Mjono("/")+itoa(a)+Mjono(" bytes");
	    msg->changeItem((char*)klocale->translate(apu.AnnaMjono()),0);
	    selected_file=i;
	}

}

void MyWidget::fileDrop(KDNDDropZone *dz)
{
    QStrList dlist;
    QString url;
    QString file;
    char *foo;
    
    dlist=dz->getURLList();
    url=dlist.at(0);
    file=url.right(url.length()-5);
    foo=file.data();
    if (foo[strlen(foo)-1] != '/')
    {
	    zip.open(file,lista);
	}
}

TestWindow::TestWindow(QWidget *parent=0,const char *name=0):
QWidget(parent,name)
{
    setCaption("Test");

    setMinimumSize( 200, 200 );
    setMaximumSize( 200, 200 );
    
    msg=new QLabel(this,"label");
    // msg->setFrameStyle(QFrame::Panel|QFrame::Sunken);
    msg->setFont( QFont("times",12,QFont::Bold) );
    msg->setAlignment( AlignLeft );
    msg->setGeometry(5,5,190,20);
    msg->setText(klocale->translate("Wait..."));
    
    lista1=new QListBox( this, "virhelista" );
    lista1->setGeometry(5,26,190,140);
    // connect(lista,SIGNAL(selected(int)),SLOT(listItemSelected(int)));
    
    ok=new QPushButton(klocale->translate("Ok"),this,"ok");
    ok->setGeometry(80,171,30,25);
    connect(ok,SIGNAL(clicked()),SLOT(closeWindow()));
    
    zip.testcrc(lista1);
    msg->setText(klocale->translate("Errors"));
    
    show();
}

TestWindow::~TestWindow()
{
    lista1->clear();
}

DirDialog::DirDialog(QWidget *parent=0,char *name=0) :
    QDialog(parent,name,TRUE)
{

    QButtonGroup *gb=new QButtonGroup("Options",this);
    gb->setAlignment(AlignLeft);
    gb->setGeometry(10,100,200,100);

    QGroupBox *g1=new QGroupBox(klocale->translate("Directory"),this);
    g1->setAlignment(AlignLeft);
    g1->setGeometry(10,10,200,80);
    QGroupBox *g2=new QGroupBox(klocale->translate("Unzip"),this);
    g2->setAlignment(AlignLeft);
    g2->setGeometry(220,10,80,110);
    
    le=new QLineEdit(this);
    le->setGeometry(30,40,160,20);
    le->setText(getenv("HOME"));
    
	setCaption(klocale->translate("Extract"));
	
	rb1=new QRadioButton(klocale->translate("All files"),gb);
	rb1->setGeometry(10,20,160,30);
	rb1->setEnabled(TRUE);
	
	rb2=new QRadioButton(klocale->translate("Selected file"),gb);
	rb2->setGeometry(10,50,160,30);
	rb2->setEnabled(TRUE);
	
	rb1->setChecked(TRUE);
	
	QPushButton *b1=new QPushButton(klocale->translate("Ok"),this);
	b1->setGeometry(230,30,60,30);
	connect(b1,SIGNAL(clicked()),SLOT(accept()));
	
	QPushButton *b2=new QPushButton(klocale->translate("Cancel"),this);
	b2->setGeometry(230,70,60,30);
	connect(b2,SIGNAL(clicked()),SLOT(reject()));
}

const char *DirDialog::getPath(void)
{
    return le->text();
}


#endif

