/*
    Xunzip for Linux, handles gzip and zip files via zlib.
    Copyright (C) 1998 Tero Koskinen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
*/

/* xunzip.qt.h */

#ifndef USE_GTK

#include <qapp.h>
#include <qpushbt.h>
#include <qfont.h>
#include <qlistbox.h>
#include <qlabel.h>
#include <qfiledlg.h>
#include <qframe.h>
#include <qlabel.h>
#include <qdialog.h>
#include <qlined.h>
#include <qgrpbox.h>
#include <qchkbox.h>
#include <qradiobt.h>

#include <kapp.h>
#include <kkeydata.h>
#include <ktopwidget.h>
#include <kmenubar.h>
#include <ktoolbar.h>
#include <kstatusbar.h>
#include <drag.h>
#include <kfm.h>

#ifndef TK_QT_H
#define TK_QT_H

extern ZipPacket zip;

class MyWidget: public KTopLevelWidget //public QWidget
{
    Q_OBJECT
public:
    MyWidget(QWidget *widget=0,const char *name=0); // ( QWidget *parent=0, const char *name=0 );
    ~MyWidget();
    KTabListBox *lista;
    

public slots:    
    void fileDrop(KDNDDropZone *);    
private slots:
    void openfile();
    void unzipfile();
    void testfile();
    void listItemSelected(int i,int col=0);
protected:
    void resizeEvent( QResizeEvent * );
private:
    // QLabel *msg;
    QPushButton *quit;
    QPushButton *open;
    QPushButton *unzip;
    QPushButton *test;
    KMenuBar *mainmenu;
    // QFrame *fmain;
    KStatusBar *msg;
    KToolBar *tb;

    // KeyButton *test;
    // QFileDialog *filesel;
    int selected_file;

    void createMenu(void);
    void createToolbar(void);
};

/*
class DirDialog: public QFileDialog
{
    Q_OBJECT
public:
    DirDialog(void):QFileDialog()
    {
	    setCaption("Select directory where uncompress file(s)");
	    connect(this,SIGNAL(fileSelected(const char*)),
		    this,SLOT(extractTo(const char*)));
		show();
    }
public slots:
    void extractTo(const char *path)
    {
	    if (zip.unZip(path)==-1)
		{
		    showMessage("Cannot extract to the selected directory");
		}
    }
};
*/
class DirDialog: public QDialog
{
    Q_OBJECT
public:
    DirDialog(QWidget *parent=0,char *name=0);
    
    int getOptions(void) { if (rb2->isChecked()) return 1; return 0; }
    const char *getPath(void);
private:
    QLineEdit *le;
    QRadioButton *rb1,*rb2;
private slots:
    // void browse();
};

#endif TK_QT_H

#endif // USE_GTK

