/*
    Xunzip for Linux, handles gzip and zip files via zlib.
    Copyright (C) 1998 Tero Koskinen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
*/

// utils.cpp

#include <fstream.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>

#ifdef USE_GTK
#include <gtk/gtk.h>
#else
#include <qapp.h>
#include <qlistbox.h>
#include <qdialog.h>
#include <qmsgbox.h>
#endif
#include "utils.h"
#include "config.h"

unsigned int readint(ifstream & fin)
{
  char ch;
  unsigned int a;
  fin.get(ch);
  a=ch;
  fin.get(ch);
  a+=(ch<<8);
  return a;
}

unsigned long readlong(ifstream & fin)
{
    // char a,b,c,d;
    unsigned long longtmp;
    // fin.get(a).get(b).get(c).get(d);
    fin.read((char*)&longtmp,4);
    return (longtmp);
}

void makedirs(const char *path)
{
    char dirname[FNAME_MAX]; // riittaakohan 1024 polun kooksi
    char *cp;
    
    strcpy(dirname,path);
    cp=dirname;
	while((cp=strchr(cp,'/')))
	{
	    *cp=0;
	    mkdir(dirname,DIRMODE);
	    *cp++='/';
	}
}

void tyhjennaTaulukko(char *taulukko,int koko)
{
    for (int a=0;a<koko;a++)
	    taulukko[a]='\0';
}

#ifdef USE_GTK
// tuhoa ilmoitusdialogi(showMessagen luoma)
void delete_show_message (GtkWidget *, GtkWidget *data)
{
  gtk_widget_hide(data);
  gtk_widget_destroy(data);
}
#endif
// naytetaan haluttu viesti
void showMessage(const char *ilmoitus)
{
#ifdef USE_GTK
  GtkWidget *label;
  GtkWidget *button;
  GtkWidget *window;
  GtkWidget *box;
  
  window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), "Message");
  gtk_signal_connect(GTK_OBJECT (window), "destroy",(GtkSignalFunc) delete_show_message,window);
  // gtk_signal_connect(GTK_OBJECT (window), "delete_event",(GtkSignalFunc) delete_show_message,window);
  gtk_container_border_width (GTK_CONTAINER (window), 10);
  box=gtk_hbox_new(FALSE,0);
  gtk_container_add(GTK_CONTAINER(window),box);
  label = gtk_label_new (ilmoitus);
  gtk_misc_set_padding (GTK_MISC (label), 10, 10);
  gtk_box_pack_start (GTK_BOX (box), label, TRUE, TRUE, 0);
  gtk_widget_show (label);
  button = gtk_button_new_with_label ("OK");
  gtk_signal_connect(GTK_OBJECT (button), "clicked",(GtkSignalFunc) delete_show_message,window);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_widget_show(button);
  gtk_box_pack_start (GTK_BOX (box), button, TRUE, TRUE, 0);
  gtk_widget_grab_default (button);
  gtk_widget_show(box);
  gtk_widget_show(window);
#else
  QMessageBox::message("Message",ilmoitus);
#endif
}

void showError(const char *text,int size,const char *filename)
{
    char eMessage[FNAME_MAX+30];
    tyhjennaTaulukko(eMessage,FNAME_MAX+30);
    strncpy(eMessage,text,size);
    strcat(eMessage,filename);
    showMessage(eMessage);
}


