.\"
.\"   @(#)cddbcmd.man	6.5 98/04/03
.\"
.\"   cddbcmd - Connect to a CDDB server site and execute a simple CDDB
.\"             server command.
.\"
.\"   Copyright (C) 1993-1998  Ti Kan
.\"   E-mail: ti@amb.org
.\"
.\"   This program is free software; you can redistribute it and/or modify
.\"   it under the terms of the GNU General Public License as published by
.\"   the Free Software Foundation; either version 2 of the License, or
.\"   (at your option) any later version.
.\"
.\"   This program is distributed in the hope that it will be useful,
.\"   but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"   GNU General Public License for more details.
.\"
.\"   You should have received a copy of the GNU General Public License
.\"   along with this program; if not, write to the Free Software
.\"   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\"
.TH CDDBCMD 1 "25 March 1998" "v2.3"

.SH "NAME"
cddbcmd \- Connect to a CDDB server site and execute a simple CDDB
server command.

.SH "SYNOPSIS"
.B cddbcmd
.nh
[-\fIm\fP \fImode\fP] [-\fIp\fP \fIproxyhost[:port]\fP]
[-\fIh\fP \fIserverhost[:port]\fP] [-\fIc\fP \fIcgipath\fP]
[-\fIl\fP \fIlevel\fP] [-\fId\fP] \fIcommand\fP ...

.SH "DESCRIPTION"
The
.I cddbcmd
utility is a simple shell command interface to the CDDB (CD database)
server.  CDDB protocol commands can be sent via
.I cddbcmd.
Output from CDDB protocol commands are stripped of the status code line
and then displayed on standard output.  Input to CDDB protocol commands
are read from standard input.  Both the CDDBP or HTTP mode of CDDB server
connection styles are supported.  In order to use this utility, your
system must be connected to the Internet, and DNS (domain name service)
must be functional.

.SH "OPTIONS"
.I cddbcmd
supports the following options:
.TP
.I \-m\ mode
Specifies the mode of CDDB server connection.  The \fImode\fP must
be either \fBcddbp\fP or \fBhttp\fP.  The default is cddbp.
.TP
.I \-p\ proxyhost[:port]
If a proxy server must be used, this option specifies the proxy
server host to connect to.  The optional port argument specifies
the port number,  The default is port 80.  This option is meaningful
only when used in http mode.
.TP
.I \-h\ serverhost[:port]
Specifies the CDDB server host to connect to.  The default is
.B cddb.cddb.com  The optional port argument specifies the port
number,  The default is port 888 for cddbp, and port 80 for http.
.TP
.I \-c\ cgipath
If http mode is used, this option specifies the path to the
CDDB server CGI program.  The default is \fI/~cddb/cddb.cgi\fP
.TP
.I \-l\ level
This specifies the CDDB protocol level to use.  The default
level is 3.
.TP
.I \-d
Enable debugging diagnostics.
.TP
.I command
The CDDB server command string to send to the server.  Here is a
non-exhaustive list of such commands:
.sp
.nf
\fImotd\fP
\fIsites\fP
\fIstat\fP
\fIlog\fP
\fIwhom\fP
\fIproto\fP (cddbp only)
\fIhelp\fP
\fIcddb lscat\fP
\fIcddb query\fP
\fIcddb read\fP
.fi
.sp
Some of these commands require additional arguments.
Please consult the \fICDDB Specifications\fP for details about CDDB
server commands.  The specifications are available on the CDDB
web site: \fIhttp://www.cddb.com/\fP

.SH "SEE ALSO"
xmcd(1), cda(1), wm2xmcd(1),
.br
Xmcd web site: http://sunsite.unc.edu/~cddb/xmcd/
.br
CDDB web site: http://www.cddb.com/

.SH "AUTHOR"
Ti Kan (\fIti@amb.org\fR)
.br
AMB Research Laboratories, Sunnyvale, CA, U.S.A.
.PP
Comments, suggestions, and bug reports are always welcome.

