.TH petcat 1 "12 Dec 1996" "VICE" "C64 Program Development"
.nr X
.SH NAME
petcat \- convert and display PETSCII or BASIC files
.SH SYNOPSIS
.IR petcat
[
.B \-text
|
\-<\fIversion\fR>
|
.B \-w<\fIversion\fR>
|
.B \-k<\fIversion\fR>
] [
.B \-l \fIhexaddr\fR
] [
.B \-c
|
.B \-nc
] [
.B \-o \fIoutfile\fR
] [
.B \-skip \fIoffset\fR
] [
\--
] [
.B file list
]
.SH DESCRIPTION
.IR petcat
converts input files from the most common CBM file formats into
printable ASCII form and writes to standard output. The type
of input file is determined automatically, if possible, and
appropriate conversion is performed.
Since a few of the BASIC versions have keywords defined differently,
the right conversion has to be selected on the command line.
Where such confusion cannot happen, automatical recognition of input
is used. This is useful when expanding several files at once or if
the program contains code for several versions, selected according to
the hardware; eg. Simon's Basic vs. Basic 7.0.
.br
Please note that each input file is converted individually,
but the output is produced as continuous flow. Also, all input
files that are read trough a pipe, are concatenated before they
reach
.IR petcat
so any machine language section in between the BASIC programs causes
all consecutive files to be taken as one machine language program.
For that reason files containing machine language parts attached to
them must be input separately, otherwise the remaining files won't
be expanded.
.IR petcat
recognizes normal PETSCII text files (SEQ), program files containing
directory listing, and BASIC programs. Both the original CBM files and
files with a PC64 `P00' header are accepted. The different BASIC versions
are not automatically distinquished, but standard C64 and C128 versions
are used as default.
.br
In order to tokenize a text file into a BASIC binary file the desired
BASIC version must be exclusively specified so that correct set of
keywords will be used.
If line numbers are not found in the beginning of each program line,
the cruncher creates the missing line numbers by adding 2 to the numeric
value of previous one.
Since also line numbers deviating from strictly ascendind order are
accepted, care must be taken when editing such a program on a C64 again.
.SS Clarification
.LP
Since CBM programs usually contain unprintable characters, a way to
spesify them has been created.
Normally,
.IR petcat
uses the same codes as most printers, but for tokenizing programs
scanned from magazines, it can use the following convention:
.br
.TP 12
.BR "<DOWN>"
stands for single control code
.TP
.BR "<6 RIGHT>"
contains amout of consecutive codes
.TP
List of valid mnemonics:
.br
<wht> <dish> <ensh> <swlc> <down> <rvon> <home> <del> <esc> <red>
<rght> <grn> <blu> <orng> <F1> <F3> <F5> <F7> <F2> <F4> <F6> <F8>
<sret> <swuc> <blk> <up> <rvof> <clr> <inst> <brn> <lred> <gry1>
<gry2> <lgrn> <lblu> <gry3> <pur> <left> <yel> <cyn>
.TP
List of alternate mnemonics:
.br
<wht> <up/lo lock on> <up/lo lock off> <return> <lower case> <down>
<rvs on> <home> <delete> <esc> <red> <right> <grn> <blu> <orange>
<f1> <f3> <f5> <f7> <f2> <f4> <f6> <f8> <shift return> <upper case>
<blk> <up> <rvs off> <clr> <insert> <brown> <lt red> <grey1> <grey2>
<lt green> <lt blue> <grey3> <pur> <left> <yel> <cyn>
.SH OPTIONS
.TP 8
.B \-a \fIload_address\fR
Specify \fIload_address\fR for tokenized program.
.TP
.B \-c
Causes
.IR petcat
to interpret also control characters.
By default, these strings are the same as used by printers. However,
an alternate set is attempted whenever none within the primary set
matches. Default is ON, unless text mode is selected.
.TP
.B \-nc
Suppress control codes.
.TP
.B \-f
Force overwrite of existing output file. Default true.
.TP
.B \-h
Print filename and start address for each Basic file expanded. Default true.
.TP
.B \-nh
Suppress file header in printout.
.TP
.B \-o \fIfile\fR
Redirect output to the specified \fIfile\fR. This option overrules -h.
When \fIfile\fP has extension `.P00' and also -w option is specified, the PC64
file header is written automatically. .P00 file cannot be written on stdout
but to a file only.
.TP
.B \-skip \fIoffset\fR
Skip \fIoffset\fR bytes in the beginning of input file.
.TP
.B \-text
Force text mode even if the input file looks like a Basic program, i.e.
the first byte in file is 01.
.TP
.B \-k<\fIversion\fR>
Just prints all valid keywords for the specified Basic \fIversion\fR.
Without any \fIversion\fR, all names of supported BASIC versions are
listed instead.
.TP
.B \-w<\fIversion\fR>
Tokenise program listing using keywords set from the specified Basic
\fIversion\fR.
.TP
\-<\fIversion\fR>
Changes the set of keywords for the specified Basic \fIversion\fR and
expands tokenized input file.
Without this option
.IR petcat
uses V7.0 keywords in expanding.
.SS Versions
.TP 14
.B 1
Basic 1.0
.TP
.B 2
Basic 2.0
.TP
.B a
Basic 2.0 with AtBasic
.TP
.B t
Basic 2.0 with Turtle Basic
.TP
.B super su se
Basic 2.0 with Super Expander
.TP
.B simon si
Basic 2.0 and Simon's Basic
.TP
.B speech sp
Basic 2.0 with Speech Basic v2.7
.TP
.B 4
Basic 4.0
.TP
.B 4e
Basic 4.0 Extension
.TP
.B 3
Basic 3.5
.TP
.B 7
Basic 7.0
.TP
.B 10
Basic 10.0
.SH RESTRICTIONS
.LP
Line numbers must be less than 65536.
Maximum line length is 255 bytes. Leading white space is ignored.
Blank lines and line numbers not followed by any text are rejected.
While expanding, Machine Language section concatenated to a BASIC
program is ignored.
While crunching, control codes that appear outside quotes are not
interpreted.
The low order byte of load address must be "01".
.SH SEE ALSO
.BR cat (1),
.BR tr (1),
.BR sed (1),
.BR fvcbm (1),
.BR petlp (1),
.BR cbmconvert,
.BR iso2asc (1),
.BR ASCII (7),
.BR "\fICBM Tokens Documentation\fP",
.BR "CBM's \fIProgrammers' Reference Guide\fP series"
.SH AUTHOR
  Jouko Valta    (jopi@stekt.oulu.fi)
.SH Thanks to
  Frederik Ekman (d91fe@lelle.pt.hk-r.se)
  Marko Mkel   (msmakela@nic.funet.fi)
  Russell Alphey (r.alphey@dce.vic.gov.au)
  Andr Fachat   (a.fachat@physik.tu-chemnitz.de)
  Onno Ebbinge   (ebbin200@hio.tem.NHL.NL)
  Frank Kontros  (jeno@kontr.uzhgorod.ua)
