#include <stdio.h>
#include <string.h>
#include "id3tag.h"
#include <fcntl.h>
#include "config.h"

#define TAG_HEAD "TAG"

#ifdef DEBUG
#define DPRINT(x) puts(x)
#define DPRINTF(x,y) printf(x,y)
#else
#define DPRINT(x)
#define DPRINTF(x,y)
#endif

/* Internationarization & Code Convertion */

#define SAVECODE(x) x
#define CODECONV(x) x
#ifdef I18N
#       ifdef	JAPANESE
#       undef SAVECODE
#	define SAVECODE(x) euc_to_sj(x)
#       include "kanji_code.h"
/* Ⱦѥʤν */
void hankaku_kana_cut ( char *buff, int l )
{
  if ( (*(buff+l-2)&0x10)==0x10 && (*(buff+l-3)&0x10)!=0x10 )
    *(buff+l-1)=0x00;
}
#       undef CODECONV
#	define CODECONV(x) sj_to_euc(x)
#	endif
#endif


/* ID TAGɤ߹ */
int read_tag ( char *file_name, MP3_TAG *tag )
{
  int fp;

  char TAG_BUFF[129];
  char BUFF[255];

  tag->Title[0]=0;
  tag->Artist[0]=0;
  tag->Album[0]=0;
  tag->Comment[0]=0;
  tag->Year[0]=0;
  tag->Junle=0xff;

  fp=open(file_name,O_RDONLY);
  if ( fp == 0 ) return ( -2 );
  lseek(fp, -128, SEEK_END);
  if(read(fp,TAG_BUFF,129)<=0){
    close(fp);
    return ( -2 );
  }
  close(fp);

  if (strncmp(TAG_BUFF, TAG_HEAD, 3)!=0) return ( 0 );

  tag->Junle=TAG_BUFF[127];

  /* ID TAGμ */
  strncpy ( BUFF, &TAG_BUFF[3], 30 );
  sp_cut(BUFF, 30);
  strncpy(tag->Title,CODECONV(BUFF),30);
#  ifdef JAPANESE
  hankaku_kana_cut(tag->Title, 30);
#endif

  strncpy ( BUFF, &TAG_BUFF[33], 30 );
  sp_cut(BUFF, 30);
  strncpy(tag->Artist,CODECONV(BUFF),30);
#  ifdef JAPANESE
  hankaku_kana_cut(tag->Artist, 30);
#endif

  strncpy ( BUFF, &TAG_BUFF[63], 30 );
  sp_cut(BUFF, 30);
  strncpy(tag->Album,CODECONV(BUFF),30);
#  ifdef JAPANESE
  hankaku_kana_cut(tag->Album, 30);
#endif

  strncpy ( BUFF, &TAG_BUFF[93], 4 );
  sp_cut(BUFF, 4);
  strncpy(tag->Year, CODECONV(BUFF),4);
#  ifdef JAPANESE
  hankaku_kana_cut(tag->Year, 4);
#endif

  strncpy ( BUFF, &TAG_BUFF[97], 30 );
  sp_cut(BUFF, 30);
  strncpy(tag->Comment,CODECONV(BUFF),30);
#  ifdef JAPANESE
  hankaku_kana_cut(tag->Comment, 30);
#endif
  
  return ( 1 );
}

/* Space򥫥å */
void sp_cut(char *buff, int l )
{
  int i;

  for ( i =(l-1); i >= 0; i -- ){
    if ( *(buff+i) == 0x20 )
      *(buff+i)='\0';
    else
      break;
  }
}

/* spaceɲäCopy */
void sp_cpy(char *dist, char *buff, int max )
{
  int i;
  int l;
  l = strlen(buff);
  for ( i =(max-1); i >=l; i --)
    *(dist+i)=0x20;

  for ( i =(l-1); i >=0; i --) 
    *(dist+i)=*(buff+i);
}

/* Write Id3 TAG */
int Write_ID3 ( char *filename, MP3_TAG *id3_tag )
{
  int fp;
  MP3_TAG *tag;
  char BUFF[4];

  DPRINT("codeconv & space cut\n");
  tag=(MP3_TAG *)malloc(sizeof(MP3_TAG));
  sp_cpy(tag->Title, SAVECODE(id3_tag->Title), 30);
  sp_cpy(tag->Artist, SAVECODE(id3_tag->Artist), 30);
  sp_cpy(tag->Album, SAVECODE(id3_tag->Album), 30);
  sp_cpy(tag->Year, id3_tag->Year, 4);
  sp_cpy(tag->Comment, SAVECODE(id3_tag->Comment), 30);
  tag->Junle=id3_tag->Junle;

  DPRINTF("%s", TAG_HEAD);
  DPRINTF("%s", tag->Title);
  DPRINTF("%s", tag->Artist);
  DPRINTF("%s", tag->Album);
  DPRINTF("%s", tag->Year);
  DPRINTF("%s", tag->Comment);

  DPRINT("File Write\n");
  fp=open(filename,O_RDWR);

  if ( fp <= 0 ) return(0);
  lseek(fp, -128, SEEK_END);
  read(fp,BUFF,3);

  if (strncmp(BUFF, TAG_HEAD, 3)!=0 ) lseek(fp,0,SEEK_END);
  else 
    lseek(fp, -128, SEEK_END);

  write( fp, TAG_HEAD, 3 );
  write( fp, tag->Title, 30 );
  write( fp, tag->Artist, 30 );
  write( fp, tag->Album, 30 );
  write( fp, tag->Year , 4 );
  write( fp, tag->Comment, 30 );
  BUFF[0]=tag->Junle;
  write( fp, BUFF, 1);

  close(fp);
  free(tag);

  return ( 1 );
}
