/*
 *  Copyright (c) 1999 by Takashi Iwai <iwai@ww.uni-erlangen.de>
 *
 *  Definitions of OSS compatible headers for Emu8000 device informations
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef __EMU8000_LEGACY_H
#define __EMU8000_LEGACY_H

#include "../../include/seq_oss_legacy.h"

/*
 * awe hardware controls
 */

#define _EMU8000_OSS_DEBUG_MODE			0x00
#define _EMU8000_OSS_REVERB_MODE		0x01
#define _EMU8000_OSS_CHORUS_MODE		0x02
#define _EMU8000_OSS_REMOVE_LAST_SAMPLES	0x03
#define _EMU8000_OSS_INITIALIZE_CHIP		0x04
#define _EMU8000_OSS_SEND_EFFECT		0x05
#define _EMU8000_OSS_TERMINATE_CHANNEL		0x06
#define _EMU8000_OSS_TERMINATE_ALL		0x07
#define _EMU8000_OSS_INITIAL_VOLUME		0x08
#define _EMU8000_OSS_INITIAL_ATTEN	_EMU8000_OSS_INITIAL_VOLUME
#define _EMU8000_OSS_RESET_CHANNEL		0x09
#define _EMU8000_OSS_CHANNEL_MODE		0x0a
#define _EMU8000_OSS_DRUM_CHANNELS		0x0b
#define _EMU8000_OSS_MISC_MODE			0x0c
#define _EMU8000_OSS_RELEASE_ALL		0x0d
#define _EMU8000_OSS_NOTEOFF_ALL		0x0e
#define _EMU8000_OSS_CHN_PRESSURE		0x0f
#define _EMU8000_OSS_EQUALIZER			0x11

#define _EMU8000_OSS_MODE_FLAG			0x80
#define _EMU8000_OSS_COOKED_FLAG		0x40	/* not supported */
#define _EMU8000_OSS_MODE_VALUE_MASK		0x3F


/*
 * mode type definitions
 */
enum {
/* 0*/	EMU8000_MD_EXCLUSIVE_OFF,	/* obsolete */
/* 1*/	EMU8000_MD_EXCLUSIVE_ON,	/* obsolete */
/* 2*/	EMU8000_MD_VERSION,		/* read only */
/* 3*/	EMU8000_MD_EXCLUSIVE_SOUND,	/* 0/1: exclusive note on (default=1) */
/* 4*/	EMU8000_MD_REALTIME_PAN,	/* 0/1: do realtime pan change (default=1) */
/* 5*/	EMU8000_MD_GUS_BANK,	/* bank number for GUS patches (default=0) */
/* 6*/	EMU8000_MD_KEEP_EFFECT,	/* 0/1: keep effect values, (default=0) */
/* 7*/	EMU8000_MD_ZERO_ATTEN,	/* attenuation of max volume (default=32) */
/* 8*/	EMU8000_MD_CHN_PRIOR,	/* 0/1: set MIDI channel priority mode (default=1) */
/* 9*/	EMU8000_MD_MOD_SENSE,	/* integer: modwheel sensitivity (def=18) */
/*10*/	EMU8000_MD_DEF_PRESET,	/* integer: default preset number (def=0) */
/*11*/	EMU8000_MD_DEF_BANK,	/* integer: default bank number (def=0) */
/*12*/	EMU8000_MD_DEF_DRUM,	/* integer: default drumset number (def=0) */
/*13*/	EMU8000_MD_TOGGLE_DRUM_BANK, /* 0/1: toggle drum flag with bank# (def=0) */
/*14*/	EMU8000_MD_NEW_VOLUME_CALC,	/* 0/1: volume calculation mode (def=1) */
/*15*/	EMU8000_MD_CHORUS_MODE,	/* integer: chorus mode (def=2) */
/*16*/	EMU8000_MD_REVERB_MODE,	/* integer: chorus mode (def=4) */
/*17*/	EMU8000_MD_BASS_LEVEL,	/* integer: bass level (def=5) */
/*18*/	EMU8000_MD_TREBLE_LEVEL,	/* integer: treble level (def=9) */
/*19*/	EMU8000_MD_DEBUG_MODE,	/* integer: debug level (def=0) */
/*20*/	EMU8000_MD_PAN_EXCHANGE,	/* 0/1: exchange panning direction (def=0) */
	EMU8000_MD_END,
};


/*
 * effect parameters
 */
enum {

/* modulation envelope parameters */
/* 0*/	EMU8000_FX_ENV1_DELAY,	/* WORD: ENVVAL */
/* 1*/	EMU8000_FX_ENV1_ATTACK,	/* BYTE: up ATKHLD */
/* 2*/	EMU8000_FX_ENV1_HOLD,	/* BYTE: lw ATKHLD */
/* 3*/	EMU8000_FX_ENV1_DECAY,	/* BYTE: lw DCYSUS */
/* 4*/	EMU8000_FX_ENV1_RELEASE,	/* BYTE: lw DCYSUS */
/* 5*/	EMU8000_FX_ENV1_SUSTAIN,	/* BYTE: up DCYSUS */
/* 6*/	EMU8000_FX_ENV1_PITCH,	/* BYTE: up PEFE */
/* 7*/	EMU8000_FX_ENV1_CUTOFF,	/* BYTE: lw PEFE */

/* volume envelope parameters */
/* 8*/	EMU8000_FX_ENV2_DELAY,	/* WORD: ENVVOL */
/* 9*/	EMU8000_FX_ENV2_ATTACK,	/* BYTE: up ATKHLDV */
/*10*/	EMU8000_FX_ENV2_HOLD,	/* BYTE: lw ATKHLDV */
/*11*/	EMU8000_FX_ENV2_DECAY,	/* BYTE: lw DCYSUSV */
/*12*/	EMU8000_FX_ENV2_RELEASE,	/* BYTE: lw DCYSUSV */
/*13*/	EMU8000_FX_ENV2_SUSTAIN,	/* BYTE: up DCYSUSV */
	
/* LFO1 (tremolo & vibrato) parameters */
/*14*/	EMU8000_FX_LFO1_DELAY,	/* WORD: LFO1VAL */
/*15*/	EMU8000_FX_LFO1_FREQ,	/* BYTE: lo TREMFRQ */
/*16*/	EMU8000_FX_LFO1_VOLUME,	/* BYTE: up TREMFRQ */
/*17*/	EMU8000_FX_LFO1_PITCH,	/* BYTE: up FMMOD */
/*18*/	EMU8000_FX_LFO1_CUTOFF,	/* BYTE: lo FMMOD */

/* LFO2 (vibrato) parameters */
/*19*/	EMU8000_FX_LFO2_DELAY,	/* WORD: LFO2VAL */
/*20*/	EMU8000_FX_LFO2_FREQ,	/* BYTE: lo FM2FRQ2 */
/*21*/	EMU8000_FX_LFO2_PITCH,	/* BYTE: up FM2FRQ2 */

/* Other overall effect parameters */
/*22*/	EMU8000_FX_INIT_PITCH,	/* SHORT: pitch offset */
/*23*/	EMU8000_FX_CHORUS,		/* BYTE: chorus effects send (0-255) */
/*24*/	EMU8000_FX_REVERB,		/* BYTE: reverb effects send (0-255) */
/*25*/	EMU8000_FX_CUTOFF,		/* BYTE: up IFATN */
/*26*/	EMU8000_FX_FILTERQ,		/* BYTE: up CCCA */

/* Sample / loop offset changes */
/*27*/	EMU8000_FX_SAMPLE_START,	/* SHORT: offset */
/*28*/	EMU8000_FX_LOOP_START,	/* SHORT: offset */
/*29*/	EMU8000_FX_LOOP_END,	/* SHORT: offset */
/*30*/	EMU8000_FX_COARSE_SAMPLE_START,	/* SHORT: upper word offset */
/*31*/	EMU8000_FX_COARSE_LOOP_START,	/* SHORT: upper word offset */
/*32*/	EMU8000_FX_COARSE_LOOP_END,		/* SHORT: upper word offset */
/*33*/	EMU8000_FX_ATTEN,		/* BYTE: lo IFATN */

	EMU8000_FX_END,
};
/* number of effects */
#define EMU8000_NUM_EFFECTS  EMU8000_FX_END

/* effect flag values */
#define EMU8000_FX_FLAG_OFF	0
#define EMU8000_FX_FLAG_SET	1
#define EMU8000_FX_FLAG_ADD	2


#endif
