Program FixRom;

{FixRom ver 1.0 by Dines Justesen 02-09-1996

 FixRom corrects the last byte in the ti85 rom dumps made by
 Dump_rom, and copies the files together. The program assumes
 that the files are called pageX.bin where X is the page number.
}

Const
  FileName='page'; FileExt='.bin';{Used for identifing the files}
  FileSize=16384;                 {Standard size of rom files}
  NewFileName='Ti85rom.bin';      {File to be created}
  NewByte : Array[1..8] of byte =
            ($2A,$57,$8E,$5E,$3D,$97,$91,$35);
                                  {Checksum for the rom versions}
  CRLF = #13+#10;                 {New line}
Type
  TRomPage=Array[0..FileSize-1] of byte; {Array holding one rompage}

Var
  RomPage : TRompage;                    {The rom page}
  RFile,WFile : file;                    {Files for reading and writing}
  RomVer : Byte;                         {Rom version}
  i : Integer;                           {Counter}

begin
  Write('FixRom ver 1.0 by Dines Justesen'+CRLF+CRLF+
        'Enter Rom version :'+CRLF+      {Chose rom version}
        '1 :  2.0'+CRLF+
        '2 :  3.0A'+CRLF+
        '3 :  4.0'+CRLF+
        '4 :  5.0'+CRLF+
        '5 :  6.0'+CRLF+
        '6 :  8.0'+CRLF+
        '7 :  9.0'+CRLF+
        '8 : 10.0'+CRLF+
        '>');
  Read(RomVer);                          {Save rom version}
  Assign(Wfile,NewFileName);             {Open file for writing}
  Rewrite(Wfile,1);
  For i:=0 to 7 do                       {Get all pages}
    begin
      Assign(RFile,FileName+Chr(i+ord('0'))+FileExt); {Open file for reading}
      Reset(RFile,1);
      BlockRead(RFile,RomPage,FileSize);              {Read file}
      If i<>7 then                                    {Correct last byte}
        RomPage[FileSize-1]:=$FF
      else
        RomPage[FileSize-1]:=NewByte[RomVer];
      BlockWrite(WFile,RomPage,FileSize);             {Write to new file}
      Close(Rfile);                                   {Close file}
    End;
  Close(Wfile);                                       {--- | | ---}
End.

