/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
/***************************************************************

   (c) 1996 by Salvador Eduardo Tropea (SET).
   e-mail: salvador@inti.edu.ar

   You can use this code for any purpose if you don't remove the
original copyright.

   Filename -       Inf.cpp

   Functions:
                    Member functions of following classes
                        TInfViewer
                        TInfWindow
                        THelpControlDialog
                        TStrListBox

***************************************************************/

#define Uses_TStreamableClass
#define Uses_TPoint
#define Uses_TStreamable
#define Uses_TRect
#define Uses_TScrollBar
#define Uses_TScroller
#define Uses_TDrawBuffer
#define Uses_TEvent
#define Uses_TWindow
#define Uses_TKeys
#define Uses_TPalette
#define Uses_TButton
#define Uses_TListBox
#define Uses_TLabel
#define Uses_TDialog
#define Uses_MsgBox
#define Uses_TFindDialogRec
#define Uses_TInputLine
#define Uses_TCheckBoxes
#define Uses_TRadioButtons
#define Uses_THistory
#define Uses_TSItem
#define Uses_TIndicator
#define Uses_TStatusLine
#include <tv.h>

#if !defined( __Inf_H )
#include "Inf.h"
#endif  // __Inf_H

#if !defined( __UTIL_H )
#include "Util.h"
#endif  // __UTIL_H

#if !defined( __STRING_H )
#include <string.h>
#endif  // __STRING_H

#if !defined( __LIMITS_H )
#include <limits.h>
#endif  // __LIMITS_H

#if !defined( __STAT_H )
#include <sys\stat.h>
#endif  // __STAT_H

#if !defined( __CTYPE_H )
#include <ctype.h>
#endif  // __CTYPE_H

#if !defined( __IO_H )
#include <io.h>
#endif  // __IO_H

#pragma warn -dsz


extern execDialog( TDialog *d, void *data );
const char * const near TCollectionNoSort::name="TCollectionNoSort";
const char * const near TInfIndicator::name="TInfIndicator";


/***************************************************************
 class TInfViewer
***************************************************************/

static int PointInCrossRef(TPoint point,TInfTopic *topic,int & i)
{
 int crossCount = topic->numRefs;
 i = 0;
 if (crossCount == 0) return -1;
 point.y++;
 for (i=0;i<crossCount;i++)
    {
     CrossRef & ref = topic->crossRefs[i];
     if (ref.line > point.y) return -1;
     // Support for crossRefs that cross lines, slow
     if (ref.line == (point.y-1))
       {
        if (ref.linebreak && point.x<=ref.linebreak)
           return i;
        continue;
       }
     if (ref.line < point.y) continue;
     if (ref.offset > point.x) return -1;
     if (ref.offset+ref.length <= point.x) continue;
     return i;
    }
 i = crossCount;
 return -1;
}

void TInfViewer::resetCursor()
{
  int before;
  TScroller::resetCursor();
  selected = PointInCrossRef(cursor+delta,topic,before)+1;
}

void TInfViewer::scrollDraw()
{
 TPoint  d;

 if( hScrollBar != 0 )
     d.x = hScrollBar->value;
 else
     d.x = 0;

 if( vScrollBar != 0 )
     d.y = vScrollBar->value;
 else
     d.y = 0;

 if ( (d.x - delta.x) != cursor.x || (d.y - delta.y) != cursor.y)
 {
   if (d.x - delta.x >= size.x)
   {
     delta.x = d.x - size.x + 1;
   }
   else if (d.x - delta.x < 0)
   {
     delta.x = d.x;
   }
   if (d.y - delta.y >= size.y)
   {
     delta.y = d.y - size.y + 1;
   }
   else if (d.y - delta.y < 0)
   {
     delta.y = d.y;
   }
   setCursor(d.x-delta.x,d.y-delta.y);
   if( drawLock != 0 )
       drawFlag = True;
   else
       drawView();
 }
}


TInfViewer::TInfViewer( const TRect& bounds, TScrollBar* aHScrollBar,
    TScrollBar* aVScrollBar, TInfFile *aInfFile, char *context,
    TInfIndicator *Ind, char *match )
    : TScroller( bounds, aHScrollBar, aVScrollBar )
{
 char NameCopy[MAX_NODE_NAME];

 // pumm!!! bug killed, fucking strings in code by GCC, i need a buffer not
 // a simple string (my fault).
 strcpy(NameCopy,context);

 options |= ofSelectable;
 growMode = gfGrowHiX | gfGrowHiY;
 hFile = aInfFile;
 topic = aInfFile->getTopic(NameCopy);
 topic->setWidth(size.x);
 setLimit(topic->maxWidth() + size.x, topic->numLines() + size.y);

 int LaPego;
 if ((selected=topic->selBestMatch(match,LaPego))!=0)
//    selected = 1;
// else
   {
    cursor.x=topic->crossRefs[selected-1].offset;
    int y=topic->crossRefs[selected-1].line-1;
    if (y>(size.y>>1))
      {
       delta.y=y-(size.y>>1);
       cursor.y=size.y>>1;
      }
    else
      {
       delta.y=y;
       cursor.y=1;
      }
    delta.x=0;
    scrollTo(cursor.x,y);
   }

 TextSelected = False;
 findStr[0]=0;
 findType=0;
 findWhere=fitInTopic;
 lastSearch=0;
 OpenVerbose=1;

 Indic=Ind;
 Indic->setValue( hFile->NameOfFile, topic->Node );

 // History
 HistPoint=0;
 History= new TCollectionNoSort(10,10);
 stHisto *h = new stHisto;
 strcpy(h->Name,"(");
 strcat(h->Name,hFile->NameOfFile);
 strcat(h->Name,")");
 strcat(h->Name,context);
 h->HisPos=cursor+delta;
 h->HisSel=selected;
 History->insert((void *)h);

 state |= sfCursorVis;

 if (LaPego)
   {
    switchToTopic(topic->crossRefs[selected-1].Name);
    cursor.x=delta.x=cursor.y=delta.y=0;
   }
}

TInfViewer::~TInfViewer()
{
 delete hFile;
 delete topic;
 delete History;
}

void TInfViewer::changeBounds( const TRect& bounds )
{
 TScroller::changeBounds(bounds);
 topic->setWidth(size.x);
 setLimit(topic->maxWidth() + size.x, topic->numLines() + size.y);
}

void TInfViewer::draw()
{
 TDrawBuffer b;
 char linea[256],*line;
 char buffer[256];
 char *bufPtr;
 unsigned char aux;
 int i, j, l;
 int keyCount;
 ushort normal, keyword, selKeyword, c,selWord = 0;
 TPoint keyPoint;
 uchar keyLength;
 char *keyRef;
 int NumCrossRefs=topic->getNumCrossRefs();
 int LineaReal;
 int Exceso;

 normal = getColor(1);
 keyword = getColor(2);
 selKeyword = getColor(3);
 if (TextSelected)
    selWord = getColor(4);
 keyCount = 0;
 keyPoint.x = 0;
 keyPoint.y = 0;
 topic->setWidth(size.x);

 // Saltear las crossrefs que estn antes en la pantalla
 if (NumCrossRefs > 0)
     {
      do
       {
        topic->getCrossRef(keyCount++, keyPoint, keyLength, keyRef, Exceso);
       }
      while ( (keyCount <= NumCrossRefs) && (keyPoint.y <= delta.y));
     }

 for (i = 1, LineaReal=delta.y+1; i <= size.y; ++i,LineaReal++)
     {
     strcpy(linea, topic->getLine(LineaReal)); // Pedir la lnea
     if (linea[0]==30)
       {
        aux=(unsigned char)linea[1];
        if (aux<='9')
           c=(aux-'0')<<4;
        else
           c=(aux-(unsigned char)'A'+10)<<4;
        aux=(unsigned char)linea[2];
        if (aux<='9')
           c+=aux-'0';
        else
           c+=aux-(unsigned char)'A'+10;
        line=linea+3;
       }
     else
       {
        c=normal;
        line=linea;
       }
     b.moveChar(0, ' ', c, size.x); // Attr pedido
       
     if ((int)strlen(line) > delta.x)
         {
         bufPtr = line + delta.x;
         strncpy(buffer, bufPtr, size.x);
         buffer[size.x] = 0;
         b.moveStr(0, buffer, c);
         }
     else
         b.moveStr(0, "", c);
         
     while (LineaReal == keyPoint.y)
         {
         if (Exceso>0)
            l = keyLength-Exceso;
         else
            l = keyLength;
         if (keyPoint.x < delta.x )
           {
            l -= (delta.x - keyPoint.x);
            keyPoint.x = delta.x;
           }
         if (keyCount == selected)
            c = selKeyword;
         else
            c = keyword;
         for (j = 0; j < l; ++j)
             b.putAttribute((keyPoint.x - delta.x + j),c);
         if (Exceso>0)
           {
            keyPoint.x=0;
            keyPoint.y++;
            keyLength=Exceso+1;
            Exceso=0;
           }
         else
           {
            ++keyCount;
            if (keyCount <= NumCrossRefs)
                topic->getCrossRef(keyCount-1, keyPoint, keyLength, keyRef, Exceso);
            else
                keyPoint.y = 0;
           }
         }
     if (TextSelected && (LineaReal>=LineStartSelect && LineaReal<=LineEndSelect))
       {
        int start;
        l = ColEndSelect-ColStartSelect;
        if ( ColStartSelect<delta.x )
          {
           l -= (delta.x - ColStartSelect);
           start = 0;
          }
        else
           start = ColStartSelect - delta.x;
        for(j = 0; j < l; ++j)
            b.putAttribute(start + j,selWord);
       }
     writeLine(0, i-1, size.x, 1, b);
     }
}

TPalette& TInfViewer::getPalette() const
{
    static TPalette palette(cInfViewer, sizeof( cInfViewer)-1);
    return palette;
}

void TInfViewer::makeSelectVisible()
{
 int ProxLine;
 TPoint keyPoint;
 uchar keyLength;
 char *keyRef;

 topic->getCrossRef(selected-1, keyPoint, keyLength, keyRef, ProxLine);
 makeVisible(keyPoint,keyLength);
}


void TInfViewer::makeVisible( TPoint& keyPoint, int largo )
{
 if ((keyPoint.x+largo)>(delta.x+size.x) && (size.x>=largo))
    scrollTo(keyPoint.x+largo,keyPoint.y-1);
 else
    scrollTo(keyPoint.x,keyPoint.y-1);
}

void TInfViewer::switchToTopic( char *keyRef, TPoint Pos )
{
 char NameCopy[MAX_NODE_NAME];

 // Because i can destroy the original bellow, keyRef is from topic and i go
 // to detroy it.
 strcpy(NameCopy,keyRef);

 if (topic != 0)
     delete topic;
 topic = hFile->getTopic(NameCopy,OpenVerbose);

 Indic->setValue( hFile->NameOfFile, topic->Node );

 topic->setWidth(size.x);
 setLimit(topic->maxWidth() + size.x, topic->numLines() + size.y);
 scrollTo(Pos.x,Pos.y);
 drawView();
 // No search
 TextSelected=False;
 lastSearch=topic->Text;
}

void TInfViewer::switchToTopic( char *keyRef )
{
 TPoint Pos;

 AddToHistory(keyRef);
 Pos.x=0; Pos.y=0;
 selected = 0;
 switchToTopic( keyRef,Pos );
}

void TInfViewer::switchToTopic( stHisto *h )
{
 AddToHistory(h->Name);
 selected=h->HisSel;
 switchToTopic(h->Name,h->HisPos);
}

static void AddFileToNode(char *dest, char *source, char *file)
{
 if (source[0]=='(')
    strcpy(dest,source);
 else
   {
    dest[0]='(';dest[1]=0;
    strcat(dest,file);
    strcat(dest,")");
    strcat(dest,source);
   }
}

void TInfViewer::AddToHistory(char *context)
{
 stHisto *h = (stHisto *)History->at(HistPoint);

 h->HisPos = cursor + delta;
 h->HisSel=selected;

 h = new stHisto;

 AddFileToNode(h->Name,context,hFile->NameOfFile);

 History->insert(h);
 HistPoint++;

 if (HistPoint>=MAX_HIST_DEEP)
   {
    History->atRemove(0);
    HistPoint--;
   }
}

char *TInfViewer::TakeFromHistory(TPoint& Pos)
{
 stHisto *h;
 if (HistPoint>0)
   {
    History->atRemove(HistPoint--);
    h=(stHisto *)History->at(HistPoint);
   }
 else
    h=(stHisto *)History->at(0);

 selected=h->HisSel;
 Pos = h->HisPos;
 return h->Name;
}


void TInfViewer::handleEvent( TEvent& event )
{
 TPoint mouse;

 TScroller::handleEvent(event);
 switch (event.what)
     {
     case evCommand:
          switch (event.message.command)
             {
              case cmInfHelp:
                   switchToTopic("(infview)");
                   break;

              case cmInfControl:
                   {
                    int Comando =
                           execDialog( new THelpControlDialog(History), NULL );
                    if (Comando>=chcdHistSel)
                      {
                       switchToTopic((stHisto *)History->at(Comando-chcdHistSel));
                      }
                    else
                       switch (Comando)
                         {
                          case chcdNext: switchToTopic(topic->Next);
                                         break;
                          case chcdPrev: switchToTopic(topic->Prev);
                                         break;
                          case chcdUp:   switchToTopic(topic->Up);
                                         break;
                          case chcdPrevH: {
                                           TPoint Pos;
                                           char *contexto=TakeFromHistory(Pos);
                                           switchToTopic(contexto,Pos);
                                          }
                                          break;
                         }
                   }
                   break;

              case cmInfBack:
                   {
                    TPoint Pos;
                    char *contexto=TakeFromHistory(Pos);
                    switchToTopic(contexto,Pos);
                   }
                   break;

              default:
                   return;
             }
          break;

     case evKeyDown:
         switch (event.keyDown.keyCode)
             {
             case kbTab:
                  if (PointInCrossRef(cursor+delta,topic,selected) >= 0)
                     selected++;
                  selected++;
                  if (selected > topic->getNumCrossRefs())
                      selected = 1;
                  if ( topic->getNumCrossRefs() != 0 )
                      makeSelectVisible();
                  break;

             case kbShiftTab:
                  PointInCrossRef(cursor+delta,topic,selected);
                  if (selected == 0)
                      selected = topic->getNumCrossRefs();
                  if ( topic->getNumCrossRefs() != 0 )
                      makeSelectVisible();
                  break;

             case kbEnter:
                  if (selected > 0)
                  if (selected <= topic->getNumCrossRefs())
                     switchToTopic(topic->getCrossRef(selected-1));
                  break;

             case kbEsc:
                  if (owner->state & sfModal)
                     endModal(cmCancel);
                  else
                    {
                     event.what = evCommand;
                     event.message.command = cmClose;
                     putEvent(event);
                    }
                 break;

             default:
                 int Key=toupper(event.keyDown.charScan.charCode);
                 if (Key>='A' && Key<='Z')
                   {
                    if (topic->SearchNextWith(Key,selected))
                       makeSelectVisible();
                   }
                 else if (Key>='1' && Key<='9')
                   {
                    Key-='1';
                    if (Key<topic->numRefs)
                       switchToTopic(topic->crossRefs[Key].Name);
                    else
                       return;
                   }
                 else
                   {
                    switch (Key)
                      {
                       case kbCtrlL:
                            makeSearch();
                            break;

                       case kbCtrlS:
                            find();
                            break;

                       case kbCtrlN:
                            switchToTopic(topic->Next);
                            break;

                       case kbCtrlP:
                            switchToTopic(topic->Prev);
                            break;

                       case kbCtrlU:
                            switchToTopic(topic->Up);
                            break;

                       case kbCtrlD:
                            switchToTopic("(dir)");
                            break;

                       case kbCtrlT:
                            switchToTopic("Top");
                            break;

                       case '0':
                            switchToTopic(topic->crossRefs[topic->numRefs-1].Name);
                            break;

                       case kbCtrlG:
                            {
                             TFindInfDialogRec findRec( findStr, findType, findWhere );

                             if ( execDialog( createGoToDialog(), &findRec ) != cmCancel )
                                switchToTopic(findRec.find);
                            }
                            break;
                            
                       case kbCtrlH:
                            switchToTopic("(infview)");
                            break;

                       default:
                            return;
                      }
                   }
             }
         drawView();
         clearEvent(event);
         break;

     case evMouseDown:
          mouse = makeLocal(event.mouse.where);
          mouse += delta;
          scrollTo(mouse.x,mouse.y);
          if (event.mouse.doubleClick && selected > 0)
            {
             switchToTopic(topic->getCrossRef(selected-1));
            }
          clearEvent(event);
          break;
     }
}


int StrNCmp(const char *s1, const char *s2, size_t n)
{

  if (n == 0) return 0;
  do
   {
    if (toupper(*s1) != *s2++) return 1;
    if (*s1++ == 0)
      break;
   }
  while (--n != 0);
  return 0;
}


char *ScanStr(char *s, char *find, int &Linea, int &Col)
{
  char c, sc;
  size_t len;
  char Buf[256];

  strcpy(Buf,find);
  strupr(Buf);
  find=Buf;

  if ((c = *find++) != 0)
  {
    len = strlen(find);
    do
      {
      do
        {
	 if ((sc = *s++) == 0) return 0;
         if (sc=='\n')
           {
            Col=0;
            Linea++;
           }
         else
            Col++;
        }
      while (toupper(sc) != c);
      }
    while (StrNCmp(s, find, len) != 0);
    s--;
  }
  Col--;
  return s;
}

char *ScanStrCase(char *s, char *find, int &Linea, int &Col)
{
  char c, sc;
  size_t len;

  if ((c = *find++) != 0)
  {
    len = strlen(find);
    do
      {
      do
        {
	 if ((sc = *s++) == 0) return 0;
         if (sc=='\n')
           {
            Col=0;
            Linea++;
           }
         else
            Col++;
        }
      while (sc != c);
      }
    while (strncmp(s, find, len) != 0);
    s--;
  }
  Col--;
  return s;
}



TDialog *createFindDialog();
TDialog *createInfFindDialog();

int TInfViewer::searchInCurrentTopic(int Linea,int Col,int largo)
{
 TPoint Punto;

 do
  {
   lastSearch=findType & fitCaseSens ?
              ScanStrCase(lastSearch,findStr,Linea,Col) :
              ScanStr(lastSearch,findStr,Linea,Col);
   if (lastSearch!=0) // hit and
     {
      if ( !(findType & fitWWord) ||  // (!Whole word or
         // is a whole word)
         (!isalpha(*(lastSearch-1)) && !isalpha(*(lastSearch+largo))) )
        {
         LineEndSelect=LineStartSelect=Linea+1;
         ColStartSelect=Col;
         ColEndSelect=Col+largo;
         Punto.x=Col;
         Punto.y=Linea+1;
         makeVisible(Punto,largo);
         TextSelected=True;
         lastSearch+=largo;
         return 1;
        }
      lastSearch+=largo;
      Col+=largo;
     }
  }
 while (lastSearch);

 return 0;
}


int TInfViewer::searchInCurrentFile(int Linea,int Col,int largo)
{
 char Buf[256];
 char findUp[256];
 FILE *f;

 // first in the current topic
 if (TopicInSearch!=fitNotInTopic && searchInCurrentTopic(Linea,Col,largo))
    return 1;
 // now across topics
 long PosTopic;
 strcpy(findUp,findStr);
 strupr(findUp);
 char *s;
 int LastTopic=TopicInSearch;
 while ((PosTopic=hFile->index->position(++TopicInSearch))!=-1)
   {
    hFile->fSeek(PosTopic);
    topic->ReadNodeInfo(*hFile);
    if (topic->Status)
      {
       switchToTopic("Top");
       break;
      }
    f=hFile->stream;
    do
     {
      if (fgets(Buf,256,f)==NULL) break;
      strupr(Buf);
      s=strstr(Buf,findUp);
     }
    while (s==NULL && Buf[0]!=31);

    if (Buf[0]!=31 && !feof(f))
      {
       switchToTopic(hFile->index->Names[TopicInSearch]);

       lastSearch=topic->Text;
       if (searchInCurrentTopic(0,0,largo))
          return 1;
      }
   };
 if (LastTopic!=fitNotInTopic)
    switchToTopic(hFile->index->Names[LastTopic]);
 return 0;
}

void TInfViewer::makeSearch()
{
 int Linea,Col;
 int largo,Eureka=0;

 largo=strlen(findStr);
 if (largo==0) return;

 // Si finaliz una bsqueda antes y ahora presion Ctrl+L que vuelva al ppio.
 if (lastSearch==NULL)
    lastSearch=topic->Text;

 if (lastSearch!=topic->Text)
   {
    Linea=LineEndSelect-1;
    Col=ColEndSelect;
   }
 else
   {
    Linea=0;
    Col=0;
   }

 OpenVerbose=0;
 switch (findWhere)
  {
   case fitInTopic:
        // Search in the current topic, is only in a large buffer
        Eureka=searchInCurrentTopic(Linea,Col,largo);
        break;

   case fitInFile:
        // It's complex; and calls searchInCurrentTopic
        Eureka=searchInCurrentFile(Linea,Col,largo);
        break;

   case fitInDir:
        // It's Waco, and infected (i kill thousands of bugs here).
        if (FileInSearch==fitNotInTopic)
          { // It's the first time
           // Keep track were start
           AddFileToNode(OriginalPlace.Name,topic->Node,hFile->NameOfFile);
           OriginalPlace.HisPos = cursor + delta;
           OriginalPlace.HisSel=selected;
          }
        else
          { // Not the first time, continue in this file
           if (searchInCurrentFile(Linea,Col,largo))
             {
              OpenVerbose=1;
              return;
             }
          }
        // now across files
        // Go to Top of Top
        switchToTopic("(dir)Top");
        while ((++FileInSearch)<topic->numRefs)
          {
           switchToTopic(topic->crossRefs[FileInSearch].Name);
           if (!hFile->Status)
             {
              TopicInSearch=fitNotInTopic;
              if (searchInCurrentFile(Linea,Col,largo))
                {
                 OpenVerbose=1;
                 return;
                }
             }
           switchToTopic("(dir)Top");
          }
        switchToTopic(&OriginalPlace);
        break;
  }
 if (!Eureka)
    messageBox("Sorry can't find the string",mfError | mfOKButton);
 OpenVerbose=1;
}


void TInfViewer::find()
{
 TFindInfDialogRec findRec( findStr, findType, findWhere );
 lastSearch=topic->Text;
 FileInSearch=TopicInSearch=fitNotInTopic;
 if ( execDialog( createInfFindDialog(), &findRec ) != cmCancel )
   {
    strcpy( findStr, findRec.find );
    findType = findRec.options;
    findWhere =  findRec.ops2;
    makeSearch();
   }
}


/***************************************************************

 class TInfWindow

 Just like THelpWindow.

***************************************************************/

TInfWindow::TInfWindow( TInfFile *hFile, char *context, char *match):
       TWindow( TRect(0,0,50,18), "InfView", wnNoNumber ),
       TWindowInit( &TInfWindow::initFrame)
{
 TRect r(0, 0, 50, 18);
 options = (options | ofCentered);
 r.grow(-1,-1);

 TInfIndicator *Indic = new TInfIndicator(TRect(6,0,45,1));
 insert(Indic);
 insert(new TInfViewer (r,
   standardScrollBar(sbHorizontal | sbHandleKeyboard),
   standardScrollBar(sbVertical | sbHandleKeyboard), hFile, context,
   Indic, match));
 helpCtx = hcInfView;
}

TPalette& TInfWindow::getPalette() const
{
    static TPalette palette(cInfWindow, sizeof( cInfWindow)-1);
    return palette;
}



/***************************************************************

 class TStrListBox

 Una ListBox que responde a Enter y Doble click.
 A List Box with Enter+Double click response.

 La respuesta es un mensaje cmStrChoose y en infoPtr el ndice
seleccionado.

***************************************************************/

void TStrListBox::handleEvent(TEvent& event)
{
 short a=focused;
 if ( (event.what==evKeyDown && event.keyDown.keyCode==kbEnter)
    || (event.what == evMouseDown && event.mouse.doubleClick) )
   {
    message( owner, evBroadcast, cmStrChoose, (void *)&focused );
    clearEvent(event);
    return;
   }
 TListBox::handleEvent(event);
 if (focused!=a)
    draw();
}

/***************************************************************

 class THelpControlDialog

 Una caja de dilogo para controlar el help.
 A Dialog to control the help.

***************************************************************/

void THelpControlDialog::handleEvent(TEvent& event)
{
 TDialog::handleEvent(event);
 if( event.what == evCommand || event.what == evBroadcast)
  {
   //ushort comm=event.message.command;
   switch( event.message.command )
           {
            // a button
            case chcdNext:
            case chcdPrev:
            case chcdUp:
            case chcdPrevH:
            case chcdHide:
                {
                endModal(event.message.command);
                clearEvent(event);
                }
                break;

            // from the list
            case cmStrChoose:
                {
                 endModal(chcdHistSel+*((ushort *)event.message.infoPtr));
                 clearEvent(event);
                }
                break;
            default:
                break;
           }
  }
}


THelpControlDialog::THelpControlDialog(TCollectionNoSort *oCol) :
    TDialog( TRect( 1, 1, 51, 15 ), "Help Control" ),
    TWindowInit( &THelpControlDialog::initFrame )
{
 TRect r(1,2,18,4);
 insert( new TButton(r,"~N~ext",100,bfDefault) );
 r.a.y+=2;
 r.b.y+=2;
 insert( new TButton(r,"~P~revious",101,bfNormal) );
 r.a.y+=2;
 r.b.y+=2;
 insert( new TButton(r,"~U~p",102,bfNormal) );
 r.a.y+=2;
 r.b.y+=2;
 insert( new TButton(r,"Prev. ~H~ist.",103,bfNormal) );
 r.a.y+=2;
 r.b.y+=2;
 insert( new TButton(r,"H~i~de",104,bfNormal) );

 TScrollBar *sb = new TScrollBar( TRect(47,3,48,12) );
 insert(sb);
 TStrListBox *ListaH = new TStrListBox( TRect(21,3,47,12),(ushort)1, sb );
 insert(ListaH);
 ListaH->newList(oCol);
 insert (new TLabel(TRect(21,2,47,3),"Hi~s~tory", ListaH));

 options|=ofTopSelect;
 selectNext( False );
}


TDialog *createInfFindDialog()
{
 TDialog *d = new TDialog( TRect( 0, 0, 38, 15 ), "Inf Find" );

 d->options |= ofCentered;

 TInputLine *control = new TInputLine( TRect( 3, 3, 32, 4 ), 80 );
 d->insert( control );
 d->insert(
     new TLabel( TRect( 2, 2, 15, 3 ), "~T~ext to find", control ) );
 d->insert(
     new THistory( TRect( 32, 3, 35, 4 ), control, 10 ) );

 d->insert( new TCheckBoxes( TRect( 3, 5, 35, 7 ),
     new TSItem( "~C~ase sensitive",
     new TSItem( "~W~hole words only", 0 ))));

 d->insert( new TRadioButtons( TRect( 3, 8, 35, 11 ),
     new TSItem( "In current ~t~opic",
     new TSItem( "In the ~f~ile",
     new TSItem( "In ~a~ll files", 0 )))));

 d->insert(
     new TButton( TRect( 14, 12, 24, 14 ), "O~K~", cmOK, bfDefault ) );
 d->insert(
     new TButton( TRect( 26, 12, 36, 14 ), "Cancel", cmCancel, bfNormal ) );

 d->selectNext( False );
 return d;
}

TDialog *createGoToDialog()
{
 TDialog *d = new TDialog( TRect( 0, 0, 38, 9 ), "Go To" );

 d->options |= ofCentered;

 TInputLine *control = new TInputLine( TRect( 3, 3, 32, 4 ), 80 );
 d->insert( control );
 d->insert(
     new TLabel( TRect( 2, 2, 15, 3 ), "~N~ame of Node", control ) );
 d->insert(
     new THistory( TRect( 32, 3, 35, 4 ), control, 10 ) );

 d->insert(
     new TButton( TRect( 14, 6, 24, 8 ), "O~K~", cmOK, bfDefault ) );
 d->insert(
     new TButton( TRect( 26, 6, 36, 8 ), "Cancel", cmCancel, bfNormal ) );

 d->selectNext( False );
 return d;
}

/***************************************************************************

 class TInfIndicator

 An status indicator

***************************************************************************/

#if !defined( __STRSTREA_H )
#include <strstrea.h>
#endif	// __STRSTREA_H

#define cpIndicator "\x02\x03"

TInfIndicator::TInfIndicator( const TRect& bounds ) :
    TView( bounds )
{
 growMode = gfGrowRel | gfGrowLoX | gfGrowHiX;
 Cont[0]=0;
}

void TInfIndicator::draw()
{
 uchar color, frame;
 TDrawBuffer b;

 //size.y=1;
 if( (state & sfDragging) == 0 )
     {
     color = getColor(1);
     frame = dragFrame;
     }
 else
     {
     color = getColor(2);
     frame = normalFrame;
     }

 b.moveChar( 0, frame, color, size.x );
 b.moveStr( 0, Cont, color);
 writeBuf(0, 0, size.x, 1, b);
}

TPalette& TInfIndicator::getPalette() const
{
    static TPalette palette( cpIndicator, sizeof( cpIndicator )-1 );
    return palette;
}

void TInfIndicator::setState( ushort aState, Boolean enable )
{
 TView::setState(aState, enable);
 if (aState == sfDragging)
    drawView();
}

void TInfIndicator::setValue( char *File, char *Node )
{
 int Ancho=size.x<infiLargo ? size.x : infiLargo;
 int l=strlen(Node);

 int lcont=sprintf(Cont,"InfView - File: %s - Node: ",File);
 int dif=Ancho-(l+lcont);

 if (dif<=0)
   {
    strncat(Cont,Node,l+dif-4);
    strcat(Cont,"...");
   }
 else
    strcat(Cont,Node);
 drawView();
}

const char near TInfIndicator::dragFrame = '\xCD';
const char near TInfIndicator::normalFrame = '\xC4';

#pragma warn .dsz

