/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#if ( __GNUC_MINOR__ < 7 )
#pragma interface
#endif

#ifndef __IDE_H__
#define __IDE_H__

#define MODE_INPUT ios::in
#define MODE_OUTPUT ios::out
#define MODE_TRUNCATE ios::trunc
#define MODE_NOCREATE ios::nocreate
#define MODE_BINARY ios::bin

#define PROJECT_EXT ".gpr"
#define DESKTOP_EXT ".gdt"

#define PROJECT_IDENT "__gcc_project-file__"

#define Options (*(Project.options))

#define MEMAVAIL
#define HEAPCHECK

#define AINSERT(s) \
do {\
  char *__tmp__;\
  string_dup(__tmp__,(s));\
  args.insert(__tmp__);\
} while (0)

class TSCollection;

/* module idemain.cc */
class IDE;
extern IDE *App;
extern int global_argc;
extern char **global_argv;
extern char *RHIDE_DIR;
extern char *RHIDE_NAME;
extern char *RHIDE_EXT;
extern int debug_dependencies;
extern int debug_commands;
extern int debug_tempfiles;
void Repaint();

/* module ideopt.cc */
class TDirList;
class TParamList;
class TDependency;

void InitOptions();
void EditDirList(TDirList *dirlist,const char *title);
ushort EditParamList(TParamList *paramlist,const char *title);
void AddArg(const char * option);

void OptimizationFlags();
void DebugFlags();
void WarningFlags();
void CFlags();
void CXXFlags();

void AddOptimizationFlags(TSCollection &);
void AddDebugFlags(TSCollection &);
void AddWarningFlags(TSCollection &);
void AddCFlags(TSCollection &);
void AddCXXFlags(TSCollection &);

void Libraries(void);
void AddLibraries(TSCollection &);
void LinkerOptions(void);
void CompilerOptions(void);
void AddLinkerOptions(TSCollection &);
void AddCompilerOptions(TSCollection &);
void AddLocalOptions(TSCollection &,TDependency *);
void Preferences();

void EditReserved();
void EditCFlags();
void EditCXXFlags();
void EditDebugFlags();
void EditWarnFlags();
void EditOptFlags();
void EditUserWords();

/* module idegcc.cc */
Boolean compile_dep(TDependency *);
Boolean compile_s_to_obj(const char * source_name,const char * dest_name);
Boolean compile_c_to_obj(const char * source_name,const char * dest_name);
Boolean Link(TDependency *);
Boolean Archive(TDependency *);
long TimeOfFile(const char *fname,Boolean do_update,Boolean is_full_name = False);
Boolean Make(Boolean force_messages = True);
Boolean Build(void);
Boolean RunMainTarget(void);
Boolean Compile(void);
int RunProgram(const char *ProgramName,TSCollection & args,
                   Boolean redir_stderr,Boolean redir_stdout,
		   Boolean hook21,Boolean SwitchToUser = False);
void AddProgArgs(TSCollection &);
void ClearFileHash();

/* module ideprj.cc */
class TProject;
class TProjectWindow;
class TListBox;
extern TProject *project;
#define Project (*project)
Boolean OpenProject(const char *);
void SaveProject();
void CloseProject();
void ShowProject(void);
void HideProjectWindow(void);
void AddProjectItem(void);
void DelProjectItem(void);
extern TProjectWindow *project_window;
extern char * project_name;
void WriteMake(void);
void LocalOptions();
void ShowIncludes();
Boolean PushProject(char *directory,char *prjname);
void PopProject();
void ResetProjectStack();
void ClearDependencies();
void MakeClear();

/* module ideio.cc */
char * open_stderr(void);
char * open_stdout(void);
void close_stderr(void);
void close_stdout(void);
extern char * cpp_outname;
extern char * cpp_errname;

/* module ideutil.cc */
Boolean FindFile(const char * name,TDirList * list,char * & full_name,Boolean uselist=True);
Boolean FindFile(const char * name,char * & full_name);
void ClearFindCache();
char *expand_variables(char *);
char *expand_variables(char **);

/* module idewind.cc */
class TWindow;
extern TSCollection *windows;
#define DESKTOPWINDOW(index) (((DeskTopWindow *)windows->at(index))->window)
void AddWindow(TWindow *,Boolean before = False);
void RemoveWindow(TWindow *);
void ShowWindowList(void);

/* module idemsg.cc */
class TMsgCollection;
class TDialog;
void ShowMessages(TMsgCollection *msgs,Boolean remove_old);
extern TDialog *msg_window;

/* module idedefault.cc */
void DefaultOptFlags();
void DefaultDebugFlags();
void DefaultWarnFlags();
void DefaultCXXFlags();
void DefaultCFlags();
void DefaultReservedWords();

/* module idecolors.cc */
void Colors();

/* module idehints.cc */
const char * IDEHint(unsigned short);

/*module ideformatline.cc */
class TEditor;
void SyntaxFormatLine(TEditor *,void *,uint32,int,ushort);

/* module ideresource.cc */
Boolean InitResource();
void CloseResource();
class TMenuBar;
class TRect;
TMenuBar *GetMenuBar(TRect);
class TStatusLine;
TStatusLine *GetStatusLine(TRect);
class TFlagCollection;
TFlagCollection * GetOptFlags();
TFlagCollection * GetWarnFlags();
TFlagCollection * GetDebugFlags();
TFlagCollection * GetCXXFlags();
TFlagCollection * GetCFlags();
class TStringCollection;
TStringCollection * GetReservedWords();
const char * GetHint(ushort);
class TColorDialog;
TColorDialog *GetColorDialog();

/* module IDEExtern.cc */
void FSDB();
void GREP();
void GDB();

/* module IDEHelp.cc */
class TIDEInfWindow;
extern TIDEInfWindow *InfWindow;
void Help();
void Help(ushort);
void HelpIndex();
void ContextHelp(ushort);
void SyntaxHelp(const char *,const char *fname = "libc.inf");

/* module IDEDebug.cc */
void Step();
void Trace();
void Goto();
void Reset();
void Continue();
extern int debugger_started;

#ifdef Uses_IDEConst
#include "IDEConst.h"
#endif

typedef struct {
  unsigned use_hook21:1;
  unsigned create_backup_files:1;
  unsigned show_syntax:1;
  unsigned save_before_compiling:1;
  unsigned autoindent:1;
  unsigned overwrite:1;
  unsigned show_stderr:1;
  unsigned show_stdout:1;
  unsigned show_doing:1;
  unsigned show_mem:1;
  unsigned no_stdinc:1;
  unsigned no_stdlib:1;
  unsigned for_profile:1;
  unsigned dummy:3;
} ide_options;

#define IDE_OPTIONS (*((ide_options*)&(Options.debug_level)))
#define UseHook21 (IDE_OPTIONS.use_hook21)
#define CreateBackupFiles (IDE_OPTIONS.create_backup_files)
#define ShowSyntax (IDE_OPTIONS.show_syntax)
#define SaveBeforeCompiling (IDE_OPTIONS.save_before_compiling)
#define AutoIndent (IDE_OPTIONS.autoindent)
#define OverWrite (IDE_OPTIONS.overwrite)
#define ShowStderr (IDE_OPTIONS.show_stderr)
#define ShowStdout (IDE_OPTIONS.show_stdout)
#define ReservedWords (Options.reserved)
#define UserWords (Options.user_words)
#define NoStdInc (IDE_OPTIONS.no_stdinc)
#define NoStdLib (IDE_OPTIONS.no_stdlib)
#define ForProfile (IDE_OPTIONS.for_profile)
#define ShowWhatDoing (IDE_OPTIONS.show_doing)
#define ShowMem (IDE_OPTIONS.show_mem)

#if defined( Uses_LangTexte ) && !defined( __LANGTEXT__ )
#include "IDELang.h"
const char * GetLangText(LangTextType);
#define GT GetLangText
#endif

#endif
