/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#if ( __GNUC_MINOR__ < 7 )
#pragma implementation "IDEApp.h"
#endif

#define Uses_TMenuBar
#define Uses_TStatusLine
#define Uses_TPalette
#define Uses_TEditWindow
#define Uses_TFileDialog
#define Uses_TEditorApp
#define Uses_LangTexte

#include <IDEClass.h>
#include "IDE.h"
#include "IDEApp.h"
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>

#define cpIDEColor\
    "\x71\x70\x78\x74\x20\x28\x24\x17\x1F\x1A\x31\x31\x1E\x71\x00"\
    "\x37\x3F\x3A\x13\x13\x3E\x21\x00\x07\x0F\x0F\x07\x0F\x07\x70\x00"\
    "\x70\x7F\x7A\x13\x13\x70\x70\x7F\x7E\x20\x2B\x2F\x78\x2E\x70\x30"\
    "\x3F\x3E\x1F\x2F\x1A\x20\x72\x31\x31\x30\x2F\x3E\x31\x13\x00\x00"\
    "\x1E\x71\x17\x1F\x1E\x1F\x1B\x1D\x1D\x1D\x1D\x1B\x1A\x40"\
    "\x3E\x23\x1E\x1E\x1E\x1E\x1E\x1E\x1E\x1E\x1E\x1E\x1E\x1E"\
    "\x70\x7F\x1E\x1E\x1E\x1E\x1E\x1E\x1E\x1E\x1E\x1E\x1E\x1E"

TPalette & IDE::getPalette() const
{
  static TPalette palette(cpIDEColor,sizeof(cpIDEColor)-1);
  return palette;
}

int global_argc = 0;
char **global_argv = NULL;
int debug_dependencies = 0;
int debug_commands = 0;
int debug_tempfiles = 0;

void IDE::idle()
{
}

void update_mem()
{
}

TEditWindow *IDE::openEditor( const char *fileName, Boolean visible )
{
    return (TEditWindow *)
       ((int)fileName-(int)fileName+(int)visible+(int)visible);
}

void IDE::update()
{
}

void IDE::getEvent(TEvent &event)
{
  TEditorApp::getEvent(event);
}

void TargetName()
{
}

void SaveScreen();

void RePaint()
{
}

void IDE::dosShell()
{
}

void IDE::handleEvent(TEvent & event)
{
  TEditorApp::handleEvent(event);
}

TMenuBar *IDE::initMenuBar( TRect r )
{
  r.a.x = 0;
  return (TMenuBar *)(r.a.x);
}

TStatusLine *IDE::initStatusLine( TRect r )
{
  r.a.x = 0;
  return (TStatusLine *)(r.a.x);
}

IDE *App;

extern char *resource_ext[LANGUAGES];

#define bufsize 16*1024
static char buffer[bufsize];

char *BASENAME = NULL;

int main(int argc,char *argv[])
{
  ushort lang_count = LANGUAGES;
  ushort default_lang = 0;
  uint32 start_pos = (LANGUAGES+1) * 8 + 4,count;
  uint32 i;
  int handle;
  FILE *f,*fi;
  char name[256];
  SaveScreen();
  global_argc = argc;
  global_argv = argv;
  if (argc > 2 && strcmp(argv[1],"-o") == 0)
  {
    string_dup(BASENAME,argv[2]);
  }
  else string_dup(BASENAME,"rhide");
  string_cat(BASENAME,".");
  InitResource();
  App = new IDE();
  CloseResource();
  strcpy(name,BASENAME);
  strcat(name,"dlg");
  f = fopen(name,"w+b");
  fwrite(&lang_count,sizeof(lang_count),1,f);
  fwrite(&default_lang,sizeof(default_lang),1,f);
  fwrite("all",4,1,f);
  fwrite(&start_pos,4,1,f);
  strcpy(name,BASENAME);
  strcat(name,"all");
  handle = open(name,O_RDONLY | O_BINARY);
  start_pos += filelength(handle);
  close(handle);
  for (i=0;i<LANGUAGES;i++)
  {
    fwrite(resource_ext[i],4,1,f);
    fwrite(&start_pos,4,1,f);
    strcpy(name,BASENAME);
    strcat(name,resource_ext[i]);
    handle = open(name,O_RDONLY | O_BINARY);
    start_pos += filelength(handle);
    close(handle);
  }
  strcpy(name,BASENAME);
  strcat(name,"all");
  fi = fopen(name,"rb");
  while ((count = fread(buffer,1,bufsize,fi)) > 0)
  {
    fwrite(buffer,1,count,f);
  }
  fclose(fi);
  remove(name);
  for (i=0;i<LANGUAGES;i++)
  {
    strcpy(name,BASENAME);
    strcat(name,resource_ext[i]);
    fi = fopen(name,"rb");
    while ((count = fread(buffer,1,bufsize,fi)) > 0)
    {
      fwrite(buffer,1,count,f);
    }
    fclose(fi);
    remove(name);
  }
  fclose(f);
  delete App;
  return 0;
}

void IDE::fileOpen()
{
}
