/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#define Uses_TWindow
#define Uses_TProgram
#define Uses_TDeskTop
#define Uses_TDialog
#define Uses_TListBox
#define Uses_TScrollBar
#define Uses_TKeys
#define Uses_TSCollection
#define Uses_TStringCollection
#define Uses_TWindowList
#define Uses_LangTexte
#define Uses_IDEConst
#include <IDEClass.h>
#include "IDE.h"
#include <stdlib.h>
#include <string.h>
#include <libc/dosio.h>
#include <stdio.h>

TSCollection *windows=NULL;

#define WHERE TProgram::deskTop

void AddWindow(TWindow *window,Boolean before)
{
  int numbers[9] = {0,0,0,0,0,0,0,0,0},n;
  int i,count;
  TEvent event;
  DeskTopWindow *window_rec;
  if (!windows) windows = new TSCollection();
  count = windows->getCount();
  for (i=0;i<count;i++)
  {
    n = DESKTOPWINDOW(i)->number;
    if (n>0 && n<10) numbers[n-1] = 1;
  }
  window->number = wnNoNumber;
  for (i=0;i<9;i++)
  {
    if (numbers[i] == 0)
    {
      window->number = i+1;
      break;
    }
  }
  window_rec = new DeskTopWindow;
  window_rec->window = window;
  window_rec->full_name = NULL;
  windows->insert(window_rec);
  if (before == True)
    WHERE->insertBefore(window, WHERE->last);
  else 
    WHERE->insert(window);
  event.what = evCommand;
  event.message.command = cmEditorAnswer;
  window->handleEvent(event);
  if (event.what == evNothing)
  {
    string_dup(window_rec->full_name,window->getTitle(100));
    FExpand(window_rec->full_name);
    TimeOfFile(window_rec->full_name,True);
  }
}

void RemoveWindow(TWindow *window)
{
  int i,count;
  if (!windows) return;
  count = windows->getCount();
  for (i=0;i<count;i++)
  {
    DeskTopWindow *w = (DeskTopWindow *)windows->at(i);
    if (w->window == window)
    {
      windows->atRemove(i);
      string_free(w->full_name);
      delete w;
      return;
    }   
  }
}

void ShowWindowList()
{
  TDialog *dialog;
  TWindowList *list;
  TScrollBar *scrollbar;
  int i;
  TWindow *window;
  dialog = new TDialog(TRect(0,0,75,16),GT(TitleWindowList));
  dialog->options |= ofCentered;
  scrollbar = new TScrollBar(TRect(72,1,73,14));
  list = new TWindowList(TRect(1,1,72,14),1,scrollbar);
  list->newList(windows);
  dialog->insert(list);
  dialog->insert(scrollbar);
  do
  {
    TProgram::deskTop->insert(dialog);
    dialog->setState(sfModal,True);
    i = dialog->execute();
    TProgram::deskTop->remove(dialog);
    switch (i)
    {
      case cmSelectWindow:
        window = DESKTOPWINDOW(list->focused);
        window->select();
        i = cmCancel;
        break;
      case cmDeleteWindow:
      {
        TEvent event;
        window = DESKTOPWINDOW(list->focused);
        window->select();
        event.what = evCommand;
        event.message.command = cmClose;
        event.message.infoPtr = NULL;
        TProgram::application->handleEvent(event);
        list->newList(windows);
        break;
      }
      default:
        i = cmCancel;
    }
  } while (i != cmCancel);
  delete dialog;
}
