/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#define Uses_TResourceFile
#define Uses_TStreamable
#define Uses_fpstream

#define Uses_TRect
#define Uses_TKeys
#define Uses_RawKeys
#define Uses_IDEConst

#define Uses_THintStatusLine
#define Uses_TStatusDef
#define Uses_TStatusItem

#define Uses_TMenuBar
#define Uses_TSubMenu

#define Uses_TFlagCollection
#define Uses_TFlagEntry

#define Uses_TEditor
#define Uses_TProject
#define Uses_TOptions
#define Uses_TStringCollection
#define Uses_IDEConst
#define Uses_TStreamableClass

#define Uses_TColorDialog
#define Uses_TColorGroup
#define Uses_TColorItem
#define Uses_TPalette
#define Uses_TSCollection
#define Uses_TResourceCollection
#define Uses_TColorDisplay
#define Uses_TColorSelector
#define Uses_TMonoSelector
#define Uses_TLabel
#define Uses_TButton
#define Uses_TColorItemList
#define Uses_TColorGroupList

#define Uses_TProgram
#define Uses_TVEdConstant

#define Uses_TDirListBox
#define Uses_TEditWindow
#define Uses_TFileList
#define Uses_MsgBox
#define Uses_TChDirDialog
#define Uses_TFileDialog
#define Uses_TFileInfoPane
#define Uses_LangTexte

#include <IDEClass.h>
#include "IDE.h"
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>

__link ( RMenuBar )
__link ( RHintStatusLine )
__link ( RResourceCollection )
__link ( RSCollection )
__link ( RColorDialog )

#ifndef ORIG_NAMES

  #define N(w,n)\
    const char * const w::name = #n;
  N(TMonoSelector,\xFE)
  N(TSCollection,\xFD)
  N(TResourceCollection,\xFC)
  N(THintStatusLine,\xFB)
  N(TMenuBar,\xFA)
  N(TColorDialog,\xF9)
  N(TColorItemList,\xF8)
  N(TColorGroupList,\xF7)
  N(TColorDisplay,\xF6)
  N(TButton,\xF5)
  N(TLabel,\xF4)
  N(TColorSelector,\xF3)

#endif

static TResourceFile *resource = NULL;
static TResourceFile *common_dlg = NULL;
char *lang_ext = NULL;

static void * GetResource(const char *key,int common = 0)
{
  if (common) return common_dlg->get(key);
  else return resource->get(key);
}

void SaveScreen();

static ushort default_lang,default_lang_new;
static char *dlg_name = NULL;

static Boolean OpenResource()
{
  fpstream *ifp;
  char lang[4];
  uint32 common_pos,pos;
  ushort lang_count;
  int handle,handle1;
  handle = -1;
  if (getenv("RHIDEDLG") != NULL)
  {
    string_dup(dlg_name,getenv("RHIDEDLG"));
    handle = open(dlg_name,O_RDONLY | O_BINARY);
    if (handle <= 0) string_free(dlg_name);
  }
  if (handle <= 0)
  {
    string_dup(dlg_name,RHIDE_DIR);
    string_cat(dlg_name,RHIDE_NAME);
    string_cat(dlg_name,".dlg");
    handle = open(dlg_name,O_RDONLY | O_BINARY);
  }
  if (handle <= 0)
  {
    string_free(dlg_name);
    string_dup(dlg_name,RHIDE_DIR);
    string_cat(dlg_name,"rhide.dlg");
    handle = open(dlg_name,O_RDONLY | O_BINARY);
    if (handle <= 0)
    {
      string_free(dlg_name);
      if (getenv("DJDIR") == NULL)
      {
        return False;
      }
      string_dup(dlg_name,getenv("DJDIR"));
      string_cat(dlg_name,"/bin/rhide.dlg");
      handle = open(dlg_name,O_RDONLY | O_BINARY);
      if (handle <= 0)
      {
        string_free(dlg_name);
        return False;
      }
    }
  }
  handle1 = open(dlg_name,O_RDONLY | O_BINARY);
  ifp = new fpstream(handle1);
  *ifp >> lang_count >> default_lang;
  default_lang_new = default_lang;
  ifp->readBytes(lang,4);
  *ifp >> common_pos;
  ifp->seekg(common_pos,ios::beg); 
  common_dlg = new TResourceFile(ifp);
  ifp->seekg(12,ios::beg);
  if (!lang_ext && getenv("RHIDELANG") != NULL)
    string_dup(lang_ext,getenv("RHIDELANG"));
  if (lang_ext)
  {
    int found = 0;
    default_lang_new = 0;
    while (lang_count--)
    {
      ifp->readBytes(lang,4);
      *ifp >> pos;
      if (stricmp(lang,lang_ext) == 0)
      {
        found = 1;
        break;
      }
      default_lang_new++;
    }
    if (!found)
    {
      fprintf(stderr,"%s: language (%s) is not supported\n",RHIDE_NAME,lang_ext);
      default_lang_new = default_lang;
      ifp->seekg(12+default_lang*8);
      ifp->readBytes(lang,4);
      fprintf(stderr," using [%s] as default\n",lang);
      SaveScreen();
      string_free(lang_ext);
    }
  }
  ifp->seekg(16+default_lang_new*8,ios::beg);
  *ifp >> pos;
  ifp = new fpstream(handle);
  ifp->seekg(pos,ios::beg);
  resource = new TResourceFile(ifp);
  return True;
}

void CloseResource()
{
  delete resource;
  delete common_dlg;
  if (default_lang != default_lang_new)
  {
    int handle = open(dlg_name,O_RDWR | O_BINARY);
    if (handle > 0)
    {
      lseek(handle,2,SEEK_SET);
      write(handle,&default_lang_new,sizeof(default_lang_new));
      close(handle);
    }
    else
    {
      fprintf(stderr,"Could not update the default language in %s\n",dlg_name);
    }
  }
  string_free(dlg_name);
}

static void GetStaticTexte();

Boolean InitResource()
{
  if (OpenResource() == False) return False;
  GetStaticTexte();
  return True;
}

TStatusLine * GetStatusLine(TRect r)
{
  TStatusLine *line;
  line = (THintStatusLine *)GetResource("StatusLine");
  r.a.y = r.b.y - 1;
  line->locate(r);
  ((THintStatusLine *)line)->HintFunction = IDEHint;
  return line;
}

TMenuBar *GetMenuBar(TRect r)
{
  TMenuBar *bar;
  bar = (TMenuBar *)GetResource("MenuBar");
  r.b.y = r.a.y + 1;
  bar->locate(r);
  return bar;
}

#define df(name) return (TFlagCollection *)GetResource(name,1)

TFlagCollection * GetOptFlags()
{
  df("OptFlags");
}

TFlagCollection * GetDebugFlags()
{
  df("DebugFlags");
}

TFlagCollection * GetWarnFlags()
{
  df("WarnFlags");
}

TFlagCollection * GetCXXFlags()
{
  df("CXXFlags");
}

TFlagCollection * GetCFlags()
{
  df("CFlags");
}

TStringCollection *GetReservedWords()
{
  return (TStringCollection *)GetResource("ReservedWords",1);
}

class TString : public TStreamable
{
public:
  char *string;
  TString(const char *s) : string(newStr(s)) {};
  TString() : string(NULL) {};
  static TStreamable * build() { return new TString(); }
  virtual ~TString() { if (string) delete string; }
  static const char * const name = "\xFF";
protected:
  virtual const char * const streamableName() const { return name;}
  virtual void write(opstream & os) { os.writeString(string); }
  virtual void * read(ipstream & is) { string = is.readString(); return this;}
};

s(String)

static TString *HINT = NULL;

static const char * KeyString(const char *prefix,ushort key)
{
  static char buffer[20];
  sprintf(buffer,"%s%04X",prefix,key);
  return buffer;
} 

const char * GetHint(ushort ctx)
{
  if (HINT) delete HINT;
  HINT = (TString *)GetResource(KeyString("",ctx));
  if (!HINT) return "";
  return HINT->string;
}

TColorDialog * GetColorDialog()
{
  TColorDialog *c;
  c = (TColorDialog *)GetResource("ColorDialog");
  c->pal = &TProgram::application->getPalette();
  return c;
}

#define L(x,lang...) _##x,
typedef enum {
#include "Lang.h"
  LastStaticText
};
#undef L

#if !defined( MAX_LANG_TEXT )
  #define MAX_LANG_TEXT 40
#endif
#define L(x,lang...) new char[MAX_LANG_TEXT],

static char * STATICTEXTE[((int)LastStaticText)+1] = {
  #include "Lang.h"
  NULL
};
#undef L

#define L(x,lang...) const char * x = STATICTEXTE[_##x];
  #include "Lang.h"
#undef L

static void GetStaticTexte()
{
  int i;
  TString *s;
  for (i=0;i<(int)LastStaticText;i++)
  {
    s = (TString *)GetResource(KeyString("S",(ushort)i));
    strcpy(STATICTEXTE[i],s->string);
    delete s;
  }
}

const char * TMonoSelector::normal = TL_1;
const char * TMonoSelector::highlight = TL_2;
const char * TMonoSelector::underline = TL_3;
const char * TMonoSelector::inverse = TL_4;

const char * TColorDialog::colors = TL_5;
const char * TColorDialog::groupText = TL_6;
const char * TColorDialog::itemText = TL_7;
const char * TColorDialog::forText = TL_8;
const char * TColorDialog::bakText = TL_9;
const char * TColorDialog::textText = TL_10;
const char * TColorDialog::colorText = TL_11;
const char * TColorDialog::okText = TL_12;
const char * TColorDialog::cancelText = TL_13;

const char * TDirListBox::drives = TL_14;
const char * TEditWindow::clipboardTitle = TL_15;
const char * TEditWindow::untitled = TL_16;

const char * TFileList::tooManyFiles = TL_17;

const char * TProgram::exitText = TL_18;

const char * MsgBoxText::yesText = TL_19;
const char * MsgBoxText::noText = TL_20;
const char * MsgBoxText::okText = TL_21;
const char * MsgBoxText::cancelText = TL_22;
const char * MsgBoxText::warningText = TL_23;
const char * MsgBoxText::errorText = TL_24;
const char * MsgBoxText::informationText = TL_25;
const char * MsgBoxText::confirmText = TL_26;

const char * TChDirDialog::changeDirTitle = TL_27;
const char * TChDirDialog::dirNameText = TL_28;
const char * TChDirDialog::dirTreeText = TL_29;
const char * TChDirDialog::okText = TL_30;
const char * TChDirDialog::chdirText = TL_31;
const char * TChDirDialog::revertText = TL_32;
const char * TChDirDialog::helpText = TL_33;
const char * TChDirDialog::drivesText = TL_34;
const char * TChDirDialog::invalidText = TL_35;

const char * TFileDialog::filesText = TL_36;
const char * TFileDialog::openText = TL_37;
const char * TFileDialog::okText = TL_38;
const char * TFileDialog::replaceText = TL_39;
const char * TFileDialog::clearText = TL_40;
const char * TFileDialog::cancelText = TL_41;
const char * TFileDialog::helpText = TL_42;
const char * TFileDialog::invalidDriveText = TL_43;
const char * TFileDialog::invalidFileText = TL_44;

const char * const TFileInfoPane::months[] =
    {
      TL_45,
      TL_46,
      TL_47,
      TL_48,
      TL_49,
      TL_50,
      TL_51,
      TL_52,
      TL_53,
      TL_54,
      TL_55,
      TL_56,
      TL_57
    };



static TString *langstring = NULL;
#define LCOUNT 20
static char * LANGSTRINGS[LCOUNT];
static int firstlang = 1;
static int langindex = 0;

const char * GetLangText(LangTextType what)
{
  if (firstlang)
  {
    int i;
    for (i=0;i<LCOUNT;i++) LANGSTRINGS[i] = NULL;
    langindex = 0;
  }
  else
  {
    langindex++;
    if (langindex >= LCOUNT) langindex = 0;
    if (LANGSTRINGS[langindex]) string_free(LANGSTRINGS[langindex]);
  }
  if (langstring) delete langstring;
  langstring = (TString *)GetResource(KeyString("T",what));
  if (!langstring) string_dup(LANGSTRINGS[langindex],"");
  else string_dup(LANGSTRINGS[langindex],langstring->string);
  return LANGSTRINGS[langindex];
}

