/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#if (__GNUC_MINOR__ < 7)
#pragma interface
#endif
#if defined( Uses_TFlagCollection ) && !defined( __TFlagCollection__ )
#define __TFlagCollection__

class TFlagCollection : public TCollection
{
public:
  TFlagCollection() : TCollection(10,10) {}
  static const char * const name;
  static TStreamable * build();
private:
  virtual const char * streamableName() const { return name; }
  virtual void * readItem(ipstream &);
  virtual void writeItem(void *,opstream &);
protected:
  TFlagCollection(StreamableInit) : TCollection(streamableInit) {}
};

inline ipstream& operator >> ( ipstream& is, TFlagCollection& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TFlagCollection*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TFlagCollection& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TFlagCollection* cl )
    { return os << (TStreamable *)cl; }

#endif
