/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#if (__GNUC_MINOR__ < 7)
#pragma interface
#endif
#if defined( Uses_TDirList ) && !defined( __TDirList__ )
#define __TDirList__

class TDirList : public TCollection
{
public:
  TDirList(void) : TCollection(10,1) {}
  TDirList(const char *);
  void FromString(const char *);
  void ToString(char * &);
private:
    virtual const char *streamableName() const
	{ return name; }
    virtual void *readItem( ipstream& );
    virtual void writeItem( void *, opstream& );
protected:
    TDirList( StreamableInit ) : TCollection(streamableInit) {}
public:
    static const char * const near name;
    static TStreamable *build();
};

inline ipstream& operator >> ( ipstream& is, TDirList& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TDirList*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TDirList& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TDirList* cl )
    { return os << (TStreamable *)cl; }

#endif
