/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#define Uses_TIDEEditWindow
#define Uses_TIDEFileEditor
#define Uses_TScrollBar
#define Uses_TIndicator
#define Uses_TStreamableClass
#define Uses_TPalette
#define Uses_TEvent
#include "IDEClass.h"

#define cpBlueEditWindow "\x08\x09\x0A\x0B\x0C\x40\x41\x42\x43\x44\x45\x46\x47\x48\x49\x4A\x4B\x4C\x4D\x3E"
#define cpCyanEditWindow "\x10\x11\x12\x13\x14\x4E\x4F\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5A\x5B\x3E"
#define cpGrayEditWindow "\x18\x19\x1A\x1B\x1C\x5C\x5D\x5E\x5F\x60\x61\x62\x63\x64\x65\x66\x67\x68\x69\x3E"

TPalette & TIDEEditWindow::getPalette() const
{
  static TPalette blue(cpBlueEditWindow,sizeof(cpBlueEditWindow)-1);
  static TPalette cyan(cpCyanEditWindow,sizeof(cpCyanEditWindow)-1);
  static TPalette gray(cpGrayEditWindow,sizeof(cpGrayEditWindow)-1);
  static TPalette * palettes[] =
  {
    &blue,
    &cyan,
    &gray
  };
  return *(palettes[palette]);
}

void TIDEEditWindow::handleEvent(TEvent & event)
{
  TEditWindow::handleEvent(event);
  if (event.what == evCommand && event.message.command == cmEditorAnswer)
    clearEvent(event);
}

TIDEEditWindow::TIDEEditWindow( const TRect& bounds,
                          const char *fileName,
                          int aNumber
                        ) :
    TEditWindow( bounds, NULL, aNumber ),
    TWindowInit( &TIDEEditWindow::initFrame )
{
  TRect r(editor->origin.x,editor->origin.y,
  editor->origin.x+editor->size.x,editor->origin.y+editor->size.y);
  TScrollBar * hScrollBar = editor->hScrollBar;
  TScrollBar * vScrollBar = editor->vScrollBar;
  TIndicator * indicator = editor->indicator;
  editor->hScrollBar = NULL;
  editor->vScrollBar = NULL;
  editor->indicator = NULL;
  remove(editor);
  delete (TFileEditor *)editor;
  editor = new TIDEFileEditor( r, hScrollBar, vScrollBar, indicator, fileName );
  insert(editor);
  helpCtx = hcIDEEditWindow;
}

TStreamable * TIDEEditWindow::build()
{
  return new TIDEEditWindow( streamableInit );
}

TIDEEditWindow::TIDEEditWindow(StreamableInit) :
  TEditWindow( streamableInit ) ,
  TWindowInit( NULL )
{
}
